/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.resources;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.web.resources.DatanodeWebHdfsMethods;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDatanodeWebHdfsMethods {
    private static final String LOGICAL_NAME = "minidfs";

    @Test
    public void testDeserializeHAToken() throws IOException {
        Configuration conf = DFSTestUtil.newHAConfiguration(LOGICAL_NAME);
        DataNode dn = (DataNode)Mockito.mock(DataNode.class);
        ((DataNode)Mockito.doReturn((Object)conf).when((Object)dn)).getConf();
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ((ServletContext)Mockito.doReturn((Object)dn).when((Object)context)).getAttribute("datanode");
        Token token = new Token();
        DatanodeWebHdfsMethods method = new DatanodeWebHdfsMethods();
        Whitebox.setInternalState((Object)method, (String)"context", (Object)context);
        Token tok2 = method.deserializeToken(token.encodeToUrlString(), LOGICAL_NAME);
        Assert.assertTrue((boolean)HAUtil.isTokenForLogicalUri((Token)tok2));
    }
}

