/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.util.VersionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestComputeInvalidateWork {
    private Configuration conf;
    private final int NUM_OF_DATANODES = 3;
    private MiniDFSCluster cluster;
    private FSNamesystem namesystem;
    private BlockManager bm;
    private DatanodeDescriptor[] nodes;

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNamesystem();
        this.bm = this.namesystem.getBlockManager();
        this.nodes = this.bm.getDatanodeManager().getHeartbeatManager().getDatanodes();
        Assert.assertEquals((long)this.nodes.length, (long)3L);
    }

    @After
    public void teardown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCompInvalidate() throws Exception {
        int blockInvalidateLimit = this.bm.getDatanodeManager().blockInvalidateLimit;
        this.namesystem.writeLock();
        try {
            for (int i = 0; i < this.nodes.length; ++i) {
                for (int j = 0; j < 3 * blockInvalidateLimit + 1; ++j) {
                    Block block = new Block((long)(i * (blockInvalidateLimit + 1) + j), 0L, 1000L);
                    this.bm.addToInvalidates(block, (DatanodeInfo)this.nodes[i]);
                }
            }
            Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)this.bm.computeInvalidateWork(4));
            Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)this.bm.computeInvalidateWork(3));
            Assert.assertEquals((long)(blockInvalidateLimit * 2), (long)this.bm.computeInvalidateWork(2));
            int workCount = this.bm.computeInvalidateWork(1);
            if (workCount == 1) {
                Assert.assertEquals((long)(blockInvalidateLimit + 1), (long)this.bm.computeInvalidateWork(2));
            } else {
                Assert.assertEquals((long)workCount, (long)blockInvalidateLimit);
                Assert.assertEquals((long)2L, (long)this.bm.computeInvalidateWork(2));
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testDatanodeReformat() throws Exception {
        this.namesystem.writeLock();
        try {
            Block block = new Block(0L, 0L, 1000L);
            this.bm.addToInvalidates(block, (DatanodeInfo)this.nodes[0]);
            this.nodes[0].setDatanodeUuidForTesting("fortesting");
            Assert.assertEquals((long)0L, (long)this.bm.computeInvalidateWork(1));
            Assert.assertEquals((long)0L, (long)this.bm.getPendingDeletionBlocksCount());
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=12000L)
    public void testDatanodeReRegistration() throws Exception {
        InvalidateBlocks invalidateBlocks;
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Path path = new Path("/testRR");
        DFSTestUtil.createFile((FileSystem)dfs, path, dfs.getDefaultBlockSize(), (short)3, 0xED0ED0L);
        for (DataNode dn : this.cluster.getDataNodes()) {
            dn.shutdown();
        }
        dfs.delete(path, false);
        this.namesystem.writeLock();
        int expected = 3;
        try {
            invalidateBlocks = (InvalidateBlocks)Whitebox.getInternalState((Object)this.cluster.getNamesystem().getBlockManager(), (String)"invalidateBlocks");
            Assert.assertEquals((String)"Expected invalidate blocks to be the number of DNs", (long)expected, (long)invalidateBlocks.numBlocks());
        }
        finally {
            this.namesystem.writeUnlock();
        }
        for (DataNode dn : this.cluster.getDataNodes()) {
            DatanodeID did = dn.getDatanodeId();
            did.setDatanodeUuidForTesting(UUID.randomUUID().toString());
            DatanodeRegistration reg = new DatanodeRegistration(did, new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), VersionInfo.getVersion());
            this.namesystem.writeLock();
            try {
                this.bm.getDatanodeManager().registerDatanode(reg);
                Assert.assertEquals((String)"Expected number of invalidate blocks to decrease", (long)(--expected), (long)invalidateBlocks.numBlocks());
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }
}

