/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeMetrics {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            long LONG_FILE_LEN = 0x80000000L;
            DFSTestUtil.createFile((FileSystem)fs, new Path("/tmp.txt"), 0x80000000L, (short)1, 1L);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"BytesWritten", (long)0x80000000L, (MetricsRecordBuilder)rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendDataPacketMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean interval = true;
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path tmpfile = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)fs, tmpfile, 1L, (short)1, 1L);
            DFSTestUtil.readFile((FileSystem)fs, tmpfile);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"SendDataPacketTransferNanosNumOps", (long)2L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"SendDataPacketBlockedOnNetworkNanosNumOps", (long)2L, (MetricsRecordBuilder)rb);
            Thread.sleep(2000L);
            String sec = "1s";
            MetricsAsserts.assertQuantileGauges((String)("SendDataPacketBlockedOnNetworkNanos" + sec), (MetricsRecordBuilder)rb);
            MetricsAsserts.assertQuantileGauges((String)("SendDataPacketTransferNanos" + sec), (MetricsRecordBuilder)rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceivePacketMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean interval = true;
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testFlushNanosMetric.txt");
            FSDataOutputStream fout = fs.create(testFile);
            fout.write(new byte[1]);
            fout.hsync();
            fout.close();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"FlushNanosNumOps", (long)2L, (MetricsRecordBuilder)dnMetrics);
            MetricsAsserts.assertCounter((String)"FsyncNanosNumOps", (long)2L, (MetricsRecordBuilder)dnMetrics);
            Thread.sleep(2000L);
            String sec = "1s";
            MetricsAsserts.assertQuantileGauges((String)("FlushNanos" + sec), (MetricsRecordBuilder)dnMetrics);
            MetricsAsserts.assertQuantileGauges((String)("FsyncNanos" + sec), (MetricsRecordBuilder)dnMetrics);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoundTripAckMetric() throws Exception {
        int datanodeCount = 2;
        boolean interval = true;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testRoundTripAckMetric.txt");
            FSDataOutputStream fsout = fs.create(testFile, (short)2);
            DFSOutputStream dout = (DFSOutputStream)fsout.getWrappedStream();
            dout.setChunksPerPacket(5);
            dout.setArtificialSlowdown(3000L);
            fsout.write(new byte[10000]);
            DatanodeInfo[] pipeline = null;
            for (int count = 0; pipeline == null && count < 5; ++count) {
                pipeline = dout.getPipeline();
                System.out.println("Waiting for pipeline to be created.");
                Thread.sleep(1000L);
            }
            void headInfo = pipeline[0];
            DataNode headNode = null;
            for (DataNode datanode : cluster.getDataNodes()) {
                if (!datanode.getDatanodeId().equals((Object)headInfo)) continue;
                headNode = datanode;
                break;
            }
            Assert.assertNotNull((String)"Could not find the head of the datanode write pipeline", headNode);
            Thread.sleep(2000L);
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)headNode.getMetrics().name());
            Assert.assertTrue((String)"Expected non-zero number of acks", (MetricsAsserts.getLongCounter((String)"PacketAckRoundTripTimeNanosNumOps", (MetricsRecordBuilder)dnMetrics) > 0L ? 1 : 0) != 0);
            MetricsAsserts.assertQuantileGauges((String)"PacketAckRoundTripTimeNanos1s", (MetricsRecordBuilder)dnMetrics);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

