/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNestedEncryptionZones {
    private File testRootDir;
    private final String TOP_EZ_KEY = "topezkey";
    private final String NESTED_EZ_KEY = "nestedezkey";
    private MiniDFSCluster cluster;
    protected DistributedFileSystem fs;
    private final Path rootDir = new Path("/");
    private final Path rawDir = new Path("/.reserved/raw/");
    private final Path topEZDir = new Path(this.rootDir, "topEZ");
    private final Path nestedEZDir = new Path(this.topEZDir, "nestedEZ");
    private final Path topEZBaseFile = new Path(this.rootDir, "topEZBaseFile");
    private Path topEZFile = new Path(this.topEZDir, "file");
    private Path topEZRawFile = new Path(this.rawDir, "topEZ/file");
    private final Path nestedEZBaseFile = new Path(this.rootDir, "nestedEZBaseFile");
    private Path nestedEZFile = new Path(this.nestedEZDir, "file");
    private Path nestedEZRawFile = new Path(this.rawDir, "topEZ/nestedEZ/file");
    private final int len = 8196;

    private String getKeyProviderURI() {
        return "jceks://file" + new Path(this.testRootDir.toString(), "test.jks").toUri();
    }

    private void setProvider() {
        this.fs.getClient().setKeyProvider(this.cluster.getNameNode().getNamesystem().getProvider());
    }

    @Before
    public void setup() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystemTestHelper fsHelper = new FileSystemTestHelper();
        String testRoot = fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
        conf.set("dfs.encryption.key.provider.uri", this.getKeyProviderURI());
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        Logger.getLogger(EncryptionZoneManager.class).setLevel(Level.TRACE);
        this.fs = this.cluster.getFileSystem();
        this.setProvider();
        DFSTestUtil.createKey("topezkey", this.cluster, (Configuration)conf);
        DFSTestUtil.createKey("nestedezkey", this.cluster, (Configuration)conf);
        this.fs.mkdir(this.topEZDir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(this.topEZDir, "topezkey");
        this.fs.mkdir(this.nestedEZDir, FsPermission.getDirDefault());
        this.cluster.getNamesystem().getFSDirectory().ezManager.setAllowNestedEZ();
        this.fs.createEncryptionZone(this.nestedEZDir, "nestedezkey");
        this.cluster.getNamesystem().getFSDirectory().ezManager.setDisallowNestedEZ();
        DFSTestUtil.createFile((FileSystem)this.fs, this.topEZBaseFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.topEZFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.nestedEZBaseFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.nestedEZFile, 8196L, (short)1, 65261L);
    }

    @Test(timeout=60000L)
    public void testNestedEncryptionZones() throws Exception {
        this.verifyEncryption();
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        this.verifyEncryption();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        this.verifyEncryption();
        Path renamedTopEZFile = new Path(this.topEZDir, "renamedFile");
        Path renamedNestedEZFile = new Path(this.nestedEZDir, "renamedFile");
        try {
            this.fs.rename(this.topEZFile, renamedTopEZFile);
            this.fs.rename(this.nestedEZFile, renamedNestedEZFile);
        }
        catch (Exception e) {
            Assert.fail((String)"Should be able to rename files within the same EZ.");
        }
        this.topEZFile = renamedTopEZFile;
        this.nestedEZFile = renamedNestedEZFile;
        this.topEZRawFile = new Path(this.rawDir, "topEZ/renamedFile");
        this.nestedEZRawFile = new Path(this.rawDir, "topEZ/nestedEZ/renamedFile");
        this.verifyEncryption();
        try {
            this.fs.rename(this.topEZFile, new Path(this.nestedEZDir, "movedTopEZFile"));
            Assert.fail((String)"Shouldn't be able to rename between top EZ and nested EZ.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("can't be moved from encryption zone " + this.topEZDir.toString() + " to encryption zone " + this.nestedEZDir.toString()));
        }
        try {
            this.fs.rename(this.nestedEZFile, new Path(this.topEZDir, "movedNestedEZFile"));
            Assert.fail((String)"Shouldn't be able to rename between top EZ and nested EZ.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("can't be moved from encryption zone " + this.nestedEZDir.toString() + " to encryption zone " + this.topEZDir.toString()));
        }
        try {
            this.fs.rename(this.nestedEZFile, new Path(this.rootDir, "movedNestedEZFile"));
            Assert.fail((String)"Shouldn't be able to move the nested EZ out of the top EZ.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("can't be moved from an encryption zone"));
        }
        Path topEZ2Dir = new Path(this.rootDir, "topEZ2");
        this.fs.mkdir(topEZ2Dir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(topEZ2Dir, "topezkey");
        try {
            this.fs.rename(topEZ2Dir, new Path(this.topEZDir, "topEZ2"));
            Assert.fail((String)"Shouldn't be able to move a non-nested EZ into another existing EZ.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("can't be moved from encryption zone " + topEZ2Dir.toString() + " to encryption zone"));
        }
        try {
            this.fs.rename(this.topEZDir, new Path(this.rootDir, "newTopEZDir"));
        }
        catch (Exception e) {
            Assert.fail((String)"Should be able to rename the root dir of an EZ.");
        }
        try {
            this.fs.rename(new Path(this.rootDir, "newTopEZDir/nestedEZDir"), new Path(this.rootDir, "newTopEZDir/newNestedEZDir"));
        }
        catch (Exception e) {
            Assert.fail((String)"Should be able to rename the nested EZ dir within the same top EZ.");
        }
    }

    private void verifyEncryption() throws Exception {
        Assert.assertEquals((String)"Top EZ dir is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.topEZDir).isEncrypted());
        Assert.assertEquals((String)"Nested EZ dir is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.nestedEZDir).isEncrypted());
        Assert.assertEquals((String)"Top zone file is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.topEZFile).isEncrypted());
        Assert.assertEquals((String)"Nested zone file is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.nestedEZFile).isEncrypted());
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, this.topEZBaseFile, this.topEZFile, 8196);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, this.nestedEZBaseFile, this.nestedEZFile, 8196);
        DFSTestUtil.verifyFilesNotEqual((FileSystem)this.fs, this.topEZRawFile, this.nestedEZRawFile, 8196);
    }
}

