/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.UnresolvedTopologyException;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDatanodeManager {
    public static final Log LOG = LogFactory.getLog(TestDatanodeManager.class);
    final int NUM_ITERATIONS = 500;

    @Test
    public void testNumVersionsReportedCorrect() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        DatanodeManager dm = new DatanodeManager((BlockManager)Mockito.mock(BlockManager.class), (Namesystem)fsn, new Configuration());
        Random rng = new Random();
        int seed = rng.nextInt();
        rng = new Random(seed);
        LOG.info((Object)("Using seed " + seed + " for testing"));
        HashMap<String, DatanodeRegistration> sIdToDnReg = new HashMap<String, DatanodeRegistration>();
        for (int i = 0; i < 500; ++i) {
            if (rng.nextBoolean() && i % 3 == 0 && sIdToDnReg.size() != 0) {
                int randomIndex = rng.nextInt() % sIdToDnReg.size();
                Iterator it = sIdToDnReg.entrySet().iterator();
                for (int j = 0; j < randomIndex - 1; ++j) {
                    it.next();
                }
                DatanodeRegistration toRemove = (DatanodeRegistration)it.next().getValue();
                LOG.info((Object)("Removing node " + toRemove.getDatanodeUuid() + " ip " + toRemove.getXferAddr() + " version : " + toRemove.getSoftwareVersion()));
                dm.removeDatanode((DatanodeID)toRemove);
                it.remove();
            } else {
                String storageID = "someStorageID" + rng.nextInt(5000);
                DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
                Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
                if (sIdToDnReg.containsKey(storageID)) {
                    dr = (DatanodeRegistration)sIdToDnReg.get(storageID);
                    if (rng.nextBoolean()) {
                        dr.setIpAddr(dr.getIpAddr() + "newIP");
                    }
                } else {
                    String ip = "someIP" + storageID;
                    Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
                    Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
                    Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
                }
                Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)("version" + rng.nextInt(5)));
                LOG.info((Object)("Registering node storageID: " + dr.getDatanodeUuid() + ", version: " + dr.getSoftwareVersion() + ", IP address: " + dr.getXferAddr()));
                dm.registerDatanode(dr);
                sIdToDnReg.put(storageID, dr);
            }
            HashMap mapToCheck = dm.getDatanodesSoftwareVersions();
            for (Map.Entry it : sIdToDnReg.entrySet()) {
                String ver = ((DatanodeRegistration)it.getValue()).getSoftwareVersion();
                if (!mapToCheck.containsKey(ver)) {
                    throw new AssertionError((Object)("The correct number of datanodes of a version was not found on iteration " + i));
                }
                mapToCheck.put(ver, (Integer)mapToCheck.get(ver) - 1);
                if ((Integer)mapToCheck.get(ver) != 0) continue;
                mapToCheck.remove(ver);
            }
            for (Map.Entry entry : mapToCheck.entrySet()) {
                LOG.info((Object)("Still in map: " + (String)entry.getKey() + " has " + entry.getValue()));
            }
            Assert.assertEquals((String)("The map of version counts returned by DatanodeManager was not what it was expected to be on iteration " + i), (long)0L, (long)mapToCheck.size());
        }
    }

    @Test(timeout=100000L)
    public void testRejectUnresolvedDatanodes() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.reject-unresolved-dn-topology-mapping", true);
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        DatanodeManager dm = new DatanodeManager((BlockManager)Mockito.mock(BlockManager.class), (Namesystem)fsn, conf);
        String storageID = "someStorageID-123";
        DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
        Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
        try {
            dm.registerDatanode(dr);
            Assert.fail((String)"Expected an UnresolvedTopologyException");
        }
        catch (UnresolvedTopologyException ute) {
            LOG.info((Object)"Expected - topology is not resolved and registration is rejected.");
        }
        catch (Exception e) {
            Assert.fail((String)"Expected an UnresolvedTopologyException");
        }
    }

    @Test
    public void testSortLocatedBlocks() throws IOException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        DatanodeManager dm = new DatanodeManager((BlockManager)Mockito.mock(BlockManager.class), (Namesystem)fsn, new Configuration());
        DatanodeInfo[] locs = new DatanodeInfo[5];
        String[] storageIDs = new String[5];
        StorageType[] storageTypes = new StorageType[]{StorageType.ARCHIVE, StorageType.DEFAULT, StorageType.DISK, StorageType.RAM_DISK, StorageType.SSD};
        for (int i = 0; i < 5; ++i) {
            String uuid = "UUID-" + i;
            String ip = "IP-" + i;
            DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
            Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)uuid);
            Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
            Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
            Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
            Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)"version1");
            dm.registerDatanode(dr);
            locs[i] = dm.getDatanode(uuid);
            storageIDs[i] = "storageID-" + i;
        }
        locs[0].setDecommissioned();
        locs[1].setDecommissioned();
        ExtendedBlock b = new ExtendedBlock("somePoolID", 1234L);
        LocatedBlock block = new LocatedBlock(b, locs, storageIDs, storageTypes);
        ArrayList<LocatedBlock> blocks = new ArrayList<LocatedBlock>();
        blocks.add(block);
        String targetIp = locs[4].getIpAddr();
        dm.sortLocatedBlocks(targetIp, blocks);
        DatanodeInfo[] sortedLocs = block.getLocations();
        storageIDs = block.getStorageIDs();
        storageTypes = block.getStorageTypes();
        Assert.assertThat((Object)sortedLocs.length, (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)storageIDs.length, (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)storageTypes.length, (Matcher)Is.is((Object)5));
        for (int i = 0; i < sortedLocs.length; ++i) {
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageID(), (Matcher)Is.is((Object)storageIDs[i]));
            Assert.assertThat((Object)((DatanodeInfoWithStorage)sortedLocs[i]).getStorageType(), (Matcher)Is.is((Object)storageTypes[i]));
        }
        Assert.assertThat((Object)sortedLocs[0].getIpAddr(), (Matcher)Is.is((Object)targetIp));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 1].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
        Assert.assertThat((Object)sortedLocs[sortedLocs.length - 2].getAdminState(), (Matcher)Is.is((Object)DatanodeInfo.AdminStates.DECOMMISSIONED));
    }

    public static class MyResolver
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return null;
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

