/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDatanodeRegister {
    public static final Log LOG = LogFactory.getLog(TestDatanodeRegister.class);
    private static final InetSocketAddress INVALID_ADDR = new InetSocketAddress("127.0.0.1", 1);
    private BPServiceActor actor;
    NamespaceInfo fakeNsInfo;
    DNConf mockDnConf;

    @Before
    public void setUp() throws IOException {
        this.mockDnConf = (DNConf)Mockito.mock(DNConf.class);
        ((DNConf)Mockito.doReturn((Object)VersionInfo.getVersion()).when((Object)this.mockDnConf)).getMinimumNameNodeVersion();
        DataNode mockDN = (DataNode)Mockito.mock(DataNode.class);
        ((DataNode)Mockito.doReturn((Object)true).when((Object)mockDN)).shouldRun();
        ((DataNode)Mockito.doReturn((Object)this.mockDnConf).when((Object)mockDN)).getDnConf();
        BPOfferService mockBPOS = (BPOfferService)Mockito.mock(BPOfferService.class);
        ((BPOfferService)Mockito.doReturn((Object)mockDN).when((Object)mockBPOS)).getDataNode();
        this.actor = new BPServiceActor(INVALID_ADDR, mockBPOS);
        this.fakeNsInfo = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        ((NamespaceInfo)Mockito.doReturn((Object)VersionInfo.getVersion()).when((Object)this.fakeNsInfo)).getSoftwareVersion();
        ((NamespaceInfo)Mockito.doReturn((Object)HdfsConstants.NAMENODE_LAYOUT_VERSION).when((Object)this.fakeNsInfo)).getLayoutVersion();
        DatanodeProtocolClientSideTranslatorPB fakeDnProt = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        Mockito.when((Object)fakeDnProt.versionRequest()).thenReturn((Object)this.fakeNsInfo);
        this.actor.setNameNode(fakeDnProt);
    }

    @Test
    public void testSoftwareVersionDifferences() throws Exception {
        Assert.assertEquals((Object)VersionInfo.getVersion(), (Object)this.actor.retrieveNamespaceInfo().getSoftwareVersion());
        ((NamespaceInfo)Mockito.doReturn((Object)"4.0.0").when((Object)this.fakeNsInfo)).getSoftwareVersion();
        ((DNConf)Mockito.doReturn((Object)"3.0.0").when((Object)this.mockDnConf)).getMinimumNameNodeVersion();
        Assert.assertEquals((Object)"4.0.0", (Object)this.actor.retrieveNamespaceInfo().getSoftwareVersion());
        ((NamespaceInfo)Mockito.doReturn((Object)"3.0.0").when((Object)this.fakeNsInfo)).getSoftwareVersion();
        ((DNConf)Mockito.doReturn((Object)"4.0.0").when((Object)this.mockDnConf)).getMinimumNameNodeVersion();
        try {
            this.actor.retrieveNamespaceInfo();
            Assert.fail((String)"Should have thrown an exception for NN with too-low version");
        }
        catch (IncorrectVersionException ive) {
            GenericTestUtils.assertExceptionContains((String)"The reported NameNode version is too low", (Throwable)ive);
            LOG.info((Object)"Got expected exception", (Throwable)ive);
        }
    }

    @Test
    public void testDifferentLayoutVersions() throws Exception {
        Assert.assertEquals((long)HdfsConstants.NAMENODE_LAYOUT_VERSION, (long)this.actor.retrieveNamespaceInfo().getLayoutVersion());
        ((NamespaceInfo)Mockito.doReturn((Object)(HdfsConstants.NAMENODE_LAYOUT_VERSION * 1000)).when((Object)this.fakeNsInfo)).getLayoutVersion();
        try {
            this.actor.retrieveNamespaceInfo();
        }
        catch (IOException e) {
            Assert.fail((String)"Should not fail to retrieve NS info from DN with different layout version");
        }
    }
}

