/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestWrapper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReservedRawPaths {
    private Configuration conf;
    private FileSystemTestHelper fsHelper;
    private MiniDFSCluster cluster;
    private HdfsAdmin dfsAdmin;
    private DistributedFileSystem fs;
    private final String TEST_KEY = "test_key";
    protected FileSystemTestWrapper fsWrapper;
    protected FileContextTestWrapper fcWrapper;

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.fsHelper = new FileSystemTestHelper();
        String testRoot = this.fsHelper.getTestRootDir();
        File testRootDir = new File(testRoot).getAbsoluteFile();
        Path jksPath = new Path(testRootDir.toString(), "test.jks");
        this.conf.set("dfs.encryption.key.provider.uri", "jceks://file" + jksPath.toUri());
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        Logger.getLogger(EncryptionZoneManager.class).setLevel(Level.TRACE);
        this.fs = this.cluster.getFileSystem();
        this.fsWrapper = new FileSystemTestWrapper((FileSystem)this.cluster.getFileSystem());
        this.fcWrapper = new FileContextTestWrapper(FileContext.getFileContext((URI)this.cluster.getURI(), (Configuration)this.conf));
        this.dfsAdmin = new HdfsAdmin(this.cluster.getURI(), this.conf);
        this.fs.getClient().setKeyProvider((KeyProvider)this.cluster.getNameNode().getNamesystem().getProvider());
        DFSTestUtil.createKey("test_key", this.cluster, this.conf);
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=120000L)
    public void testReadWriteRaw() throws Exception {
        Path baseFile = new Path("/base");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, baseFile, 8192L, (short)1, 65261L);
        Path zone = new Path("/zone");
        this.fs.mkdirs(zone);
        this.dfsAdmin.createEncryptionZone(zone, "test_key");
        Path encFile1 = new Path(zone, "myfile");
        DFSTestUtil.createFile((FileSystem)this.fs, encFile1, 8192L, (short)1, 65261L);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, baseFile, encFile1, 8192);
        Path encFile1Raw = new Path(zone, "/.reserved/raw/zone/myfile");
        DFSTestUtil.verifyFilesNotEqual((FileSystem)this.fs, encFile1Raw, encFile1, 8192);
        Path baseFileRaw = new Path(zone, "/.reserved/raw/base");
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, baseFile, baseFileRaw, 8192);
    }

    private void assertPathEquals(Path p1, Path p2) throws IOException {
        FileStatus p1Stat = this.fs.getFileStatus(p1);
        FileStatus p2Stat = this.fs.getFileStatus(p2);
        Assert.assertEquals((String)"Access times not equal", (long)p1Stat.getAccessTime(), (long)p2Stat.getAccessTime());
        Assert.assertEquals((String)"Modification times not equal", (long)p1Stat.getModificationTime(), (long)p2Stat.getModificationTime());
        Assert.assertEquals((String)"pathname1 not equal", (Object)p1, (Object)Path.getPathWithoutSchemeAndAuthority((Path)p1Stat.getPath()));
        Assert.assertEquals((String)"pathname1 not equal", (Object)p2, (Object)Path.getPathWithoutSchemeAndAuthority((Path)p2Stat.getPath()));
    }

    @Test(timeout=120000L)
    public void testGetFileStatus() throws Exception {
        Path zone = new Path("zone");
        Path slashZone = new Path("/", zone);
        this.fs.mkdirs(slashZone);
        this.dfsAdmin.createEncryptionZone(slashZone, "test_key");
        Path base = new Path("base");
        Path reservedRaw = new Path("/.reserved/raw");
        Path baseRaw = new Path(reservedRaw, base);
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, baseRaw, 8192L, (short)1, 65261L);
        this.assertPathEquals(new Path("/", base), baseRaw);
        Path ezEncFile = new Path(slashZone, base);
        Path ezRawEncFile = new Path(new Path(reservedRaw, zone), base);
        DFSTestUtil.createFile((FileSystem)this.fs, ezEncFile, 8192L, (short)1, 65261L);
        this.assertPathEquals(ezEncFile, ezRawEncFile);
    }

    @Test(timeout=120000L)
    public void testReservedRoot() throws Exception {
        Path root = new Path("/");
        Path rawRoot = new Path("/.reserved/raw");
        Path rawRootSlash = new Path("/.reserved/raw/");
        this.assertPathEquals(root, rawRoot);
        this.assertPathEquals(root, rawRootSlash);
    }

    @Test(timeout=120000L)
    public void testReservedRawMkdir() throws Exception {
        Path zone = new Path("zone");
        Path slashZone = new Path("/", zone);
        this.fs.mkdirs(slashZone);
        this.dfsAdmin.createEncryptionZone(slashZone, "test_key");
        Path rawRoot = new Path("/.reserved/raw");
        Path dir1 = new Path("dir1");
        Path rawDir1 = new Path(rawRoot, dir1);
        this.fs.mkdirs(rawDir1);
        this.assertPathEquals(rawDir1, new Path("/", dir1));
        this.fs.delete(rawDir1, true);
        Path rawZone = new Path(rawRoot, zone);
        Path rawDir1EZ = new Path(rawZone, dir1);
        this.fs.mkdirs(rawDir1EZ);
        this.assertPathEquals(rawDir1EZ, new Path(slashZone, dir1));
        this.fs.delete(rawDir1EZ, true);
    }

    @Test(timeout=120000L)
    public void testRelativePathnames() throws Exception {
        Path baseFileRaw = new Path("/.reserved/raw/base");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, baseFileRaw, 8192L, (short)1, 65261L);
        Path root = new Path("/");
        Path rawRoot = new Path("/.reserved/raw");
        this.assertPathEquals(root, new Path(rawRoot, "../raw"));
        this.assertPathEquals(root, new Path(rawRoot, "../../.reserved/raw"));
        this.assertPathEquals(baseFileRaw, new Path(rawRoot, "../raw/base"));
        this.assertPathEquals(baseFileRaw, new Path(rawRoot, "../../.reserved/raw/base"));
        this.assertPathEquals(baseFileRaw, new Path(rawRoot, "../../.reserved/raw/base/../base"));
        this.assertPathEquals(baseFileRaw, new Path("/.reserved/../.reserved/raw/../raw/base"));
    }

    @Test(timeout=120000L)
    public void testAdminAccessOnly() throws Exception {
        final Path zone = new Path("zone");
        Path slashZone = new Path("/", zone);
        this.fs.mkdirs(slashZone);
        this.dfsAdmin.createEncryptionZone(slashZone, "test_key");
        final Path base = new Path("base");
        final Path reservedRaw = new Path("/.reserved/raw");
        int len = 8192;
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem fs = TestReservedRawPaths.this.cluster.getFileSystem();
                try {
                    Path ezRawEncFile = new Path(new Path(reservedRaw, zone), base);
                    DFSTestUtil.createFile((FileSystem)fs, ezRawEncFile, 8192L, (short)1, 65261L);
                    Assert.fail((String)"access to /.reserved/raw is superuser-only operation");
                }
                catch (AccessControlException e) {
                    GenericTestUtils.assertExceptionContains((String)"Superuser privilege is required", (Throwable)e);
                }
                return null;
            }
        });
        final Path ezRawEncFile = new Path(new Path(reservedRaw, zone), base);
        DFSTestUtil.createFile((FileSystem)this.fs, ezRawEncFile, 8192L, (short)1, 65261L);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem fs = TestReservedRawPaths.this.cluster.getFileSystem();
                try {
                    fs.getFileStatus(ezRawEncFile);
                    Assert.fail((String)"access to /.reserved/raw is superuser-only operation");
                }
                catch (AccessControlException e) {
                    GenericTestUtils.assertExceptionContains((String)"Superuser privilege is required", (Throwable)e);
                }
                return null;
            }
        });
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem fs = TestReservedRawPaths.this.cluster.getFileSystem();
                try {
                    fs.listStatus(ezRawEncFile);
                    Assert.fail((String)"access to /.reserved/raw is superuser-only operation");
                }
                catch (AccessControlException e) {
                    GenericTestUtils.assertExceptionContains((String)"Superuser privilege is required", (Throwable)e);
                }
                return null;
            }
        });
        this.fs.setPermission(new Path("/"), new FsPermission(511));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem fs = TestReservedRawPaths.this.cluster.getFileSystem();
                Path d1 = new Path(reservedRaw, "dir1");
                try {
                    fs.mkdirs(d1);
                    Assert.fail((String)"access to /.reserved/raw is superuser-only operation");
                }
                catch (AccessControlException e) {
                    GenericTestUtils.assertExceptionContains((String)"Superuser privilege is required", (Throwable)e);
                }
                return null;
            }
        });
    }

    @Test(timeout=120000L)
    public void testListDotReserved() throws Exception {
        Path baseFileRaw = new Path("/.reserved/raw/base");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, baseFileRaw, 8192L, (short)1, 65261L);
        try {
            this.fs.listStatus(new Path("/.reserved"));
            Assert.fail((String)"expected FNFE");
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains((String)"/.reserved does not exist", (Throwable)e);
        }
        try {
            this.fs.listStatus(new Path("/.reserved/.inodes"));
            Assert.fail((String)"expected FNFE");
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains((String)"/.reserved/.inodes does not exist", (Throwable)e);
        }
        FileStatus[] fileStatuses = this.fs.listStatus(new Path("/.reserved/raw"));
        Assert.assertEquals((String)"expected 1 entry", (long)fileStatuses.length, (long)1L);
        GenericTestUtils.assertMatches((String)fileStatuses[0].getPath().toString(), (String)"/.reserved/raw/base");
    }

    @Test(timeout=120000L)
    public void testListRecursive() throws Exception {
        Path rootPath;
        Path p = rootPath = new Path("/");
        for (int i = 0; i < 3; ++i) {
            p = new Path(p, "dir" + i);
            this.fs.mkdirs(p);
        }
        Path curPath = new Path("/.reserved/raw");
        int cnt = 0;
        FileStatus[] fileStatuses = this.fs.listStatus(curPath);
        while (fileStatuses != null && fileStatuses.length > 0) {
            FileStatus f = fileStatuses[0];
            GenericTestUtils.assertMatches((String)f.getPath().toString(), (String)"/.reserved/raw");
            curPath = Path.getPathWithoutSchemeAndAuthority((Path)f.getPath());
            ++cnt;
            fileStatuses = this.fs.listStatus(curPath);
        }
        Assert.assertEquals((long)3L, (long)cnt);
    }
}

