/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFsVolumeList {
    private final Configuration conf = new Configuration();
    private VolumeChoosingPolicy<FsVolumeImpl> blockChooser = new RoundRobinVolumeChoosingPolicy();
    private FsDatasetImpl dataset = null;
    private String baseDir;
    private BlockScanner blockScanner;

    @Before
    public void setUp() {
        this.dataset = (FsDatasetImpl)Mockito.mock(FsDatasetImpl.class);
        this.baseDir = new FileSystemTestHelper().getTestRootDir();
        Configuration blockScannerConf = new Configuration();
        blockScannerConf.setInt("dfs.datanode.scan.period.hours", -1);
        this.blockScanner = new BlockScanner(null, blockScannerConf);
    }

    @Test
    public void testGetNextVolumeWithClosedVolume() throws IOException {
        int i;
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), this.blockScanner, this.blockChooser);
        ArrayList<FsVolumeImpl> volumes = new ArrayList<FsVolumeImpl>();
        for (i = 0; i < 3; ++i) {
            File curDir = new File(this.baseDir, "nextvolume-" + i);
            curDir.mkdirs();
            FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", curDir, this.conf, StorageType.DEFAULT);
            volume.setCapacityForTesting(0x40000000L);
            volumes.add(volume);
            volumeList.addVolume(volume.obtainReference());
        }
        ((FsVolumeImpl)volumes.get(1)).closeAndWait();
        for (i = 0; i < 10; ++i) {
            try (FsVolumeReference ref = volumeList.getNextVolume(StorageType.DEFAULT, 128L);){
                Assert.assertNotEquals((Object)ref.getVolume(), volumes.get(1));
                continue;
            }
        }
    }

    @Test
    public void testCheckDirsWithClosedVolume() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), this.blockScanner, this.blockChooser);
        ArrayList<FsVolumeImpl> volumes = new ArrayList<FsVolumeImpl>();
        for (int i = 0; i < 3; ++i) {
            File curDir = new File(this.baseDir, "volume-" + i);
            curDir.mkdirs();
            FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", curDir, this.conf, StorageType.DEFAULT);
            volumes.add(volume);
            volumeList.addVolume(volume.obtainReference());
        }
        ((FsVolumeImpl)volumes.get(1)).closeAndWait();
        volumeList.checkDirs();
    }

    @Test
    public void testReleaseVolumeRefIfNoBlockScanner() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), null, this.blockChooser);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.DEFAULT);
        FsVolumeReference ref = volume.obtainReference();
        volumeList.addVolume(ref);
        try {
            ref.close();
            Assert.fail((String)"Should throw exception because the reference is closed in VolumeList#addVolume().");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

