/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestINodeFile {
    public static final Log LOG;
    static final short BLOCKBITS = 48;
    static final long BLKSIZE_MAXVALUE = 0xFFFFFFFFFFFFL;
    private static final PermissionStatus perm;
    private short replication;
    private long preferredBlockSize = 1024L;

    INodeFile createINodeFile(short replication, long preferredBlockSize) {
        return new INodeFile(0L, null, perm, 0L, 0L, null, replication, preferredBlockSize, 0);
    }

    private static INodeFile createINodeFile(byte storagePolicyID) {
        return new INodeFile(0L, null, perm, 0L, 0L, null, 3, 1024L, storagePolicyID);
    }

    @Test
    public void testStoragePolicyID() {
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            INodeFile f = TestINodeFile.createINodeFile(i);
            Assert.assertEquals((long)i, (long)f.getStoragePolicyID());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoragePolicyIdBelowLowerBound() throws IllegalArgumentException {
        TestINodeFile.createINodeFile((byte)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoragePolicyIdAboveUpperBound() throws IllegalArgumentException {
        TestINodeFile.createINodeFile((byte)16);
    }

    @Test
    public void testReplication() {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)this.replication, (long)inf.getFileReplication());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplicationBelowLowerBound() throws IllegalArgumentException {
        this.replication = (short)-1;
        this.preferredBlockSize = 0x8000000L;
        this.createINodeFile(this.replication, this.preferredBlockSize);
    }

    @Test
    public void testPreferredBlockSize() {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)this.preferredBlockSize, (long)inf.getPreferredBlockSize());
    }

    @Test
    public void testPreferredBlockSizeUpperBound() {
        this.replication = (short)3;
        this.preferredBlockSize = 0xFFFFFFFFFFFFL;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)0xFFFFFFFFFFFFL, (long)inf.getPreferredBlockSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPreferredBlockSizeBelowLowerBound() throws IllegalArgumentException {
        this.replication = (short)3;
        this.preferredBlockSize = -1L;
        this.createINodeFile(this.replication, this.preferredBlockSize);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPreferredBlockSizeAboveUpperBound() throws IllegalArgumentException {
        this.replication = (short)3;
        this.preferredBlockSize = 0x1000000000000L;
        this.createINodeFile(this.replication, this.preferredBlockSize);
    }

    @Test
    public void testGetFullPathName() {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        inf.setLocalName(DFSUtil.string2Bytes((String)"f"));
        INodeDirectory root = new INodeDirectory(0L, INodeDirectory.ROOT_NAME, perm, 0L);
        INodeDirectory dir = new INodeDirectory(0L, DFSUtil.string2Bytes((String)"d"), perm, 0L);
        Assert.assertEquals((Object)"f", (Object)inf.getFullPathName());
        dir.addChild((INode)inf);
        Assert.assertEquals((Object)"d/f", (Object)inf.getFullPathName());
        root.addChild((INode)dir);
        Assert.assertEquals((Object)"/d/f", (Object)inf.getFullPathName());
        Assert.assertEquals((Object)"/d", (Object)dir.getFullPathName());
        Assert.assertEquals((Object)"/", (Object)root.getFullPathName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFullPathNameAfterSetQuota() throws Exception {
        long fileLen = 1024L;
        this.replication = (short)3;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(this.replication).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            FSDirectory fsdir = fsn.getFSDirectory();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            Path file = new Path(dir, "file");
            DFSTestUtil.createFile((FileSystem)dfs, file, fileLen, this.replication, 0L);
            INode fnode = fsdir.getINode(file.toString());
            Assert.assertEquals((Object)file.toString(), (Object)fnode.getFullPathName());
            dfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, (long)this.replication * fileLen * 10L);
            INodeDirectory dirNode = TestINodeFile.getDir(fsdir, dir);
            Assert.assertEquals((Object)dir.toString(), (Object)dirNode.getFullPathName());
            Assert.assertTrue((boolean)dirNode.isWithQuota());
            Path newDir = new Path("/newdir");
            Path newFile = new Path(newDir, "file");
            dfs.rename(dir, newDir, new Options.Rename[]{Options.Rename.OVERWRITE});
            fnode = fsdir.getINode(newFile.toString());
            Assert.assertEquals((Object)newFile.toString(), (Object)fnode.getFullPathName());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testConcatBlocks() {
        INodeFile origFile = this.createINodeFiles(1, "origfile")[0];
        Assert.assertEquals((String)"Number of blocks didn't match", (long)origFile.numBlocks(), (long)1L);
        INodeFile[] appendFiles = this.createINodeFiles(4, "appendfile");
        origFile.concatBlocks(appendFiles);
        Assert.assertEquals((String)"Number of blocks didn't match", (long)origFile.numBlocks(), (long)5L);
    }

    private INodeFile[] createINodeFiles(int nCount, String fileNamePrefix) {
        if (nCount <= 0) {
            return new INodeFile[1];
        }
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile[] iNodes = new INodeFile[nCount];
        for (int i = 0; i < nCount; ++i) {
            iNodes[i] = new INodeFile((long)i, null, perm, 0L, 0L, null, this.replication, this.preferredBlockSize, 0);
            iNodes[i].setLocalName(DFSUtil.string2Bytes((String)(fileNamePrefix + i)));
            BlockInfoContiguous newblock = new BlockInfoContiguous(this.replication);
            iNodes[i].addBlock(newblock);
        }
        return iNodes;
    }

    @Test
    public void testValueOf() throws IOException {
        String path = "/testValueOf";
        int replication = 3;
        INodeFile from = null;
        try {
            INodeFile.valueOf(from, (String)"/testValueOf");
            Assert.fail();
        }
        catch (FileNotFoundException fnfe) {
            Assert.assertTrue((boolean)fnfe.getMessage().contains("File does not exist"));
        }
        try {
            INodeDirectory.valueOf(from, (Object)"/testValueOf");
            Assert.fail();
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Directory does not exist"));
        }
        from = this.createINodeFile((short)3, this.preferredBlockSize);
        INodeFile f = INodeFile.valueOf((INode)from, (String)"/testValueOf");
        Assert.assertTrue((f == from ? 1 : 0) != 0);
        try {
            INodeDirectory.valueOf((INode)from, (Object)"/testValueOf");
            Assert.fail();
        }
        catch (PathIsNotDirectoryException pathIsNotDirectoryException) {
            // empty catch block
        }
        from = new INodeFile(0L, null, perm, 0L, 0L, null, 3, 1024L, 0);
        from.asFile().toUnderConstruction("client", "machine");
        f = INodeFile.valueOf((INode)from, (String)"/testValueOf");
        Assert.assertTrue((f == from ? 1 : 0) != 0);
        try {
            INodeDirectory.valueOf((INode)from, (Object)"/testValueOf");
            Assert.fail();
        }
        catch (PathIsNotDirectoryException pathIsNotDirectoryException) {
            // empty catch block
        }
        from = new INodeDirectory(0L, null, perm, 0L);
        try {
            INodeFile.valueOf((INode)from, (String)"/testValueOf");
            Assert.fail();
        }
        catch (FileNotFoundException fnfe) {
            Assert.assertTrue((boolean)fnfe.getMessage().contains("Path is not a file"));
        }
        INodeDirectory d = INodeDirectory.valueOf((INode)from, (Object)"/testValueOf");
        Assert.assertTrue((d == from ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeId() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 512);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            long lastId = fsn.dir.getLastInodeId();
            int inodeCount = 1;
            long expectedLastInodeId = 16385L;
            Assert.assertEquals((long)fsn.dir.rootDir.getId(), (long)16385L);
            Assert.assertEquals((long)expectedLastInodeId, (long)lastId);
            Assert.assertEquals((long)inodeCount, (long)fsn.dir.getInodeMapSize());
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/test1");
            Assert.assertTrue((boolean)fs.mkdirs(path));
            Assert.assertEquals((long)(++expectedLastInodeId), (long)fsn.dir.getLastInodeId());
            Assert.assertEquals((long)(++inodeCount), (long)fsn.dir.getInodeMapSize());
            NamenodeProtocols nnrpc = cluster.getNameNodeRpc();
            DFSTestUtil.createFile((FileSystem)fs, new Path("/test1/file"), 1024L, (short)1, 0L);
            Assert.assertEquals((long)(++expectedLastInodeId), (long)fsn.dir.getLastInodeId());
            Assert.assertEquals((long)(++inodeCount), (long)fsn.dir.getInodeMapSize());
            HdfsFileStatus fileStatus = nnrpc.getFileInfo("/test1/file");
            Assert.assertEquals((long)expectedLastInodeId, (long)fileStatus.getFileId());
            Path renamedPath = new Path("/test2");
            Assert.assertTrue((boolean)fs.rename(path, renamedPath));
            Assert.assertEquals((long)expectedLastInodeId, (long)fsn.dir.getLastInodeId());
            Assert.assertEquals((long)inodeCount, (long)fsn.dir.getInodeMapSize());
            Assert.assertTrue((boolean)fs.delete(renamedPath, true));
            Assert.assertEquals((long)(inodeCount -= 2), (long)fsn.dir.getInodeMapSize());
            String file1 = "/test1/file1";
            String file2 = "/test1/file2";
            DFSTestUtil.createFile((FileSystem)fs, new Path(file1), 512L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, new Path(file2), 512L, (short)1, 0L);
            Assert.assertEquals((long)(inodeCount += 3), (long)fsn.dir.getInodeMapSize());
            Assert.assertEquals((long)(expectedLastInodeId += 3L), (long)fsn.dir.getLastInodeId());
            nnrpc.concat(file2, new String[]{file1});
            Assert.assertEquals((long)(--inodeCount), (long)fsn.dir.getInodeMapSize());
            Assert.assertEquals((long)expectedLastInodeId, (long)fsn.dir.getLastInodeId());
            Assert.assertTrue((boolean)fs.delete(new Path("/test1"), true));
            Assert.assertEquals((long)(inodeCount -= 2), (long)fsn.dir.getInodeMapSize());
            cluster.restartNameNode(new String[0]);
            cluster.waitActive();
            fsn = cluster.getNamesystem();
            Assert.assertEquals((long)expectedLastInodeId, (long)fsn.dir.getLastInodeId());
            Assert.assertEquals((long)inodeCount, (long)fsn.dir.getInodeMapSize());
            DFSTestUtil.createFile((FileSystem)fs, new Path("/test2/file2"), 1024L, (short)1, 0L);
            Assert.assertEquals((long)(expectedLastInodeId += 2L), (long)fsn.dir.getLastInodeId());
            Assert.assertEquals((long)(inodeCount += 2), (long)fsn.dir.getInodeMapSize());
            FSDataOutputStream outStream = fs.create(new Path("/test3/file"));
            Assert.assertTrue((outStream != null ? 1 : 0) != 0);
            Assert.assertEquals((long)(expectedLastInodeId += 2L), (long)fsn.dir.getLastInodeId());
            Assert.assertEquals((long)(inodeCount += 2), (long)fsn.dir.getInodeMapSize());
            fsn.enterSafeMode(false);
            fsn.saveNamespace();
            fsn.leaveSafeMode();
            outStream.close();
            cluster.restartNameNode(new String[0]);
            cluster.waitActive();
            fsn = cluster.getNamesystem();
            Assert.assertEquals((long)expectedLastInodeId, (long)fsn.dir.getLastInodeId());
            Assert.assertEquals((long)inodeCount, (long)fsn.dir.getInodeMapSize());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testWriteToDeletedFile() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/test1");
        Assert.assertTrue((boolean)fs.mkdirs(path));
        int size = conf.getInt("dfs.bytes-per-checksum", 512);
        byte[] data = new byte[size];
        Path filePath = new Path("/test1/file");
        FSDataOutputStream fos = fs.create(filePath);
        fs.delete(filePath, false);
        try {
            fos.write(data, 0, data.length);
            fos.hflush();
            Assert.fail((String)"Write should fail after delete");
        }
        catch (Exception exception) {
        }
        finally {
            cluster.shutdown();
        }
    }

    private Path getInodePath(long inodeId, String remainingPath) {
        StringBuilder b = new StringBuilder();
        b.append("/").append(".reserved").append("/").append(".inodes").append("/").append(inodeId).append("/").append(remainingPath);
        Path p = new Path(b.toString());
        LOG.info((Object)("Inode path is " + p));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeIdBasedPaths() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 512);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols nnRpc = cluster.getNameNodeRpc();
            Path baseDir = this.getInodePath(16385L, "testInodeIdBasedPaths");
            Path baseDirRegPath = new Path("/testInodeIdBasedPaths");
            fs.mkdirs(baseDir);
            fs.exists(baseDir);
            long baseDirFileId = nnRpc.getFileInfo(baseDir.toString()).getFileId();
            Path testFileInodePath = this.getInodePath(baseDirFileId, "test1");
            Path testFileRegularPath = new Path(baseDir, "test1");
            int testFileBlockSize = 1024;
            FileSystemTestHelper.createFile((FileSystem)fs, (Path)testFileInodePath, (int)1, (int)1024);
            Assert.assertTrue((boolean)fs.exists(testFileInodePath));
            FsPermission perm = new FsPermission(438);
            fs.setPermission(testFileInodePath, perm);
            FileStatus fileStatus = fs.getFileStatus(testFileInodePath);
            Assert.assertEquals((Object)perm, (Object)fileStatus.getPermission());
            fs.setOwner(testFileInodePath, fileStatus.getOwner(), fileStatus.getGroup());
            fs.setTimes(testFileInodePath, 0L, 0L);
            fileStatus = fs.getFileStatus(testFileInodePath);
            Assert.assertEquals((long)0L, (long)fileStatus.getModificationTime());
            Assert.assertEquals((long)0L, (long)fileStatus.getAccessTime());
            fs.setReplication(testFileInodePath, (short)3);
            fileStatus = fs.getFileStatus(testFileInodePath);
            Assert.assertEquals((long)3L, (long)fileStatus.getReplication());
            fs.setReplication(testFileInodePath, (short)1);
            Assert.assertEquals((long)1024L, (long)nnRpc.getPreferredBlockSize(testFileInodePath.toString()));
            fs.isFileClosed(testFileInodePath);
            fs.getAclStatus(testFileInodePath);
            fs.getXAttrs(testFileInodePath);
            fs.listXAttrs(testFileInodePath);
            fs.access(testFileInodePath, FsAction.READ_WRITE);
            String invalidTarget = new Path(baseDir, "invalidTarget").toString();
            String link = new Path(baseDir, "link").toString();
            this.testInvalidSymlinkTarget(nnRpc, invalidTarget, link);
            String validTarget = "/validtarget";
            this.testValidSymlinkTarget(nnRpc, validTarget, link);
            fs.append(testFileInodePath);
            fs.recoverLease(testFileInodePath);
            LocatedBlocks l1 = nnRpc.getBlockLocations(testFileInodePath.toString(), 0L, Long.MAX_VALUE);
            LocatedBlocks l2 = nnRpc.getBlockLocations(testFileRegularPath.toString(), 0L, Long.MAX_VALUE);
            TestINodeFile.checkEquals(l1, l2);
            Path renameDst = this.getInodePath(baseDirFileId, "test2");
            fileStatus = fs.getFileStatus(testFileInodePath);
            fs.rename(testFileInodePath, renameDst);
            fs.rename(renameDst, testFileInodePath);
            Assert.assertEquals((Object)fileStatus, (Object)fs.getFileStatus(testFileInodePath));
            fs.rename(testFileInodePath, renameDst, new Options.Rename[]{Options.Rename.OVERWRITE});
            fs.rename(renameDst, testFileInodePath, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertEquals((Object)fileStatus, (Object)fs.getFileStatus(testFileInodePath));
            Assert.assertEquals((Object)fs.getContentSummary(testFileRegularPath).toString(), (Object)fs.getContentSummary(testFileInodePath).toString());
            TestINodeFile.checkEquals((RemoteIterator<LocatedFileStatus>)fs.listFiles(baseDirRegPath, false), (RemoteIterator<LocatedFileStatus>)fs.listFiles(baseDir, false));
            fs.delete(testFileInodePath, true);
            Assert.assertFalse((boolean)fs.exists(testFileInodePath));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void testInvalidSymlinkTarget(NamenodeProtocols nnRpc, String invalidTarget, String link) throws IOException {
        try {
            FsPermission perm = FsPermission.createImmutable((short)493);
            nnRpc.createSymlink(invalidTarget, link, perm, false);
            Assert.fail((String)("Symbolic link creation of target " + invalidTarget + " should fail"));
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    private void testValidSymlinkTarget(NamenodeProtocols nnRpc, String target, String link) throws IOException {
        FsPermission perm = FsPermission.createImmutable((short)493);
        nnRpc.createSymlink(target, link, perm, false);
        Assert.assertEquals((Object)target, (Object)nnRpc.getLinkTarget(link));
    }

    private static void checkEquals(LocatedBlocks l1, LocatedBlocks l2) {
        List list1 = l1.getLocatedBlocks();
        List list2 = l2.getLocatedBlocks();
        Assert.assertEquals((long)list1.size(), (long)list2.size());
        for (int i = 0; i < list1.size(); ++i) {
            LocatedBlock b1 = (LocatedBlock)list1.get(i);
            LocatedBlock b2 = (LocatedBlock)list2.get(i);
            Assert.assertEquals((Object)b1.getBlock(), (Object)b2.getBlock());
            Assert.assertEquals((long)b1.getBlockSize(), (long)b2.getBlockSize());
        }
    }

    private static void checkEquals(RemoteIterator<LocatedFileStatus> i1, RemoteIterator<LocatedFileStatus> i2) throws IOException {
        while (i1.hasNext()) {
            Assert.assertTrue((boolean)i2.hasNext());
            LocatedFileStatus l1 = (LocatedFileStatus)i1.next();
            LocatedFileStatus l2 = (LocatedFileStatus)i2.next();
            Assert.assertEquals((long)l1.getAccessTime(), (long)l2.getAccessTime());
            Assert.assertEquals((long)l1.getBlockSize(), (long)l2.getBlockSize());
            Assert.assertEquals((Object)l1.getGroup(), (Object)l2.getGroup());
            Assert.assertEquals((long)l1.getLen(), (long)l2.getLen());
            Assert.assertEquals((long)l1.getModificationTime(), (long)l2.getModificationTime());
            Assert.assertEquals((Object)l1.getOwner(), (Object)l2.getOwner());
            Assert.assertEquals((Object)l1.getPermission(), (Object)l2.getPermission());
            Assert.assertEquals((long)l1.getReplication(), (long)l2.getReplication());
        }
        Assert.assertFalse((boolean)i2.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReservedFileNames() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            this.ensureReservedFileNamesCannotBeCreated((FileSystem)fs, "/.reserved", false);
            this.ensureReservedFileNamesCannotBeCreated((FileSystem)fs, "/.reserved", false);
            Path reservedPath = new Path("/.reserved");
            FSDirectory.CHECK_RESERVED_FILE_NAMES = false;
            fs.mkdirs(reservedPath);
            Assert.assertTrue((boolean)fs.isDirectory(reservedPath));
            this.ensureReservedFileNamesCannotBeLoaded(cluster);
            FSDirectory.CHECK_RESERVED_FILE_NAMES = false;
            this.ensureClusterRestartSucceeds(cluster);
            fs.delete(reservedPath, true);
            DFSTestUtil.createFile((FileSystem)fs, reservedPath, 10L, (short)1, 0L);
            Assert.assertTrue((!fs.isDirectory(reservedPath) ? 1 : 0) != 0);
            this.ensureReservedFileNamesCannotBeLoaded(cluster);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void ensureReservedFileNamesCannotBeCreated(FileSystem fs, String name, boolean isDir) {
        Path reservedPath = new Path(name);
        try {
            if (isDir) {
                fs.mkdirs(reservedPath);
            } else {
                DFSTestUtil.createFile(fs, reservedPath, 10L, (short)1, 0L);
            }
            Assert.fail((String)((isDir ? "mkdir" : "create file") + " should be disallowed"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ensureReservedFileNamesCannotBeLoaded(MiniDFSCluster cluster) throws IOException {
        FSDirectory.CHECK_RESERVED_FILE_NAMES = true;
        this.ensureClusterRestartFails(cluster);
        FSDirectory.CHECK_RESERVED_FILE_NAMES = false;
        this.ensureClusterRestartSucceeds(cluster);
        FSDirectory.CHECK_RESERVED_FILE_NAMES = true;
        this.ensureClusterRestartFails(cluster);
    }

    private void ensureClusterRestartFails(MiniDFSCluster cluster) {
        try {
            cluster.restartNameNode(new String[0]);
            Assert.fail((String)"Cluster should not have successfully started");
        }
        catch (Exception expected) {
            LOG.info((Object)("Expected exception thrown " + expected));
        }
        Assert.assertFalse((boolean)cluster.isClusterUp());
    }

    private void ensureClusterRestartSucceeds(MiniDFSCluster cluster) throws IOException {
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
        Assert.assertTrue((boolean)cluster.isClusterUp());
    }

    private INode createTreeOfInodes(String path) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents((String)path);
        FsPermission perm = FsPermission.createImmutable((short)493);
        PermissionStatus permstatus = PermissionStatus.createImmutable((String)"", (String)"", (FsPermission)perm);
        long id = 0L;
        INodeDirectory prev = new INodeDirectory(++id, new byte[0], permstatus, 0L);
        INodeDirectory dir = null;
        for (byte[] component : components) {
            if (component.length == 0) continue;
            System.out.println("Adding component " + DFSUtil.bytes2String((byte[])component));
            dir = new INodeDirectory(++id, component, permstatus, 0L);
            prev.addChild((INode)dir, false, 0x7FFFFFFE);
            prev = dir;
        }
        return dir;
    }

    @Test
    public void testGetPathFromInode() throws QuotaExceededException {
        String path = "/a/b/c";
        INode inode = this.createTreeOfInodes(path);
        byte[][] expected = INode.getPathComponents((String)path);
        byte[][] actual = FSDirectory.getPathComponents((INode)inode);
        DFSTestUtil.checkComponentsEquals(expected, actual);
    }

    @Test
    public void testInodePath() throws IOException {
        String path = "/a/b/c";
        INode inode = this.createTreeOfInodes(path);
        FSDirectory fsd = (FSDirectory)Mockito.mock(FSDirectory.class);
        ((FSDirectory)Mockito.doReturn((Object)inode).when((Object)fsd)).getInode(Mockito.anyLong());
        Assert.assertEquals((Object)"/test", (Object)FSDirectory.resolvePath((String)"/test", (byte[][])null, (FSDirectory)fsd));
        byte[][] components = INode.getPathComponents((String)path);
        String resolvedPath = FSDirectory.resolvePath((String)path, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)path, (Object)resolvedPath);
        components = INode.getPathComponents((String)"/.reserved/.inodes/1");
        resolvedPath = FSDirectory.resolvePath((String)path, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)path, (Object)resolvedPath);
        components = INode.getPathComponents((String)"/.reserved/.inodes/1/");
        Assert.assertEquals((Object)path, (Object)resolvedPath);
        components = INode.getPathComponents((String)"/.reserved/.inodes/1/d/e/f");
        resolvedPath = FSDirectory.resolvePath((String)path, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)"/a/b/c/d/e/f", (Object)resolvedPath);
        String testPath = "/.reserved/.inodes";
        components = INode.getPathComponents((String)testPath);
        resolvedPath = FSDirectory.resolvePath((String)testPath, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)testPath, (Object)resolvedPath);
        testPath = "/.reserved/.inodes/16385";
        components = INode.getPathComponents((String)testPath);
        resolvedPath = FSDirectory.resolvePath((String)testPath, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)"/", (Object)resolvedPath);
        testPath = "/.invalid/.inodes/1";
        components = INode.getPathComponents((String)testPath);
        resolvedPath = FSDirectory.resolvePath((String)testPath, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)testPath, (Object)resolvedPath);
        ((FSDirectory)Mockito.doReturn(null).when((Object)fsd)).getInode(Mockito.anyLong());
        testPath = "/.reserved/.inodes/1234";
        components = INode.getPathComponents((String)testPath);
        try {
            String realPath = FSDirectory.resolvePath((String)testPath, (byte[][])components, (FSDirectory)fsd);
            Assert.fail((String)("Path should not be resolved:" + realPath));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
    }

    private static INodeDirectory getDir(FSDirectory fsdir, Path dir) throws IOException {
        String dirStr = dir.toString();
        return INodeDirectory.valueOf((INode)fsdir.getINode(dirStr), (Object)dirStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDotdotInodePath() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        DFSClient client = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            FSDirectory fsdir = cluster.getNamesystem().getFSDirectory();
            Path dir = new Path("/dir");
            hdfs.mkdirs(dir);
            long dirId = fsdir.getINode(dir.toString()).getId();
            long parentId = fsdir.getINode("/").getId();
            String testPath = "/.reserved/.inodes/" + dirId + "/..";
            client = new DFSClient(NameNode.getAddress((Configuration)conf), conf);
            HdfsFileStatus status = client.getFileInfo(testPath);
            Assert.assertTrue((parentId == status.getFileId() ? 1 : 0) != 0);
            testPath = "/.reserved/.inodes/" + parentId + "/..";
            status = client.getFileInfo(testPath);
            Assert.assertTrue((parentId == status.getFileId() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{client});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{client});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocationLimitInListingOps() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ls.limit", 9);
        MiniDFSCluster cluster = null;
        try {
            int i;
            DirectoryListing dl;
            int j;
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            ArrayList<String> source = new ArrayList<String>();
            hdfs.mkdirs(new Path("/tmp1"));
            hdfs.mkdirs(new Path("/tmp2"));
            source.add("f1");
            source.add("f2");
            int numEntries = source.size();
            for (int j2 = 0; j2 < numEntries; ++j2) {
                DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp1/" + (String)source.get(j2)), 4096, 2972L, 1024L, (short)3, 0L);
            }
            byte[] start = HdfsFileStatus.EMPTY_NAME;
            for (j = 0; j < numEntries; ++j) {
                dl = cluster.getNameNodeRpc().getListing("/tmp1", start, true);
                Assert.assertTrue((dl.getPartialListing().length == 1 ? 1 : 0) != 0);
                for (i = 0; i < dl.getPartialListing().length; ++i) {
                    source.remove(dl.getPartialListing()[i].getLocalName());
                }
                start = dl.getLastName();
            }
            Assert.assertTrue((source.size() == 0 ? 1 : 0) != 0);
            source.add("f1");
            source.add("f2");
            source.add("f3");
            source.add("f4");
            source.add("f5");
            source.add("f6");
            numEntries = source.size();
            for (j = 0; j < numEntries; ++j) {
                DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp2/" + (String)source.get(j)), 4096, 2972L, 1024L, (short)1, 0L);
            }
            start = HdfsFileStatus.EMPTY_NAME;
            for (j = 0; j < numEntries / 3; ++j) {
                dl = cluster.getNameNodeRpc().getListing("/tmp2", start, true);
                Assert.assertTrue((dl.getPartialListing().length == 3 ? 1 : 0) != 0);
                for (i = 0; i < dl.getPartialListing().length; ++i) {
                    source.remove(dl.getPartialListing()[i].getLocalName());
                }
                start = dl.getLastName();
            }
            Assert.assertTrue((source.size() == 0 ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilesInGetListingOps() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            FSDirectory fsdir = cluster.getNamesystem().getFSDirectory();
            hdfs.mkdirs(new Path("/tmp"));
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f1"), 0L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f2"), 0L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f3"), 0L, (short)1, 0L);
            DirectoryListing dl = cluster.getNameNodeRpc().getListing("/tmp", HdfsFileStatus.EMPTY_NAME, false);
            Assert.assertTrue((dl.getPartialListing().length == 3 ? 1 : 0) != 0);
            String f2 = new String("f2");
            dl = cluster.getNameNodeRpc().getListing("/tmp", f2.getBytes(), false);
            Assert.assertTrue((dl.getPartialListing().length == 1 ? 1 : 0) != 0);
            INode f2INode = fsdir.getINode("/tmp/f2");
            String f2InodePath = "/.reserved/.inodes/" + f2INode.getId();
            dl = cluster.getNameNodeRpc().getListing("/tmp", f2InodePath.getBytes(), false);
            Assert.assertTrue((dl.getPartialListing().length == 1 ? 1 : 0) != 0);
            hdfs.delete(new Path("/tmp/f2"), false);
            try {
                dl = cluster.getNameNodeRpc().getListing("/tmp", f2InodePath.getBytes(), false);
                Assert.fail((String)"Didn't get exception for the deleted startAfter token.");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)(e instanceof DirectoryListingStartAfterNotFoundException));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testFileUnderConstruction() {
        this.replication = (short)3;
        INodeFile file = new INodeFile(0L, null, perm, 0L, 0L, null, this.replication, 1024L, 0);
        Assert.assertFalse((boolean)file.isUnderConstruction());
        String clientName = "client";
        String clientMachine = "machine";
        file.toUnderConstruction("client", "machine");
        Assert.assertTrue((boolean)file.isUnderConstruction());
        FileUnderConstructionFeature uc = file.getFileUnderConstructionFeature();
        Assert.assertEquals((Object)"client", (Object)uc.getClientName());
        Assert.assertEquals((Object)"machine", (Object)uc.getClientMachine());
        file.toCompleteFile(Time.now());
        Assert.assertFalse((boolean)file.isUnderConstruction());
    }

    @Test
    public void testXAttrFeature() {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        XAttr xAttr = new XAttr.Builder().setNameSpace(XAttr.NameSpace.USER).setName("a1").setValue(new byte[]{49, 50, 51}).build();
        builder.add((Object)xAttr);
        XAttrFeature f = new XAttrFeature(builder.build());
        inf.addXAttrFeature(f);
        XAttrFeature f1 = inf.getXAttrFeature();
        Assert.assertEquals((Object)xAttr, (Object)f1.getXAttrs().get(0));
        inf.removeXAttrFeature();
        f1 = inf.getXAttrFeature();
        Assert.assertEquals((Object)f1, null);
    }

    static {
        FileSystem.enableSymlinks();
        LOG = LogFactory.getLog(TestINodeFile.class);
        perm = new PermissionStatus("userName", null, FsPermission.getDefault());
    }
}

