/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DecommissionManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDecommissioningStatus {
    private static final long seed = 3735928559L;
    private static final int blockSize = 8192;
    private static final int fileSize = 16384;
    private static final int numDatanodes = 2;
    private static MiniDFSCluster cluster;
    private static FileSystem fileSys;
    private static Path excludeFile;
    private static FileSystem localFileSys;
    private static Configuration conf;
    private static Path dir;
    private static Logger LOG;
    final ArrayList<String> decommissionedNodes = new ArrayList(2);

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.replication.considerLoad", false);
        localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = localFileSys.getWorkingDirectory();
        dir = new Path(workingDir, "build/test/data/work-dir/decommission");
        Assert.assertTrue((boolean)localFileSys.mkdirs(dir));
        excludeFile = new Path(dir, "exclude");
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        Path includeFile = new Path(dir, "include");
        conf.set("dfs.hosts", includeFile.toUri().getPath());
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.replication.pending.timeout-sec", 4);
        conf.setInt("dfs.namenode.replication.interval", 1);
        conf.setInt("dfs.namenode.decommission.interval", 1);
        conf.setLong("dfs.datanode.balance.bandwidthPerSec", 1L);
        TestDecommissioningStatus.writeConfigFile(localFileSys, excludeFile, null);
        TestDecommissioningStatus.writeConfigFile(localFileSys, includeFile, null);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        cluster.getNamesystem().getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
        Logger.getLogger(DecommissionManager.class).setLevel(Level.DEBUG);
        LOG = Logger.getLogger(TestDecommissioningStatus.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (localFileSys != null) {
            TestDecommissioningStatus.cleanupFile(localFileSys, dir);
        }
        if (fileSys != null) {
            fileSys.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static void writeConfigFile(FileSystem fs, Path name, ArrayList<String> nodes) throws IOException {
        if (fs.exists(name)) {
            fs.delete(name, true);
        }
        FSDataOutputStream stm = fs.create(name);
        if (nodes != null) {
            for (String node : nodes) {
                stm.writeBytes(node);
                stm.writeBytes("\n");
            }
        }
        stm.close();
    }

    private void writeFile(FileSystem fileSys, Path name, short repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private FSDataOutputStream writeIncompleteFile(FileSystem fileSys, Path name, short repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.flush();
        return stm;
    }

    private static void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private String decommissionNode(FSNamesystem namesystem, DFSClient client, FileSystem localFileSys, int nodeIndex) throws IOException {
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        String nodename = info[nodeIndex].getXferAddr();
        this.decommissionNode(namesystem, localFileSys, nodename);
        return nodename;
    }

    private void decommissionNode(FSNamesystem namesystem, FileSystem localFileSys, String dnName) throws IOException {
        System.out.println("Decommissioning node: " + dnName);
        ArrayList<String> nodes = new ArrayList<String>(this.decommissionedNodes);
        nodes.add(dnName);
        TestDecommissioningStatus.writeConfigFile(localFileSys, excludeFile, nodes);
    }

    private void checkDecommissionStatus(DatanodeDescriptor decommNode, int expectedUnderRep, int expectedDecommissionOnly, int expectedUnderRepInOpenFiles) {
        Assert.assertEquals((String)"Unexpected num under-replicated blocks", (long)expectedUnderRep, (long)decommNode.decommissioningStatus.getUnderReplicatedBlocks());
        Assert.assertEquals((String)"Unexpected number of decom-only replicas", (long)expectedDecommissionOnly, (long)decommNode.decommissioningStatus.getDecommissionOnlyReplicas());
        Assert.assertEquals((String)"Unexpected number of replicas in under-replicated open files", (long)expectedUnderRepInOpenFiles, (long)decommNode.decommissioningStatus.getUnderReplicatedInOpenFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void checkDFSAdminDecommissionStatus(List<DatanodeDescriptor> expectedDecomm, DistributedFileSystem dfs, DFSAdmin admin) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos);
        PrintStream oldOut = System.out;
        System.setOut(ps);
        try {
            void var12_14;
            admin.report(new String[]{"-decommissioning"}, 0);
            String[] lines = baos.toString().split("\n");
            Integer num = null;
            int count = 0;
            String[] stringArray = lines;
            int n = stringArray.length;
            boolean bl = false;
            while (var12_14 < n) {
                String line = stringArray[var12_14];
                if (line.startsWith("Decommissioning datanodes")) {
                    String temp = line.split(" ")[2];
                    num = Integer.parseInt((String)temp.subSequence(1, temp.length() - 2));
                }
                if (line.contains("Decommission in progress")) {
                    ++count;
                }
                ++var12_14;
            }
            Assert.assertTrue((String)"No decommissioning output", (num != null ? 1 : 0) != 0);
            Assert.assertEquals((String)"Unexpected number of decomming DNs", (long)expectedDecomm.size(), (long)num.intValue());
            Assert.assertEquals((String)"Unexpected number of decomming DNs", (long)expectedDecomm.size(), (long)count);
            ArrayList<DatanodeInfo> decomming = new ArrayList<DatanodeInfo>(Arrays.asList(dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.DECOMMISSIONING)));
            Assert.assertEquals((String)"Unexpected number of decomming DNs", (long)expectedDecomm.size(), (long)decomming.size());
            for (DatanodeID datanodeID : expectedDecomm) {
                Assert.assertTrue((String)("Did not find expected decomming DN " + datanodeID), (boolean)decomming.contains(datanodeID));
            }
        }
        finally {
            System.setOut(oldOut);
        }
    }

    @Test
    public void testDecommissionStatus() throws Exception {
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)2L, (long)info.length);
        DistributedFileSystem fileSys = cluster.getFileSystem();
        DFSAdmin admin = new DFSAdmin(cluster.getConfiguration(0));
        short replicas = 2;
        Path file1 = new Path("decommission.dat");
        this.writeFile((FileSystem)fileSys, file1, replicas);
        Path file2 = new Path("decommission1.dat");
        FSDataOutputStream st1 = this.writeIncompleteFile((FileSystem)fileSys, file2, replicas);
        for (DataNode d : cluster.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(d);
        }
        FSNamesystem fsn = cluster.getNamesystem();
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        for (int iteration = 0; iteration < 2; ++iteration) {
            String downnode = this.decommissionNode(fsn, client, localFileSys, iteration);
            dm.refreshNodes(conf);
            this.decommissionedNodes.add(downnode);
            BlockManagerTestUtil.recheckDecommissionState(dm);
            List decommissioningNodes = dm.getDecommissioningNodes();
            if (iteration == 0) {
                Assert.assertEquals((long)decommissioningNodes.size(), (long)1L);
                DatanodeDescriptor decommNode = (DatanodeDescriptor)decommissioningNodes.get(0);
                this.checkDecommissionStatus(decommNode, 3, 0, 1);
                this.checkDFSAdminDecommissionStatus(decommissioningNodes.subList(0, 1), fileSys, admin);
                continue;
            }
            Assert.assertEquals((long)decommissioningNodes.size(), (long)2L);
            DatanodeDescriptor decommNode1 = (DatanodeDescriptor)decommissioningNodes.get(0);
            DatanodeDescriptor decommNode2 = (DatanodeDescriptor)decommissioningNodes.get(1);
            this.checkDecommissionStatus(decommNode1, 3, 3, 1);
            this.checkDecommissionStatus(decommNode2, 4, 4, 2);
            this.checkDFSAdminDecommissionStatus(decommissioningNodes.subList(0, 2), fileSys, admin);
        }
        TestDecommissioningStatus.writeConfigFile(localFileSys, excludeFile, null);
        dm.refreshNodes(conf);
        st1.close();
        TestDecommissioningStatus.cleanupFile((FileSystem)fileSys, file1);
        TestDecommissioningStatus.cleanupFile((FileSystem)fileSys, file2);
    }

    @Test(timeout=120000L)
    public void testDecommissionStatusAfterDNRestart() throws Exception {
        DistributedFileSystem fileSys = cluster.getFileSystem();
        Path f = new Path("decommission.dat");
        DFSTestUtil.createFile((FileSystem)fileSys, f, 16384, 16384L, 16384L, (short)1, 3735928559L);
        RemoteIterator fileList = fileSys.listLocatedStatus(f);
        BlockLocation[] blockLocations = ((LocatedFileStatus)fileList.next()).getBlockLocations();
        String dnName = blockLocations[0].getNames()[0];
        FSNamesystem fsn = cluster.getNamesystem();
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        this.decommissionNode(fsn, localFileSys, dnName);
        dm.refreshNodes(conf);
        MiniDFSCluster.DataNodeProperties dataNodeProperties = cluster.stopDataNode(dnName);
        ArrayList dead = new ArrayList();
        while (true) {
            dm.fetchDatanodes(null, dead, false);
            if (dead.size() == 1) break;
            Thread.sleep(1000L);
        }
        BlockManagerTestUtil.checkHeartbeat(fsn.getBlockManager());
        BlockManagerTestUtil.recheckDecommissionState(dm);
        Assert.assertTrue((String)"the node should be DECOMMISSION_IN_PROGRESSS", (boolean)((DatanodeDescriptor)dead.get(0)).isDecommissionInProgress());
        List decomlist = dm.getDecommissioningNodes();
        Assert.assertTrue((String)"The node should be be decommissioning", (decomlist.size() == 1 ? 1 : 0) != 0);
        TestDecommissioningStatus.cleanupFile((FileSystem)fileSys, f);
        BlockManagerTestUtil.recheckDecommissionState(dm);
        Assert.assertTrue((String)"the node should be decommissioned", (boolean)((DatanodeDescriptor)dead.get(0)).isDecommissioned());
        cluster.restartDataNode(dataNodeProperties, true);
        cluster.waitActive();
        TestDecommissioningStatus.writeConfigFile(localFileSys, excludeFile, null);
        dm.refreshNodes(conf);
    }

    @Test(timeout=120000L)
    public void testDecommissionDeadDN() throws Exception {
        Logger log = Logger.getLogger(DecommissionManager.class);
        log.setLevel(Level.DEBUG);
        DatanodeID dnID = cluster.getDataNodes().get(0).getDatanodeId();
        String dnName = dnID.getXferAddr();
        MiniDFSCluster.DataNodeProperties stoppedDN = cluster.stopDataNode(0);
        DFSTestUtil.waitForDatanodeState(cluster, dnID.getDatanodeUuid(), false, 30000);
        FSNamesystem fsn = cluster.getNamesystem();
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        DatanodeDescriptor dnDescriptor = dm.getDatanode(dnID);
        this.decommissionNode(fsn, localFileSys, dnName);
        dm.refreshNodes(conf);
        BlockManagerTestUtil.recheckDecommissionState(dm);
        Assert.assertTrue((boolean)dnDescriptor.isDecommissioned());
        cluster.restartDataNode(stoppedDN, true);
        cluster.waitActive();
        TestDecommissioningStatus.writeConfigFile(localFileSys, excludeFile, null);
        dm.refreshNodes(conf);
    }

    @Test(timeout=120000L)
    public void testDecommissionLosingData() throws Exception {
        ArrayList<String> nodes = new ArrayList<String>(2);
        FSNamesystem fsn = cluster.getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dm = bm.getDatanodeManager();
        Path file1 = new Path("decommissionLosingData.dat");
        this.writeFile(fileSys, file1, (short)2);
        Thread.sleep(1000L);
        LOG.info((Object)"Shutdown dn1");
        DatanodeID dnID = cluster.getDataNodes().get(1).getDatanodeId();
        String dnName = dnID.getXferAddr();
        DatanodeDescriptor dnDescriptor1 = dm.getDatanode(dnID);
        nodes.add(dnName);
        MiniDFSCluster.DataNodeProperties stoppedDN1 = cluster.stopDataNode(1);
        DFSTestUtil.waitForDatanodeState(cluster, dnID.getDatanodeUuid(), false, 30000);
        LOG.info((Object)"Shutdown dn0");
        dnID = cluster.getDataNodes().get(0).getDatanodeId();
        dnName = dnID.getXferAddr();
        DatanodeDescriptor dnDescriptor0 = dm.getDatanode(dnID);
        nodes.add(dnName);
        MiniDFSCluster.DataNodeProperties stoppedDN0 = cluster.stopDataNode(0);
        DFSTestUtil.waitForDatanodeState(cluster, dnID.getDatanodeUuid(), false, 30000);
        LOG.info((Object)"Decommissioning nodes");
        TestDecommissioningStatus.writeConfigFile(localFileSys, excludeFile, nodes);
        dm.refreshNodes(conf);
        BlockManagerTestUtil.recheckDecommissionState(dm);
        Assert.assertTrue((boolean)dnDescriptor0.isDecommissioned());
        Assert.assertTrue((boolean)dnDescriptor1.isDecommissioned());
        long missingBlocks = bm.getMissingBlocksCount();
        long underreplicated = bm.getUnderReplicatedBlocksCount();
        Assert.assertTrue((missingBlocks > 0L ? 1 : 0) != 0);
        Assert.assertTrue((underreplicated > 0L ? 1 : 0) != 0);
        LOG.info((Object)"Bring back dn0");
        cluster.restartDataNode(stoppedDN0, true);
        while ((dnID = cluster.getDataNodes().get(0).getDatanodeId()) == null) {
        }
        dnDescriptor0 = dm.getDatanode(dnID);
        while (dnDescriptor0.numBlocks() == 0) {
            Thread.sleep(100L);
        }
        LOG.info((Object)"Bring back dn1");
        cluster.restartDataNode(stoppedDN1, true);
        while ((dnID = cluster.getDataNodes().get(1).getDatanodeId()) == null) {
        }
        dnDescriptor1 = dm.getDatanode(dnID);
        while (dnDescriptor1.numBlocks() == 0) {
            Thread.sleep(100L);
        }
        Thread.sleep(2000L);
        Assert.assertEquals((long)underreplicated, (long)bm.getUnderReplicatedBlocksCount());
        LOG.info((Object)"Starting two more nodes");
        cluster.startDataNodes(conf, 2, true, null, null);
        cluster.waitActive();
        int count = 0;
        while ((bm.getUnderReplicatedBlocksCount() > 0L || bm.getPendingReplicationBlocksCount() > 0L) && count++ < 10) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((long)0L, (long)bm.getUnderReplicatedBlocksCount());
        Assert.assertEquals((long)0L, (long)bm.getPendingReplicationBlocksCount());
        Assert.assertEquals((long)0L, (long)bm.getMissingBlocksCount());
        dnID = cluster.getDataNodes().get(3).getDatanodeId();
        cluster.stopDataNode(3);
        DFSTestUtil.waitForDatanodeState(cluster, dnID.getDatanodeUuid(), false, 30000);
        dnID = cluster.getDataNodes().get(2).getDatanodeId();
        cluster.stopDataNode(2);
        DFSTestUtil.waitForDatanodeState(cluster, dnID.getDatanodeUuid(), false, 30000);
        TestDecommissioningStatus.writeConfigFile(localFileSys, excludeFile, null);
        dm.refreshNodes(conf);
        fileSys.delete(file1, false);
    }
}

