/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestNameNodeHttpServer {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestNameNodeHttpServer.class.getSimpleName();
    private static String keystoresDir;
    private static String sslConfDir;
    private static Configuration conf;
    private static URLConnectionFactory connectionFactory;
    private final HttpConfig.Policy policy;

    @Parameterized.Parameters
    public static Collection<Object[]> policy() {
        Object[][] params = new Object[][]{{HttpConfig.Policy.HTTP_ONLY}, {HttpConfig.Policy.HTTPS_ONLY}, {HttpConfig.Policy.HTTP_AND_HTTPS}};
        return Arrays.asList(params);
    }

    public TestNameNodeHttpServer(HttpConfig.Policy policy) {
        this.policy = policy;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        conf = new Configuration();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestNameNodeHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @Test
    public void testHttpPolicy() throws Exception {
        conf.set("dfs.http.policy", this.policy.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        InetSocketAddress addr = InetSocketAddress.createUnresolved("localhost", 0);
        NameNodeHttpServer server = null;
        try {
            server = new NameNodeHttpServer(conf, null, addr);
            server.start();
            Assert.assertTrue((boolean)TestNameNodeHttpServer.implies(this.policy.isHttpEnabled(), TestNameNodeHttpServer.canAccess("http", server.getHttpAddress())));
            Assert.assertTrue((boolean)TestNameNodeHttpServer.implies(!this.policy.isHttpEnabled(), server.getHttpAddress() == null));
            Assert.assertTrue((boolean)TestNameNodeHttpServer.implies(this.policy.isHttpsEnabled(), TestNameNodeHttpServer.canAccess("https", server.getHttpsAddress())));
            Assert.assertTrue((boolean)TestNameNodeHttpServer.implies(!this.policy.isHttpsEnabled(), server.getHttpsAddress() == null));
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private static boolean canAccess(String scheme, InetSocketAddress addr) {
        if (addr == null) {
            return false;
        }
        try {
            URL url = new URL(scheme + "://" + NetUtils.getHostPortString((InetSocketAddress)addr));
            URLConnection conn = connectionFactory.openConnection(url);
            conn.connect();
            conn.getContent();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean implies(boolean a, boolean b) {
        return !a || b;
    }
}

