/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageReconstructor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewer;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewerPB;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestOfflineImageViewer {
    private static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final int NUM_DIRS = 3;
    private static final int FILES_PER_DIR = 4;
    private static final String TEST_RENEWER = "JobTracker";
    private static File originalFsimage = null;
    static final HashMap<String, FileStatus> writtenFiles = Maps.newHashMap();
    static int dirCount = 0;
    private static File tempDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        tempDir = Files.createTempDir();
        MiniDFSCluster cluster = null;
        try {
            Path delegationTokens;
            Configuration conf = new Configuration();
            conf.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
            conf.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
            conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            conf.setBoolean("dfs.namenode.acls.enabled", true);
            conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            int i = 0;
            while (i < 3) {
                Path dir = new Path("/dir" + i);
                hdfs.mkdirs(dir);
                writtenFiles.put(dir.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, dir.toString()));
                for (int j = 0; j < 4; ++j) {
                    Path file = new Path(dir, "file" + j);
                    FSDataOutputStream o = hdfs.create(file);
                    o.write(23);
                    o.close();
                    writtenFiles.put(file.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, file.toString()));
                }
                ++i;
                ++dirCount;
            }
            Path emptydir = new Path("/emptydir");
            hdfs.mkdirs(emptydir);
            ++dirCount;
            writtenFiles.put(emptydir.toString(), hdfs.getFileStatus(emptydir));
            Path invalidXMLDir = new Path("/dirContainingInvalidXMLChar\u0000here");
            hdfs.mkdirs(invalidXMLDir);
            ++dirCount;
            for (Path t : delegationTokens = hdfs.addDelegationTokens(TEST_RENEWER, null)) {
                LOG.debug((Object)("got token " + t));
            }
            Path src = new Path("/src");
            hdfs.mkdirs(src);
            ++dirCount;
            writtenFiles.put(src.toString(), hdfs.getFileStatus(src));
            Path orig = new Path("/src/orig");
            hdfs.mkdirs(orig);
            hdfs.allowSnapshot(src);
            hdfs.createSnapshot(src, "snapshot");
            Path dst = new Path("/dst");
            hdfs.rename(orig, dst);
            ++dirCount;
            writtenFiles.put(dst.toString(), hdfs.getFileStatus(dst));
            Path xattr = new Path("/xattr");
            hdfs.mkdirs(xattr);
            ++dirCount;
            hdfs.setXAttr(xattr, "user.a1", new byte[]{49, 50, 51});
            hdfs.setXAttr(xattr, "user.a2", new byte[]{55, 56, 57});
            hdfs.setXAttr(xattr, "user.a3", null);
            hdfs.setXAttr(xattr, "user.a4", new byte[]{-61, 40});
            writtenFiles.put(xattr.toString(), hdfs.getFileStatus(xattr));
            hdfs.setAcl(xattr, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug((Object)("original FS image file is " + originalFsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        FileUtils.deleteQuietly((File)tempDir);
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    private static FileStatus pathToFileEntry(FileSystem hdfs, String file) throws IOException {
        return hdfs.getFileStatus(new Path(file));
    }

    @Test(expected=IOException.class)
    public void testTruncatedFSImage() throws IOException {
        File truncatedFile = new File(tempDir, "truncatedFsImage");
        PrintStream output = new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        this.copyPartOfFile(originalFsimage, truncatedFile);
        new FileDistributionCalculator(new Configuration(), 0L, 0, output).visit(new RandomAccessFile(truncatedFile, "r"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartOfFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        int MAX_BYTES = 700;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            in.getChannel().transferTo(0L, 700L, out.getChannel());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }

    @Test
    public void testFileDistributionCalculator() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream o = new PrintStream(output);
        new FileDistributionCalculator(new Configuration(), 0L, 0, o).visit(new RandomAccessFile(originalFsimage, "r"));
        o.close();
        String outputString = output.toString();
        Pattern p = Pattern.compile("totalFiles = (\\d+)\n");
        Matcher matcher = p.matcher(outputString);
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalFiles = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)12L, (long)totalFiles);
        p = Pattern.compile("totalDirectories = (\\d+)\n");
        matcher = p.matcher(outputString);
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalDirs = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)(dirCount + 1), (long)totalDirs);
        FileStatus maxFile = Collections.max(writtenFiles.values(), new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus first, FileStatus second) {
                return first.getLen() < second.getLen() ? -1 : (first.getLen() == second.getLen() ? 0 : 1);
            }
        });
        p = Pattern.compile("maxFileSize = (\\d+)\n");
        matcher = p.matcher(output.toString("UTF-8"));
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)maxFile.getLen(), (long)Long.parseLong(matcher.group(1)));
    }

    @Test
    public void testFileDistributionCalculatorWithOptions() throws Exception {
        int status = OfflineImageViewerPB.run((String[])new String[]{"-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8"});
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testPBImageXmlWriter() throws IOException, SAXException, ParserConfigurationException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream o = new PrintStream(output);
        PBImageXmlWriter v = new PBImageXmlWriter(new Configuration(), o);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser parser = spf.newSAXParser();
        String xml = output.toString();
        parser.parse(new InputSource(new StringReader(xml)), new DefaultHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebImageViewer() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            FileStatus[] statuses = webhdfs.listStatus(new Path("/"));
            Assert.assertEquals((long)dirCount, (long)statuses.length);
            statuses = webhdfs.listStatus(new Path("/dir0"));
            Assert.assertEquals((long)4L, (long)statuses.length);
            FileStatus status = webhdfs.listStatus(new Path("/dir0/file0"))[0];
            FileStatus expected = writtenFiles.get("/dir0/file0");
            TestOfflineImageViewer.compareFile(expected, status);
            statuses = webhdfs.listStatus(new Path("/emptydir"));
            Assert.assertEquals((long)0L, (long)statuses.length);
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/invalid/?op=LISTSTATUS");
            this.verifyHttpResponseCode(404, url);
            url = new URL("http://localhost:" + port + "/foo");
            this.verifyHttpResponseCode(404, url);
            status = webhdfs.getFileStatus(new Path("/dir0/file0"));
            TestOfflineImageViewer.compareFile(expected, status);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/invalid/?op=GETFILESTATUS");
            this.verifyHttpResponseCode(404, url);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/?op=INVALID");
            this.verifyHttpResponseCode(400, url);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/?op=LISTSTATUS");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.connect();
            Assert.assertEquals((long)405L, (long)connection.getResponseCode());
        }
    }

    @Test
    public void testPBDelimitedWriter() throws IOException, InterruptedException {
        this.testPBDelimitedWriter("");
        this.testPBDelimitedWriter(new FileSystemTestHelper().getTestRootDir() + "/delimited.db");
    }

    @Test
    public void testInvalidProcessorOption() throws Exception {
        int status = OfflineImageViewerPB.run((String[])new String[]{"-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "invalid"});
        Assert.assertTrue((String)"Exit code returned for invalid processor option is incorrect", (status != 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineImageViewerHelpMessage() throws Throwable {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        try {
            System.setOut(out);
            int status = OfflineImageViewerPB.run((String[])new String[]{"-h"});
            Assert.assertTrue((String)"Exit code returned for help option is incorrect", (status == 0 ? 1 : 0) != 0);
            Assert.assertFalse((String)"Invalid Command error displayed when help option is passed.", (boolean)bytes.toString().contains("Error parsing command-line options"));
            status = OfflineImageViewerPB.run((String[])new String[]{"-h", "-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8"});
            Assert.assertTrue((String)"Exit code returned for help with other option is incorrect", (status == -1 ? 1 : 0) != 0);
        }
        finally {
            System.setOut(oldOut);
            IOUtils.closeStream((Closeable)out);
        }
    }

    private void testPBDelimitedWriter(String db) throws IOException, InterruptedException {
        Object v;
        String DELIMITER = "\t";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (PrintStream o = new PrintStream(output);){
            v = new PBImageDelimitedTextWriter(o, "\t", db);
            v.visit(new RandomAccessFile(originalFsimage, "r"));
        }
        HashSet<String> fileNames = new HashSet<String>();
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        v = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            boolean header = true;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                String[] fields = line.split("\t");
                Assert.assertEquals((long)12L, (long)fields.length);
                if (!header) {
                    fileNames.add(fields[0]);
                }
                header = false;
            }
        }
        catch (Throwable throwable) {
            v = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (v != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)v).addSuppressed(throwable);
                    }
                } else {
                    input.close();
                }
            }
        }
        Iterator it = fileNames.iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            if (filename.startsWith("/dirContainingInvalidXMLChar")) {
                it.remove();
                continue;
            }
            if (!filename.equals("/")) continue;
            it.remove();
        }
        Assert.assertEquals(writtenFiles.keySet(), fileNames);
    }

    private static void compareFile(FileStatus expected, FileStatus status) {
        Assert.assertEquals((long)expected.getAccessTime(), (long)status.getAccessTime());
        Assert.assertEquals((long)expected.getBlockSize(), (long)status.getBlockSize());
        Assert.assertEquals((Object)expected.getGroup(), (Object)status.getGroup());
        Assert.assertEquals((long)expected.getLen(), (long)status.getLen());
        Assert.assertEquals((long)expected.getModificationTime(), (long)status.getModificationTime());
        Assert.assertEquals((Object)expected.getOwner(), (Object)status.getOwner());
        Assert.assertEquals((Object)expected.getPermission(), (Object)status.getPermission());
        Assert.assertEquals((long)expected.getReplication(), (long)status.getReplication());
        Assert.assertEquals((Object)expected.isDirectory(), (Object)status.isDirectory());
    }

    private void verifyHttpResponseCode(int expectedCode, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        Assert.assertEquals((long)expectedCode, (long)connection.getResponseCode());
    }

    @Test
    public void testReverseXmlRoundTrip() throws Throwable {
        GenericTestUtils.setLogLevel((Log)OfflineImageReconstructor.LOG, (Level)Level.TRACE);
        File reverseImageXml = new File(tempDir, "reverseImage.xml");
        File reverseImage = new File(tempDir, "reverseImage");
        File reverseImage2Xml = new File(tempDir, "reverseImage2.xml");
        LOG.info((Object)("Creating reverseImage.xml=" + reverseImageXml.getAbsolutePath() + ", reverseImage=" + reverseImage.getAbsolutePath() + ", reverseImage2Xml=" + reverseImage2Xml.getAbsolutePath()));
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "XML", "-i", originalFsimage.getAbsolutePath(), "-o", reverseImageXml.getAbsolutePath()}) != 0) {
            throw new IOException("oiv returned failure creating first XML file.");
        }
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "ReverseXML", "-i", reverseImageXml.getAbsolutePath(), "-o", reverseImage.getAbsolutePath()}) != 0) {
            throw new IOException("oiv returned failure recreating fsimage file.");
        }
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "XML", "-i", reverseImage.getAbsolutePath(), "-o", reverseImage2Xml.getAbsolutePath()}) != 0) {
            throw new IOException("oiv returned failure creating second XML file.");
        }
        Assert.assertEquals((Object)"", (Object)GenericTestUtils.getFilesDiff((File)reverseImageXml, (File)reverseImage2Xml));
    }

    @Test
    public void testReverseXmlWrongLayoutVersion() throws Throwable {
        File imageWrongVersion = new File(tempDir, "imageWrongVersion.xml");
        try (PrintWriter writer = new PrintWriter(imageWrongVersion, "UTF-8");){
            writer.println("<?xml version=\"1.0\"?>");
            writer.println("<fsimage>");
            writer.println("<version>");
            writer.println(String.format("<layoutVersion>%d</layoutVersion>", NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION + 1));
            writer.println("<onDiskVersion>1</onDiskVersion>");
            writer.println("<oivRevision>545bbef596c06af1c3c8dca1ce29096a64608478</oivRevision>");
            writer.println("</version>");
            writer.println("</fsimage>");
        }
        try {
            OfflineImageReconstructor.run((String)imageWrongVersion.getAbsolutePath(), (String)(imageWrongVersion.getAbsolutePath() + ".out"));
            Assert.fail((String)"Expected OfflineImageReconstructor to fail with version mismatch.");
        }
        catch (Throwable t) {
            GenericTestUtils.assertExceptionContains((String)"Layout version mismatch.", (Throwable)t);
        }
    }

    @Test
    public void testFileDistributionCalculatorForException() throws Exception {
        File fsimageFile = null;
        Configuration conf = new Configuration();
        HashMap files = Maps.newHashMap();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();){
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            hdfs.mkdirs(dir);
            files.put(dir.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, dir.toString()));
            for (int i = 0; i < 4; ++i) {
                Path file = new Path(dir, "file" + i);
                DFSTestUtil.createFile((FileSystem)hdfs, file, 6 * i + 3, (short)1, 0L);
                files.put(file.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, file.toString()));
            }
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            fsimageFile = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (fsimageFile == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
        }
        int status = OfflineImageViewerPB.run((String[])new String[]{"-i", fsimageFile.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "23", "-step", "4"});
        Assert.assertEquals((long)0L, (long)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineImageViewerMaxSizeAndStepOptions() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        try {
            System.setOut(out);
            OfflineImageViewer.main((String[])new String[]{"-i", "-", "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8", "-h"});
            Assert.assertFalse((boolean)bytes.toString().contains("Error parsing command-line options: "));
        }
        finally {
            System.setOut(oldOut);
            IOUtils.closeStream((Closeable)out);
        }
    }
}

