/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockPlacementStatusWithUpgradeDomain
implements BlockPlacementStatus {
    private final BlockPlacementStatus parentBlockPlacementStatus;
    private final Set<String> upgradeDomains;
    private final int numberOfReplicas;
    private final int upgradeDomainFactor;

    public BlockPlacementStatusWithUpgradeDomain(BlockPlacementStatus parentBlockPlacementStatus, Set<String> upgradeDomains, int numberOfReplicas, int upgradeDomainFactor) {
        this.parentBlockPlacementStatus = parentBlockPlacementStatus;
        this.upgradeDomains = upgradeDomains;
        this.numberOfReplicas = numberOfReplicas;
        this.upgradeDomainFactor = upgradeDomainFactor;
    }

    @Override
    public boolean isPlacementPolicySatisfied() {
        return this.parentBlockPlacementStatus.isPlacementPolicySatisfied() && this.isUpgradeDomainPolicySatisfied();
    }

    private boolean isUpgradeDomainPolicySatisfied() {
        if (this.numberOfReplicas <= this.upgradeDomainFactor) {
            return this.numberOfReplicas == this.upgradeDomains.size();
        }
        return this.upgradeDomains.size() >= this.upgradeDomainFactor;
    }

    @Override
    public String getErrorDescription() {
        if (this.isPlacementPolicySatisfied()) {
            return null;
        }
        StringBuilder errorDescription = new StringBuilder();
        if (!this.parentBlockPlacementStatus.isPlacementPolicySatisfied()) {
            errorDescription.append(this.parentBlockPlacementStatus.getErrorDescription());
        }
        if (!this.isUpgradeDomainPolicySatisfied()) {
            if (errorDescription.length() != 0) {
                errorDescription.append(" ");
            }
            errorDescription.append("The block has " + this.numberOfReplicas + " replicas. But it only has " + this.upgradeDomains.size() + " upgrade domains " + this.upgradeDomains + ".");
        }
        return errorDescription.toString();
    }
}

