/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestNameNodeMetricsLogger {
    static final Log LOG = LogFactory.getLog(TestNameNodeMetricsLogger.class);
    static final Random random = new Random(System.currentTimeMillis());
    @Rule
    public Timeout timeout = new Timeout(300000);

    @Test
    public void testMetricsLoggerOnByDefault() throws IOException {
        NameNode nn = this.makeNameNode(true);
        Assert.assertNotNull((Object)nn.metricsLoggerTimer);
    }

    @Test
    public void testDisableMetricsLogger() throws IOException {
        NameNode nn = this.makeNameNode(false);
        Assert.assertNull((Object)nn.metricsLoggerTimer);
    }

    @Test
    public void testMetricsLoggerIsAsync() throws IOException {
        this.makeNameNode(true);
        Logger logger = ((Log4JLogger)NameNode.MetricsLog).getLogger();
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        Assert.assertTrue((boolean)(appenders.get(0) instanceof AsyncAppender));
    }

    @Test
    public void testMetricsLogOutput() throws IOException, InterruptedException, TimeoutException {
        TestFakeMetric metricsProvider = new TestFakeMetric();
        MBeans.register((String)this.getClass().getSimpleName(), (String)"DummyMetrics", (Object)metricsProvider);
        this.makeNameNode(true);
        final PatternMatchingAppender appender = new PatternMatchingAppender("^.*FakeMetric42.*$");
        this.addAppender(NameNode.MetricsLog, (Appender)appender);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return appender.isMatched();
            }
        }, (int)1000, (int)60000);
    }

    private NameNode makeNameNode(boolean enableMetricsLogging) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://localhost:" + this.getRandomPort());
        conf.set("dfs.namenode.http-address", "0.0.0.0:" + this.getRandomPort());
        conf.setInt("dfs.namenode.metrics.logger.period.seconds", enableMetricsLogging ? 1 : 0);
        return new TestNameNode((Configuration)conf);
    }

    private int getRandomPort() throws IOException {
        return ServerSocketUtil.getPort((int)0, (int)10);
    }

    private void addAppender(Log log, Appender appender) {
        Logger logger = ((Log4JLogger)log).getLogger();
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        ((AsyncAppender)appenders.get(0)).addAppender(appender);
    }

    public static class PatternMatchingAppender
    extends AppenderSkeleton {
        private final Pattern pattern;
        private volatile boolean matched;

        public PatternMatchingAppender(String pattern) {
            this.pattern = Pattern.compile(pattern);
            this.matched = false;
        }

        public boolean isMatched() {
            return this.matched;
        }

        protected void append(LoggingEvent event) {
            if (this.pattern.matcher(event.getMessage().toString()).matches()) {
                this.matched = true;
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }

    public static class TestFakeMetric
    implements TestFakeMetricMXBean {
        @Override
        public int getFakeMetric42() {
            return 0;
        }
    }

    public static interface TestFakeMetricMXBean {
        public int getFakeMetric42();
    }

    private static class TestNameNode
    extends NameNode {
        protected void loadNamesystem(Configuration conf) throws IOException {
            this.namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        }

        public TestNameNode(Configuration conf) throws IOException {
            super(conf);
        }
    }
}

