/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;

public class FinalizedReplica
extends ReplicaInfo {
    public FinalizedReplica(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir) {
        super(blockId, len, genStamp, vol, dir);
    }

    public FinalizedReplica(Block block, FsVolumeSpi vol, File dir) {
        super(block, vol, dir);
    }

    public FinalizedReplica(FinalizedReplica from) {
        super(from);
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    @Override
    public long getVisibleLength() {
        return this.getNumBytes();
    }

    @Override
    public long getBytesOnDisk() {
        return this.getNumBytes();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public ChunkChecksum getLastChecksumAndDataLen() throws IOException {
        ChunkChecksum chunkChecksum = null;
        try {
            byte[] lastChecksum = this.getVolume().loadLastPartialChunkChecksum(this.getBlockFile(), this.getMetaFile());
            if (lastChecksum != null) {
                chunkChecksum = new ChunkChecksum(this.getVisibleLength(), lastChecksum);
            }
        }
        catch (FileNotFoundException e) {
            DataNode.LOG.warn("meta file " + this.getMetaFile() + " is missing!");
        }
        catch (IOException ioe) {
            DataNode.LOG.warn("Unable to read checksum from meta file " + this.getMetaFile(), (Throwable)ioe);
        }
        return chunkChecksum;
    }
}

