/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MountTableStoreImpl
extends MountTableStore {
    public MountTableStoreImpl(StateStoreDriver driver) {
        super(driver);
    }

    @Override
    public AddMountTableEntryResponse addMountTableEntry(AddMountTableEntryRequest request) throws IOException {
        boolean status = this.getDriver().put(request.getEntry(), false, true);
        AddMountTableEntryResponse response = AddMountTableEntryResponse.newInstance();
        response.setStatus(status);
        return response;
    }

    @Override
    public UpdateMountTableEntryResponse updateMountTableEntry(UpdateMountTableEntryRequest request) throws IOException {
        MountTable entry = request.getEntry();
        boolean status = this.getDriver().put(entry, true, true);
        UpdateMountTableEntryResponse response = UpdateMountTableEntryResponse.newInstance();
        response.setStatus(status);
        return response;
    }

    @Override
    public RemoveMountTableEntryResponse removeMountTableEntry(RemoveMountTableEntryRequest request) throws IOException {
        String srcPath = request.getSrcPath();
        MountTable partial = MountTable.newInstance();
        partial.setSourcePath(srcPath);
        Query<MountTable> query = new Query<MountTable>(partial);
        int removedRecords = this.getDriver().remove(this.getRecordClass(), query);
        boolean status = removedRecords == 1;
        RemoveMountTableEntryResponse response = RemoveMountTableEntryResponse.newInstance();
        response.setStatus(status);
        return response;
    }

    @Override
    public GetMountTableEntriesResponse getMountTableEntries(GetMountTableEntriesRequest request) throws IOException {
        List<MountTable> records = this.getCachedRecords();
        Collections.sort(records);
        String reqSrcPath = request.getSrcPath();
        if (reqSrcPath != null && !reqSrcPath.isEmpty()) {
            Iterator it = records.iterator();
            while (it.hasNext()) {
                MountTable record = (MountTable)it.next();
                String srcPath = record.getSourcePath();
                if (srcPath.startsWith(reqSrcPath)) continue;
                it.remove();
            }
        }
        GetMountTableEntriesResponse response = GetMountTableEntriesResponse.newInstance();
        response.setEntries(records);
        response.setTimestamp(Time.now());
        return response;
    }
}

