/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LogVerificationAppender;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.inotify.Event;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.IllegalReservedPathException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSUpgradeFromImage {
    private static final Log LOG = LogFactory.getLog(TestDFSUpgradeFromImage.class);
    private static final File TEST_ROOT_DIR = new File(MiniDFSCluster.getBaseDirectory());
    private static final String HADOOP_DFS_DIR_TXT = "hadoop-dfs-dir.txt";
    private static final String HADOOP22_IMAGE = "hadoop-22-dfs-dir.tgz";
    private static final String HADOOP1_BBW_IMAGE = "hadoop1-bbw.tgz";
    private static final String HADOOP1_RESERVED_IMAGE = "hadoop-1-reserved.tgz";
    private static final String HADOOP023_RESERVED_IMAGE = "hadoop-0.23-reserved.tgz";
    private static final String HADOOP2_RESERVED_IMAGE = "hadoop-2-reserved.tgz";
    private static final String HADOOP252_IMAGE = "hadoop-252-dfs-dir.tgz";
    static final Configuration upgradeConf = new HdfsConfiguration();
    final LinkedList<ReferenceFileInfo> refList = new LinkedList();
    Iterator<ReferenceFileInfo> refIter;
    boolean printChecksum = false;

    void unpackStorage(String tarFileName, String referenceName) throws IOException {
        String line;
        String tarFile = System.getProperty("test.cache.data", "target/test/cache") + "/" + tarFileName;
        File dataDir = GenericTestUtils.getTestDir();
        File dfsDir = new File(dataDir, "dfs");
        if (dfsDir.exists() && !FileUtil.fullyDelete((File)dfsDir)) {
            throw new IOException("Could not delete dfs directory '" + dfsDir + "'");
        }
        LOG.info((Object)("Unpacking " + tarFile));
        FileUtil.unTar((File)new File(tarFile), (File)dataDir);
        BufferedReader reader = new BufferedReader(new FileReader(System.getProperty("test.cache.data", "target/test/cache") + "/" + referenceName));
        while ((line = reader.readLine()) != null) {
            String[] arr;
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || (arr = line.split("\\s+")).length < 1) continue;
            if (arr[0].equals("printChecksums")) {
                this.printChecksum = true;
                break;
            }
            if (arr.length < 2) continue;
            ReferenceFileInfo info = new ReferenceFileInfo();
            info.path = arr[0];
            info.checksum = Long.parseLong(arr[1]);
            this.refList.add(info);
        }
        reader.close();
    }

    private void verifyChecksum(String path, long checksum) throws IOException {
        if (this.refIter == null) {
            this.refIter = this.refList.iterator();
        }
        if (this.printChecksum) {
            LOG.info((Object)("CRC info for reference file : " + path + " \t " + checksum));
        } else {
            if (!this.refIter.hasNext()) {
                throw new IOException("Checking checksum for " + path + "Not enough elements in the refList");
            }
            ReferenceFileInfo info = this.refIter.next();
            Assert.assertEquals((Object)info.path, (Object)path);
            Assert.assertEquals((String)("Checking checksum for " + path), (long)info.checksum, (long)checksum);
        }
    }

    private static FSInputStream dfsOpenFileWithRetries(DistributedFileSystem dfs, String pathName) throws IOException {
        IOException exc = null;
        for (int tries = 0; tries < 30; ++tries) {
            try {
                return dfs.dfs.open(pathName);
            }
            catch (IOException e) {
                exc = e;
                if (!exc.getMessage().contains("Cannot obtain block length for LocatedBlock")) {
                    throw exc;
                }
                try {
                    LOG.info((Object)("Open failed. " + tries + " times. Retrying."));
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw exc;
    }

    private void verifyDir(DistributedFileSystem dfs, Path dir, CRC32 overallChecksum) throws IOException {
        FileStatus[] fileArr = dfs.listStatus(dir);
        TreeMap<Path, Boolean> fileMap = new TreeMap<Path, Boolean>();
        for (FileStatus file : fileArr) {
            fileMap.put(file.getPath(), file.isDirectory());
        }
        for (Path path : fileMap.keySet()) {
            boolean isDir = (Boolean)fileMap.get(path);
            String pathName = path.toUri().getPath();
            overallChecksum.update(pathName.getBytes());
            if (isDir) {
                this.verifyDir(dfs, path, overallChecksum);
                continue;
            }
            CRC32 fileCRC = new CRC32();
            FSInputStream in = TestDFSUpgradeFromImage.dfsOpenFileWithRetries(dfs, pathName);
            byte[] buf = new byte[4096];
            int nRead = 0;
            while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                fileCRC.update(buf, 0, nRead);
            }
            this.verifyChecksum(pathName, fileCRC.getValue());
        }
    }

    private void verifyFileSystem(DistributedFileSystem dfs) throws IOException {
        CRC32 overallChecksum = new CRC32();
        this.verifyDir(dfs, new Path("/"), overallChecksum);
        this.verifyChecksum("overallCRC", overallChecksum.getValue());
        if (this.printChecksum) {
            throw new IOException("Checksums are written to log as requested. Throwing this exception to force an error for this test.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailOnPreUpgradeImage() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        File namenodeStorage = new File(TEST_ROOT_DIR, "nnimage-0.3.0");
        conf.set("dfs.namenode.name.dir", namenodeStorage.toString());
        FileUtil.fullyDelete((File)namenodeStorage);
        Assert.assertTrue((String)("Make " + namenodeStorage), (boolean)namenodeStorage.mkdirs());
        File imageDir = new File(namenodeStorage, "image");
        Assert.assertTrue((String)("Make " + imageDir), (boolean)imageDir.mkdirs());
        File imageFile = new File(imageDir, "fsimage");
        byte[] imageBytes = StringUtils.hexStringToByte((String)"fffffffee17c0d2700000000");
        try (FileOutputStream fos = new FileOutputStream(imageFile);){
            fos.write(imageBytes);
        }
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            Assert.fail((String)"Was able to start NN from 0.3.0 image");
        }
        catch (IOException ioe) {
            if (!ioe.toString().contains("Old layout version is 'too old'")) {
                throw ioe;
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testUpgradeFromRel22Image() throws IOException {
        this.unpackStorage(HADOOP22_IMAGE, HADOOP_DFS_DIR_TXT);
        this.upgradeAndVerify(new MiniDFSCluster.Builder(upgradeConf).numDataNodes(4), null);
    }

    @Test
    public void testUpgradeFromCorruptRel22Image() throws IOException {
        this.unpackStorage(HADOOP22_IMAGE, HADOOP_DFS_DIR_TXT);
        File baseDir = new File(MiniDFSCluster.getBaseDirectory());
        FSImageTestUtil.corruptVersionFile(new File(baseDir, "name1/current/VERSION"), "imageMD5Digest", "22222222222222222222222222222222");
        FSImageTestUtil.corruptVersionFile(new File(baseDir, "name2/current/VERSION"), "imageMD5Digest", "22222222222222222222222222222222");
        LogVerificationAppender appender = new LogVerificationAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        try {
            this.upgradeAndVerify(new MiniDFSCluster.Builder(upgradeConf).numDataNodes(4), null);
            Assert.fail((String)"Upgrade did not fail with bad MD5");
        }
        catch (IOException ioe) {
            String msg = StringUtils.stringifyException((Throwable)ioe);
            if (!msg.contains("Failed to load FSImage file")) {
                throw ioe;
            }
            int md5failures = appender.countExceptionsWithMessage(" is corrupt with MD5 checksum of ");
            Assert.assertEquals((String)"Upgrade did not fail with bad MD5", (long)1L, (long)md5failures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeFromRel1ReservedImage() throws Exception {
        this.unpackStorage(HADOOP1_RESERVED_IMAGE, HADOOP_DFS_DIR_TXT);
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        try {
            FSImageFormat.setRenameReservedPairs((String)".snapshot=.user-snapshot,.reserved=.my-reserved");
            cluster = new MiniDFSCluster.Builder(conf).format(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).numDataNodes(0).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String[] expected = new String[]{"/.my-reserved", "/.user-snapshot", "/.user-snapshot/.user-snapshot", "/.user-snapshot/open", "/dir1", "/dir1/.user-snapshot", "/dir2", "/dir2/.user-snapshot", "/user", "/user/andrew", "/user/andrew/.user-snapshot"};
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    cluster.finalizeCluster(conf);
                    cluster.restartNameNode(true);
                }
                ArrayList<Path> toList = new ArrayList<Path>();
                toList.add(new Path("/"));
                ArrayList<String> found = new ArrayList<String>();
                while (!toList.isEmpty()) {
                    FileStatus[] statuses;
                    Path p = (Path)toList.remove(0);
                    for (FileStatus status : statuses = dfs.listStatus(p)) {
                        String path = status.getPath().toUri().getPath();
                        System.out.println("Found path " + path);
                        found.add(path);
                        if (!status.isDirectory()) continue;
                        toList.add(status.getPath());
                    }
                }
                for (String s : expected) {
                    Assert.assertTrue((String)("Did not find expected path " + s), (boolean)found.contains(s));
                }
                Assert.assertEquals((String)"Found an unexpected path while listing filesystem", (long)found.size(), (long)expected.length);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeFromRel023ReservedImage() throws Exception {
        this.unpackStorage(HADOOP023_RESERVED_IMAGE, HADOOP_DFS_DIR_TXT);
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        try {
            FSImageFormat.setRenameReservedPairs((String)".snapshot=.user-snapshot,.reserved=.my-reserved");
            cluster = new MiniDFSCluster.Builder(conf).format(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).numDataNodes(0).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String[] expected = new String[]{"/.user-snapshot", "/dir1", "/dir1/.user-snapshot", "/dir2", "/dir2/.user-snapshot"};
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    cluster.finalizeCluster(conf);
                    cluster.restartNameNode(true);
                }
                ArrayList<Path> toList = new ArrayList<Path>();
                toList.add(new Path("/"));
                ArrayList<String> found = new ArrayList<String>();
                while (!toList.isEmpty()) {
                    FileStatus[] statuses;
                    Path p = (Path)toList.remove(0);
                    for (FileStatus status : statuses = dfs.listStatus(p)) {
                        String path = status.getPath().toUri().getPath();
                        System.out.println("Found path " + path);
                        found.add(path);
                        if (!status.isDirectory()) continue;
                        toList.add(status.getPath());
                    }
                }
                for (String s : expected) {
                    Assert.assertTrue((String)("Did not find expected path " + s), (boolean)found.contains(s));
                }
                Assert.assertEquals((String)"Found an unexpected path while listing filesystem", (long)found.size(), (long)expected.length);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeFromRel2ReservedImage() throws Exception {
        Configuration conf;
        MiniDFSCluster cluster;
        block16: {
            this.unpackStorage(HADOOP2_RESERVED_IMAGE, HADOOP_DFS_DIR_TXT);
            cluster = null;
            conf = new Configuration();
            try {
                cluster = new MiniDFSCluster.Builder(conf).format(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).numDataNodes(0).build();
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (cause != null && cause instanceof IllegalReservedPathException) {
                    GenericTestUtils.assertExceptionContains((String)"reserved path component in this version", (Throwable)cause);
                    break block16;
                }
                throw ioe;
            }
            finally {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
        }
        try {
            FSImageFormat.setRenameReservedPairs((String)".snapshot=.user-snapshot,.reserved=.my-reserved");
            cluster = new MiniDFSCluster.Builder(conf).format(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).numDataNodes(0).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String[] expected = new String[]{"/edits", "/edits/.reserved", "/edits/.user-snapshot", "/edits/.user-snapshot/editsdir", "/edits/.user-snapshot/editsdir/editscontents", "/edits/.user-snapshot/editsdir/editsdir2", "/image", "/image/.reserved", "/image/.user-snapshot", "/image/.user-snapshot/imagedir", "/image/.user-snapshot/imagedir/imagecontents", "/image/.user-snapshot/imagedir/imagedir2", "/.my-reserved", "/.my-reserved/edits-touch", "/.my-reserved/image-touch"};
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    cluster.finalizeCluster(conf);
                    cluster.restartNameNode(true);
                }
                ArrayList<Path> toList = new ArrayList<Path>();
                toList.add(new Path("/"));
                ArrayList<String> found = new ArrayList<String>();
                while (!toList.isEmpty()) {
                    FileStatus[] statuses;
                    Path p = (Path)toList.remove(0);
                    for (FileStatus status : statuses = dfs.listStatus(p)) {
                        String path = status.getPath().toUri().getPath();
                        System.out.println("Found path " + path);
                        found.add(path);
                        if (!status.isDirectory()) continue;
                        toList.add(status.getPath());
                    }
                }
                for (String s : expected) {
                    Assert.assertTrue((String)("Did not find expected path " + s), (boolean)found.contains(s));
                }
                Assert.assertEquals((String)"Found an unexpected path while listing filesystem", (long)found.size(), (long)expected.length);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void recoverAllLeases(DFSClient dfs, Path path) throws IOException {
        DirectoryListing dirList;
        String pathStr = path.toString();
        HdfsFileStatus status = dfs.getFileInfo(pathStr);
        if (!status.isDir()) {
            for (int retries = 10; retries > 0; --retries) {
                if (dfs.recoverLease(pathStr)) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            throw new IOException("Failed to recover lease of " + path);
        }
        byte[] prev = HdfsFileStatus.EMPTY_NAME;
        do {
            HdfsFileStatus[] files;
            dirList = dfs.listPaths(pathStr, prev);
            for (HdfsFileStatus f : files = dirList.getPartialListing()) {
                TestDFSUpgradeFromImage.recoverAllLeases(dfs, f.getFullPath(path));
            }
            prev = dirList.getLastName();
        } while (dirList.hasMore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeAndVerify(MiniDFSCluster.Builder bld, ClusterVerifier verifier) throws IOException {
        MiniDFSCluster cluster = null;
        try {
            bld.format(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).clusterId("testClusterId");
            cluster = bld.build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSClient dfsClient = dfs.dfs;
            while (dfsClient.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET)) {
                LOG.info((Object)"Waiting for SafeMode to be OFF.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TestDFSUpgradeFromImage.recoverAllLeases(dfsClient, new Path("/"));
            this.verifyFileSystem(dfs);
            if (verifier != null) {
                verifier.verifyClusterPostUpgrade(cluster);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testUpgradeFromRel1BBWImage() throws IOException {
        this.unpackStorage(HADOOP1_BBW_IMAGE, HADOOP_DFS_DIR_TXT);
        Configuration conf = new Configuration(upgradeConf);
        conf.set("dfs.datanode.data.dir", GenericTestUtils.getTempPath((String)("dfs" + File.separator + "data" + File.separator + "data1")));
        this.upgradeAndVerify(new MiniDFSCluster.Builder(conf).numDataNodes(1).enableManagedDfsDirsRedundancy(false).manageDataDfsDirs(false), null);
    }

    @Test
    public void testPreserveEditLogs() throws Exception {
        Event.RenameEvent re;
        int i;
        this.unpackStorage(HADOOP252_IMAGE, HADOOP_DFS_DIR_TXT);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf = UpgradeUtilities.initializeStorageStateConf(1, (Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).build();
        DFSInotifyEventInputStream ieis = cluster.getFileSystem().getInotifyEventStream(0L);
        EventBatch batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
        Assert.assertEquals((long)1L, (long)batch.getEvents().length);
        Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
        Event.CreateEvent ce = (Event.CreateEvent)batch.getEvents()[0];
        Assert.assertEquals((Object)ce.getPath(), (Object)"/input");
        for (i = 1; i <= 5; ++i) {
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            ce = (Event.CreateEvent)batch.getEvents()[0];
            Assert.assertEquals((Object)ce.getPath(), (Object)("/input/dir" + i));
        }
        for (i = 1; i <= 2; ++i) {
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            if (batch.getEvents()[0].getEventType() != Event.EventType.CREATE) {
                FSImage.LOG.debug((Object)"");
            }
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
            re = (Event.RenameEvent)batch.getEvents()[0];
            Assert.assertEquals((Object)re.getDstPath(), (Object)("/input/dir" + i + "/randome_file_" + i));
        }
        long txIDBeforeRename = batch.getTxid();
        batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
        Assert.assertEquals((long)1L, (long)batch.getEvents().length);
        Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
        re = (Event.RenameEvent)batch.getEvents()[0];
        Assert.assertEquals((Object)re.getDstPath(), (Object)"/input/dir3/randome_file_3");
        batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
        Assert.assertEquals((long)1L, (long)batch.getEvents().length);
        Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.UNLINK ? 1 : 0) != 0);
        Assert.assertEquals((Object)((Event.UnlinkEvent)batch.getEvents()[0]).getPath(), (Object)"/input/dir1");
        long lastTxID = batch.getTxid();
        ieis = cluster.getFileSystem().getInotifyEventStream(txIDBeforeRename);
        batch = TestDFSInotifyEventInputStream.waitForNextEvents(ieis);
        Assert.assertEquals((long)1L, (long)batch.getEvents().length);
        Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
        re = (Event.RenameEvent)batch.getEvents()[0];
        Assert.assertEquals((Object)re.getDstPath(), (Object)"/input/dir3/randome_file_3");
        ieis = cluster.getFileSystem().getInotifyEventStream(lastTxID + 1L);
        Assert.assertNull((Object)ieis.poll());
        cluster.shutdown();
    }

    static {
        upgradeConf.setInt("dfs.datanode.scan.period.hours", -1);
        if (System.getProperty("test.build.data") == null) {
            System.setProperty("test.build.data", GenericTestUtils.DEFAULT_TEST_DATA_DIR);
        }
    }

    public static interface ClusterVerifier {
        public void verifyClusterPostUpgrade(MiniDFSCluster var1) throws IOException;
    }

    private static class ReferenceFileInfo {
        String path;
        long checksum;

        private ReferenceFileInfo() {
        }
    }
}

