/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.impl.LeaseRenewer;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestQuota {
    private static final Logger LOG = LoggerFactory.getLogger(TestQuota.class);
    private static Configuration conf = null;
    private static final ByteArrayOutputStream OUT_STREAM = new ByteArrayOutputStream();
    private static final ByteArrayOutputStream ERR_STREAM = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT = System.out;
    private static final PrintStream OLD_ERR = System.err;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private static FileSystem webhdfs;
    private static final int DEFAULT_BLOCK_SIZE = 512;
    @Rule
    public final Timeout testTestout = new Timeout(120000);

    @BeforeClass
    public static void setUpClass() throws Exception {
        conf = new HdfsConfiguration();
        conf.set("hdfs.minidfs.basedir", GenericTestUtils.getTestDir((String)"my-test-quota").getAbsolutePath());
        conf.setInt("dfs.content-summary.limit", 4);
        conf.setLong("dfs.blocksize", 512L);
        conf.setInt("dfs.content-summary.limit", 2);
        TestQuota.restartCluster();
        dfs = cluster.getFileSystem();
        TestQuota.redirectStream();
        String nnAddr = conf.get("dfs.namenode.http-address");
        String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        webhdfs = new Path(webhdfsuri).getFileSystem(conf);
    }

    private static void restartCluster() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
    }

    private static void redirectStream() {
        System.setOut(new PrintStream(OUT_STREAM));
        System.setErr(new PrintStream(ERR_STREAM));
    }

    private static void resetStream() {
        OUT_STREAM.reset();
        ERR_STREAM.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownClass() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(OLD_OUT);
            System.setErr(OLD_ERR);
        }
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
        TestQuota.resetStream();
    }

    private void runCommand(DFSAdmin admin, boolean expectError, String ... args) throws Exception {
        this.runCommand(admin, args, expectError);
    }

    private void runCommand(DFSAdmin admin, String[] args, boolean expectEror) throws Exception {
        int val = admin.run(args);
        if (expectEror) {
            Assert.assertEquals((long)-1L, (long)val);
        } else {
            Assert.assertTrue((val >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDSQuotaExceededExceptionIsHumanReadable() throws Exception {
        Integer bytes = 1024;
        try {
            throw new DSQuotaExceededException((long)bytes.intValue(), (long)bytes.intValue());
        }
        catch (DSQuotaExceededException e) {
            Assert.assertEquals((Object)"The DiskSpace quota is exceeded: quota = 1024 B = 1 KB but diskspace consumed = 1024 B = 1 KB", (Object)e.getMessage());
            return;
        }
    }

    @Test
    public void testQuotaCommands() throws Exception {
        FSDataOutputStream fout;
        DFSAdmin admin = new DFSAdmin(conf);
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        int fileLen = 1024;
        int replication = 5;
        long spaceQuota = 9600L;
        final Path parent = new Path(dir, "test");
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        String[] args = new String[]{"-setQuota", "3", parent.toString()};
        this.runCommand(admin, args, false);
        this.runCommand(admin, false, "-setSpaceQuota", "2t", parent.toString());
        Assert.assertEquals((long)0x20000000000L, (long)dfs.getContentSummary(parent).getSpaceQuota());
        this.runCommand(admin, false, "-setSpaceQuota", Long.toString(9600L), parent.toString());
        Path childDir0 = new Path(parent, "data0");
        Assert.assertTrue((boolean)dfs.mkdirs(childDir0));
        Path childFile0 = new Path(parent, "datafile0");
        DFSTestUtil.createFile((FileSystem)dfs, childFile0, 1024L, (short)5, 0L);
        ContentSummary c = dfs.getContentSummary(parent);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, parent);
        Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
        Assert.assertEquals((long)c.getQuota(), (long)3L);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)5120L);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)9600L);
        c = dfs.getContentSummary(childDir0);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, childDir0);
        Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)1L);
        Assert.assertEquals((long)c.getQuota(), (long)-1L);
        c = dfs.getContentSummary(parent);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, parent);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)5120L);
        Path childDir1 = new Path(parent, "data1");
        boolean hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.mkdirs(childDir1));
        }
        catch (QuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Path childFile1 = new Path(parent, "datafile1");
        hasException = false;
        try {
            fout = dfs.create(childFile1);
        }
        catch (QuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        this.runCommand(admin, new String[]{"-clrQuota", parent.toString()}, false);
        c = dfs.getContentSummary(parent);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, parent);
        Assert.assertEquals((long)c.getQuota(), (long)-1L);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)9600L);
        this.runCommand(admin, new String[]{"-clrQuota", childDir0.toString()}, false);
        c = dfs.getContentSummary(childDir0);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, childDir0);
        Assert.assertEquals((long)c.getQuota(), (long)-1L);
        fout = dfs.create(childFile1, (short)5);
        try {
            fout.write(new byte[1024]);
            fout.close();
            Assert.fail();
        }
        catch (QuotaExceededException e) {
            IOUtils.closeStream((Closeable)fout);
        }
        dfs.delete(childFile1, false);
        this.runCommand(admin, false, "-clrSpaceQuota", parent.toString());
        c = dfs.getContentSummary(parent);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, parent);
        Assert.assertEquals((long)c.getQuota(), (long)-1L);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)-1L);
        DFSTestUtil.createFile((FileSystem)dfs, childFile1, 1024L, (short)5, 0L);
        args = new String[]{"-setQuota", "1", parent.toString()};
        this.runCommand(admin, args, false);
        this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(1024), args[2]);
        args = new String[]{"-setQuota", "1", childDir0.toString()};
        this.runCommand(admin, args, false);
        hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.mkdirs(new Path(childDir0, "in")));
        }
        catch (QuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        c = dfs.getContentSummary(childDir0);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, childDir0);
        Assert.assertEquals((long)(c.getDirectoryCount() + c.getFileCount()), (long)1L);
        Assert.assertEquals((long)c.getQuota(), (long)1L);
        Path nonExistentPath = new Path(dir, "test1");
        Assert.assertFalse((boolean)dfs.exists(nonExistentPath));
        args = new String[]{"-setQuota", "1", nonExistentPath.toString()};
        this.runCommand(admin, args, true);
        this.runCommand(admin, true, "-setSpaceQuota", "1g", nonExistentPath.toString());
        Assert.assertTrue((boolean)dfs.isFile(childFile0));
        args[1] = childFile0.toString();
        this.runCommand(admin, args, true);
        this.runCommand(admin, true, "-setSpaceQuota", "1t", args[1]);
        args[0] = "-clrQuota";
        this.runCommand(admin, args, true);
        this.runCommand(admin, true, "-clrSpaceQuota", args[1]);
        args[1] = nonExistentPath.toString();
        this.runCommand(admin, args, true);
        this.runCommand(admin, true, "-clrSpaceQuota", args[1]);
        args = new String[]{"-setQuota", "0", parent.toString()};
        this.runCommand(admin, args, true);
        this.runCommand(admin, false, "-setSpaceQuota", "0", args[2]);
        args[1] = "-1";
        this.runCommand(admin, args, true);
        this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
        args[1] = String.valueOf(Long.MIN_VALUE);
        this.runCommand(admin, args, true);
        this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
        args[1] = "33aa1.5";
        this.runCommand(admin, args, true);
        this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
        this.runCommand(admin, true, "-setSpaceQuota", "8796093023231m", args[2]);
        String username = "userxx";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"userxx", (String[])new String[]{"groupyy"});
        final String[] args2 = (String[])args.clone();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Assert.assertEquals((String)"Not running as new user", (Object)"userxx", (Object)UserGroupInformation.getCurrentUser().getShortUserName());
                DFSAdmin userAdmin = new DFSAdmin(conf);
                args2[1] = "100";
                TestQuota.this.runCommand(userAdmin, args2, true);
                TestQuota.this.runCommand(userAdmin, true, new String[]{"-setSpaceQuota", "1g", args2[2]});
                String[] args3 = new String[]{"-clrQuota", parent.toString()};
                TestQuota.this.runCommand(userAdmin, args3, true);
                TestQuota.this.runCommand(userAdmin, true, new String[]{"-clrSpaceQuota", args3[1]});
                return null;
            }
        });
        this.runCommand(admin, true, "-clrQuota", "/");
        this.runCommand(admin, false, "-setQuota", "1000000", "/");
        this.runCommand(admin, true, "-clrQuota", "/");
        this.runCommand(admin, false, "-clrSpaceQuota", "/");
        this.runCommand(admin, new String[]{"-clrQuota", parent.toString()}, false);
        this.runCommand(admin, false, "-clrSpaceQuota", parent.toString());
        Path childDir2 = new Path(parent, "data2");
        Assert.assertTrue((boolean)dfs.mkdirs(childDir2));
        Path childFile2 = new Path(childDir2, "datafile2");
        Path childFile3 = new Path(childDir2, "datafile3");
        long spaceQuota2 = 2560L;
        long fileLen2 = 512L;
        this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), childDir2.toString());
        this.runCommand(admin, false, "-clrSpaceQuota", childDir2.toString());
        DFSTestUtil.createFile((FileSystem)dfs, childFile2, 512L, (short)5, 0L);
        this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), childDir2.toString());
        hasException = false;
        try {
            DFSTestUtil.createFile((FileSystem)dfs, childFile3, 512L, (short)5, 0L);
        }
        catch (DSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Path childFile4 = new Path(dir, "datafile2");
        Path childFile5 = new Path(dir, "datafile3");
        this.runCommand(admin, true, "-clrQuota", "/");
        this.runCommand(admin, false, "-clrSpaceQuota", "/");
        this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), "/");
        this.runCommand(admin, false, "-clrSpaceQuota", "/");
        DFSTestUtil.createFile((FileSystem)dfs, childFile4, 512L, (short)5, 0L);
        this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), "/");
        hasException = false;
        try {
            DFSTestUtil.createFile((FileSystem)dfs, childFile5, 512L, (short)5, 0L);
        }
        catch (DSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Assert.assertEquals((long)5L, (long)cluster.getNamesystem().getFSDirectory().getYieldCount());
        this.runCommand(admin, false, "-clrSpaceQuota", "/");
    }

    @Test
    public void testNamespaceCommands() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        Assert.assertTrue((boolean)dfs.mkdirs(new Path(parent, "nqdir0/qdir1/qdir20/nqdir30")));
        Path quotaDir1 = new Path(parent, "nqdir0/qdir1");
        dfs.setQuota(quotaDir1, 6L, Long.MAX_VALUE);
        ContentSummary c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
        Assert.assertEquals((long)c.getQuota(), (long)6L);
        Path quotaDir2 = new Path(parent, "nqdir0/qdir1/qdir20");
        dfs.setQuota(quotaDir2, 7L, Long.MAX_VALUE);
        c = dfs.getContentSummary(quotaDir2);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
        Assert.assertEquals((long)c.getQuota(), (long)7L);
        Path quotaDir3 = new Path(parent, "nqdir0/qdir1/qdir21");
        Assert.assertTrue((boolean)dfs.mkdirs(quotaDir3));
        dfs.setQuota(quotaDir3, 2L, Long.MAX_VALUE);
        c = dfs.getContentSummary(quotaDir3);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir3);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)1L);
        Assert.assertEquals((long)c.getQuota(), (long)2L);
        Path tempPath = new Path(quotaDir3, "nqdir32");
        Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
        c = dfs.getContentSummary(quotaDir3);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir3);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
        Assert.assertEquals((long)c.getQuota(), (long)2L);
        tempPath = new Path(quotaDir3, "nqdir33");
        boolean hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.mkdirs(tempPath));
        }
        catch (NSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        c = dfs.getContentSummary(quotaDir3);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir3);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
        Assert.assertEquals((long)c.getQuota(), (long)2L);
        tempPath = new Path(quotaDir2, "nqdir31");
        Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
        c = dfs.getContentSummary(quotaDir2);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
        Assert.assertEquals((long)c.getQuota(), (long)7L);
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
        Assert.assertEquals((long)c.getQuota(), (long)6L);
        tempPath = new Path(quotaDir2, "nqdir33");
        hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.mkdirs(tempPath));
        }
        catch (NSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        tempPath = new Path(quotaDir2, "nqdir30");
        dfs.rename(new Path(quotaDir3, "nqdir32"), tempPath);
        c = dfs.getContentSummary(quotaDir2);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
        Assert.assertEquals((long)c.getQuota(), (long)7L);
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
        Assert.assertEquals((long)c.getQuota(), (long)6L);
        hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.rename(tempPath, quotaDir3));
        }
        catch (NSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Assert.assertTrue((boolean)dfs.exists(tempPath));
        Assert.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir30")));
        hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.rename(tempPath, new Path(quotaDir3, "nqdir32")));
        }
        catch (QuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Assert.assertTrue((boolean)dfs.exists(tempPath));
        Assert.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir32")));
        Assert.assertTrue((boolean)dfs.rename(tempPath, new Path(parent, "nqdir0")));
        c = dfs.getContentSummary(quotaDir2);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
        Assert.assertEquals((long)c.getQuota(), (long)7L);
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
        Assert.assertEquals((long)c.getQuota(), (long)6L);
        Assert.assertTrue((boolean)dfs.mkdirs(new Path(parent, "nqdir0/nqdir30/nqdir33")));
        hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.rename(new Path(parent, "nqdir0/nqdir30"), tempPath));
        }
        catch (NSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Assert.assertTrue((boolean)dfs.rename(quotaDir3, quotaDir2));
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
        Assert.assertEquals((long)c.getQuota(), (long)6L);
        c = dfs.getContentSummary(quotaDir2);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
        Assert.assertEquals((long)c.getQuota(), (long)7L);
        tempPath = new Path(quotaDir2, "qdir21");
        c = dfs.getContentSummary(tempPath);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, tempPath);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)1L);
        Assert.assertEquals((long)c.getQuota(), (long)2L);
        dfs.delete(tempPath, true);
        c = dfs.getContentSummary(quotaDir2);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
        Assert.assertEquals((long)c.getQuota(), (long)7L);
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
        Assert.assertEquals((long)c.getQuota(), (long)6L);
        Assert.assertTrue((boolean)dfs.rename(new Path(parent, "nqdir0/nqdir30"), quotaDir2));
        c = dfs.getContentSummary(quotaDir2);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)5L);
        Assert.assertEquals((long)c.getQuota(), (long)7L);
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
        Assert.assertEquals((long)c.getQuota(), (long)6L);
    }

    @Test
    public void testSpaceCommands() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        int fileLen = 1024;
        short replication = 3;
        int fileSpace = fileLen * replication;
        Assert.assertTrue((boolean)dfs.mkdirs(new Path(parent, "nqdir0/qdir1/qdir20/nqdir30")));
        Path quotaDir1 = new Path(parent, "nqdir0/qdir1");
        dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(4 * fileSpace));
        ContentSummary c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
        Path quotaDir20 = new Path(parent, "nqdir0/qdir1/qdir20");
        dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(6 * fileSpace));
        c = dfs.getContentSummary(quotaDir20);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir20);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)(6 * fileSpace));
        Path quotaDir21 = new Path(parent, "nqdir0/qdir1/qdir21");
        Assert.assertTrue((boolean)dfs.mkdirs(quotaDir21));
        dfs.setQuota(quotaDir21, Long.MAX_VALUE, (long)(2 * fileSpace));
        c = dfs.getContentSummary(quotaDir21);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir21);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
        Path tempPath = new Path(quotaDir21, "nqdir32");
        Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
        DFSTestUtil.createFile((FileSystem)dfs, new Path(tempPath, "fileDir/file1"), fileLen, replication, 0L);
        c = dfs.getContentSummary(quotaDir21);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir21);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
        boolean hasException = false;
        try {
            DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir21, "nqdir33/file2"), 2 * fileLen, replication, 0L);
        }
        catch (DSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Assert.assertTrue((boolean)dfs.delete(new Path(quotaDir21, "nqdir33"), true));
        c = dfs.getContentSummary(quotaDir21);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir21);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
        c = dfs.getContentSummary(quotaDir20);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir20);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
        Path dstPath = new Path(quotaDir20, "nqdir30");
        Path srcPath = new Path(quotaDir21, "nqdir32");
        Assert.assertTrue((boolean)dfs.rename(srcPath, dstPath));
        c = dfs.getContentSummary(quotaDir20);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
        c = dfs.getContentSummary(quotaDir21);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir21);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
        Path file2 = new Path(dstPath, "fileDir/file2");
        int file2Len = 2 * fileLen;
        DFSTestUtil.createFile((FileSystem)dfs, file2, file2Len, replication, 0L);
        c = dfs.getContentSummary(quotaDir20);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
        c = dfs.getContentSummary(quotaDir21);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir21);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
        hasException = false;
        try {
            Assert.assertFalse((boolean)dfs.rename(dstPath, srcPath));
        }
        catch (DSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        Assert.assertFalse((boolean)dfs.exists(srcPath));
        Assert.assertTrue((boolean)dfs.exists(dstPath));
        c = dfs.getContentSummary(quotaDir20);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
        c = dfs.getContentSummary(quotaDir21);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir21);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
        c = dfs.getContentSummary(quotaDir1);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir1);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
        c = dfs.getContentSummary(dstPath);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, dstPath);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
        FSDataOutputStream out = dfs.append(file2);
        out.write(new byte[fileLen]);
        out.close();
        file2Len += fileLen;
        c = dfs.getContentSummary(dstPath);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, dstPath);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(4 * fileSpace));
        dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(5 * fileSpace));
        out = dfs.append(file2);
        hasException = false;
        try {
            out.write(new byte[fileLen + 1024]);
            out.flush();
            out.close();
        }
        catch (DSQuotaExceededException e) {
            hasException = true;
            IOUtils.closeStream((Closeable)out);
        }
        Assert.assertTrue((boolean)hasException);
        file2Len += fileLen;
        c = dfs.getContentSummary(dstPath);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, dstPath);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace));
        dfs.setReplication(file2, (short)(replication - 1));
        c = dfs.getContentSummary(dstPath);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, dstPath);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace - file2Len));
        hasException = false;
        try {
            dfs.setReplication(file2, (short)(replication + 1));
        }
        catch (DSQuotaExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        c = dfs.getContentSummary(dstPath);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, dstPath);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace - file2Len));
        dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(10 * fileSpace));
        dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(10 * fileSpace));
        dfs.setReplication(file2, (short)(replication + 1));
        c = dfs.getContentSummary(dstPath);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, dstPath);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace + file2Len));
        Path quotaDir2053 = new Path(parent, "hdfs-2053");
        Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053));
        Path quotaDir2053_A = new Path(quotaDir2053, "A");
        Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_A));
        Path quotaDir2053_B = new Path(quotaDir2053, "B");
        Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_B));
        Path quotaDir2053_C = new Path(quotaDir2053, "C");
        Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_C));
        int sizeFactorA = 1;
        int sizeFactorB = 2;
        int sizeFactorC = 4;
        dfs.setQuota(quotaDir2053_C, Long.MAX_VALUE, (long)((sizeFactorC + 1) * fileSpace));
        c = dfs.getContentSummary(quotaDir2053_C);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2053_C);
        Assert.assertEquals((long)c.getSpaceQuota(), (long)((sizeFactorC + 1) * fileSpace));
        DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_A, "fileA"), sizeFactorA * fileLen, replication, 0L);
        c = dfs.getContentSummary(quotaDir2053_A);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2053_A);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorA * fileSpace));
        DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_B, "fileB"), sizeFactorB * fileLen, replication, 0L);
        c = dfs.getContentSummary(quotaDir2053_B);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2053_B);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorB * fileSpace));
        DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_C, "fileC"), sizeFactorC * fileLen, replication, 0L);
        c = dfs.getContentSummary(quotaDir2053_C);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2053_C);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorC * fileSpace));
        c = dfs.getContentSummary(quotaDir2053);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, quotaDir2053);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)((sizeFactorA + sizeFactorB + sizeFactorC) * fileSpace));
    }

    @Test
    public void testQuotaByStorageType() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        int fileLen = 1024;
        short replication = 3;
        int fileSpace = fileLen * replication;
        Path quotaDir20 = new Path(parent, "nqdir0/qdir1/qdir20");
        Assert.assertTrue((boolean)dfs.mkdirs(quotaDir20));
        dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(6 * fileSpace));
        Path file = new Path(quotaDir20, "fileDir/file1");
        DFSTestUtil.createFile((FileSystem)dfs, file, fileLen * 3, replication, 0L);
        dfs.delete(file, false);
        dfs.setStoragePolicy(quotaDir20, "HOT");
        dfs.setQuotaByStorageType(quotaDir20, StorageType.DEFAULT, (long)(2 * fileSpace));
        boolean hasException = false;
        try {
            DFSTestUtil.createFile((FileSystem)dfs, file, fileLen * 3, replication, 0L);
        }
        catch (QuotaByStorageTypeExceededException e) {
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
        dfs.delete(file, false);
        dfs.setQuotaByStorageType(quotaDir20, StorageType.DEFAULT, (long)(6 * fileSpace));
    }

    private static void checkContentSummary(ContentSummary expected, ContentSummary computed) {
        Assert.assertEquals((Object)expected.toString(), (Object)computed.toString());
    }

    @Test
    public void testMaxSpaceQuotas() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        Path testFolder = new Path(parent, "testFolder");
        Assert.assertTrue((boolean)dfs.mkdirs(testFolder));
        dfs.setQuota(testFolder, 0x7FFFFFFFFFFFFFFEL, 10L);
        ContentSummary c = dfs.getContentSummary(testFolder);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, testFolder);
        Assert.assertTrue((String)"Quota not set properly", (c.getQuota() == 0x7FFFFFFFFFFFFFFEL ? 1 : 0) != 0);
        dfs.setQuota(testFolder, 10L, 0x7FFFFFFFFFFFFFFEL);
        c = dfs.getContentSummary(testFolder);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, testFolder);
        Assert.assertTrue((String)"Quota not set properly", (c.getSpaceQuota() == 0x7FFFFFFFFFFFFFFEL ? 1 : 0) != 0);
        dfs.setQuota(testFolder, Long.MAX_VALUE, 10L);
        c = dfs.getContentSummary(testFolder);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, testFolder);
        Assert.assertTrue((String)"Quota should not have changed", (c.getQuota() == 10L ? 1 : 0) != 0);
        dfs.setQuota(testFolder, 10L, Long.MAX_VALUE);
        c = dfs.getContentSummary(testFolder);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, testFolder);
        Assert.assertTrue((String)"Quota should not have changed", (c.getSpaceQuota() == 10L ? 1 : 0) != 0);
        try {
            dfs.setQuota(testFolder, Long.MIN_VALUE, 10L);
            Assert.fail((String)"Exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dfs.setQuota(testFolder, 10L, Long.MIN_VALUE);
            Assert.fail((String)"Exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBlockAllocationAdjustsUsageConservatively() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        DFSAdmin admin = new DFSAdmin(conf);
        Path dir = new Path(parent, "test");
        Path file1 = new Path(parent, "test/test1");
        Path file2 = new Path(parent, "test/test2");
        boolean exceededQuota = false;
        int QUOTA_SIZE = 1536;
        int FILE_SIZE = 256;
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(1536), dir.toString());
        DFSTestUtil.createFile((FileSystem)dfs, file1, 256L, (short)3, 1L);
        DFSTestUtil.waitReplication((FileSystem)dfs, file1, (short)3);
        ContentSummary c = dfs.getContentSummary(dir);
        this.compareQuotaUsage((QuotaUsage)c, (FileSystem)dfs, dir);
        TestQuota.checkContentSummary(c, webhdfs.getContentSummary(dir));
        Assert.assertEquals((String)"Quota is half consumed", (long)768L, (long)c.getSpaceConsumed());
        try {
            DFSTestUtil.createFile((FileSystem)dfs, file2, 256L, (short)3, 1L);
        }
        catch (QuotaExceededException e) {
            exceededQuota = true;
        }
        Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleFilesSmallerThanOneBlock() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        HdfsConfiguration dfsConf = new HdfsConfiguration();
        int BLOCK_SIZE = 6144;
        dfsConf.setInt("dfs.blocksize", 6144);
        dfsConf.setInt("dfs.content-summary.limit", 2);
        MiniDFSCluster dfsCluster = new MiniDFSCluster.Builder((Configuration)dfsConf).numDataNodes(3).build();
        dfsCluster.waitActive();
        DistributedFileSystem fs = dfsCluster.getFileSystem();
        DFSAdmin admin = new DFSAdmin((Configuration)dfsConf);
        String nnAddr = dfsConf.get("dfs.namenode.http-address");
        String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webHDFS = new Path(webhdfsuri).getFileSystem((Configuration)dfsConf);
        try {
            Path dir = new Path(parent, "test");
            boolean exceededQuota = false;
            int FILE_SIZE = 1024;
            int QUOTA_SIZE = 32 * (int)fs.getDefaultBlockSize(dir);
            Assert.assertEquals((long)6144L, (long)fs.getDefaultBlockSize(dir));
            Assert.assertEquals((long)196608L, (long)QUOTA_SIZE);
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), dir.toString());
            for (int i = 0; i < 59; ++i) {
                Path file = new Path(parent, "test/test" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 1024L, (short)3, 1L);
                DFSTestUtil.waitReplication((FileSystem)fs, file, (short)3);
            }
            ContentSummary c = fs.getContentSummary(dir);
            this.compareQuotaUsage((QuotaUsage)c, (FileSystem)fs, dir);
            TestQuota.checkContentSummary(c, webHDFS.getContentSummary(dir));
            Assert.assertEquals((String)"Invalid space consumed", (long)181248L, (long)c.getSpaceConsumed());
            Assert.assertEquals((String)"Invalid space consumed", (long)(QUOTA_SIZE - 181248), (long)(3L * (fs.getDefaultBlockSize(dir) - 1024L)));
            try {
                Path file = new Path(parent, "test/test59");
                DFSTestUtil.createFile((FileSystem)fs, file, 1024L, (short)3, 1L);
                DFSTestUtil.waitReplication((FileSystem)fs, file, (short)3);
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
            }
            Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
            Assert.assertEquals((long)2L, (long)dfsCluster.getNamesystem().getFSDirectory().getYieldCount());
        }
        finally {
            dfsCluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetSpaceQuotaWhenStorageTypeIsWrong() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://127.0.0.1:8020");
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream oldErr = System.err;
        try {
            System.setErr(new PrintStream(err));
            String[] args = new String[]{"-setSpaceQuota", "100", "-storageType", "COLD", "/testDir"};
            admin.run(args);
            String errOutput = new String(err.toByteArray(), Charsets.UTF_8);
            Assert.assertTrue((boolean)errOutput.contains(StorageType.getTypesSupportingQuota().toString()));
        }
        finally {
            System.setErr(oldErr);
        }
    }

    @Test
    public void testHugeFileCount() throws IOException {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(parent));
        for (int i = 1; i <= 5; ++i) {
            FSDataOutputStream out = dfs.create(new Path(parent, "Folder1/file" + i), (short)1);
            out.close();
        }
        FSDataOutputStream out = dfs.create(new Path(parent, "Folder2/file6"), (short)1);
        out.close();
        ContentSummary contentSummary = dfs.getContentSummary(parent);
        this.compareQuotaUsage((QuotaUsage)contentSummary, (FileSystem)dfs, parent);
        Assert.assertEquals((long)6L, (long)contentSummary.getFileCount());
    }

    private void compareQuotaUsage(QuotaUsage fromContentSummary, FileSystem fileSystem, Path filePath) throws IOException {
        QuotaUsage quotaUsage = fileSystem.getQuotaUsage(filePath);
        Assert.assertEquals((Object)fromContentSummary, (Object)quotaUsage);
    }

    @Test(timeout=30000L)
    public void testSetSpaceQuotaNegativeNumber() throws Exception {
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        ArrayList outs = Lists.newArrayList();
        TestQuota.resetStream();
        outs.clear();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-setSpaceQuota", "-10", dir.toString()});
        Assert.assertEquals((long)-1L, (long)ret);
        TestQuota.scanIntoList(ERR_STREAM, outs);
        Assert.assertEquals((String)"It should be two lines of error messages, the 1st one is about Illegal option, the 2nd one is about SetSpaceQuota usage.", (long)2L, (long)outs.size());
        Assert.assertThat(outs.get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"setSpaceQuota"), (Matcher)CoreMatchers.containsString((String)"Illegal option"))));
    }

    @Test(timeout=30000L)
    public void testSetAndClearSpaceQuotaRegular() throws Exception {
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        this.testSetAndClearSpaceQuotaRegularInternal(new String[]{"-setSpaceQuota", "1024", dir.toString()}, dir, 0, 1024);
        this.testSetAndClearSpaceQuotaRegularInternal(new String[]{"-clrSpaceQuota", dir.toString()}, dir, 0, -1);
    }

    @Test(timeout=30000L)
    public void testQuotaCommandsWithURI() throws Exception {
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        Path dir = new Path("/" + this.getClass().getSimpleName(), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        this.testSetAndClearSpaceQuotaRegularInternal(new String[]{"-setSpaceQuota", "1024", dfs.getUri() + "/" + dir.toString()}, dir, 0, 1024);
        this.testSetAndClearSpaceQuotaRegularInternal(new String[]{"-clrSpaceQuota", dfs.getUri() + "/" + dir.toString()}, dir, 0, -1);
        this.runCommand(dfsAdmin, false, "-setQuota", "1000", dfs.getUri() + "/" + dir.toString());
        this.runCommand(dfsAdmin, false, "-clrQuota", dfs.getUri() + "/" + dir.toString());
    }

    private void testSetAndClearSpaceQuotaRegularInternal(String[] args, Path dir, int cmdRet, int spaceQuota) throws Exception {
        TestQuota.resetStream();
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        ArrayList outs = Lists.newArrayList();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])args);
        Assert.assertEquals((long)cmdRet, (long)ret);
        QuotaUsage quotaUsage = dfs.getQuotaUsage(dir);
        Assert.assertEquals((long)spaceQuota, (long)quotaUsage.getSpaceQuota());
        TestQuota.scanIntoList(OUT_STREAM, outs);
        Assert.assertTrue((String)"There should be no output if it runs successfully.", (boolean)outs.isEmpty());
    }

    @Test(timeout=30000L)
    public void testSetAndClearSpaceQuotaByStorageType() throws Exception {
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        this.testSetAndClearSpaceQuotaByStorageTypeInternal(new String[]{"-setSpaceQuota", "2048", "-storageType", "DISK", dir.toString()}, dir, 0, -1, 2048);
        this.testSetAndClearSpaceQuotaByStorageTypeInternal(new String[]{"-clrSpaceQuota", "-storageType", "DISK", dir.toString()}, dir, 0, -1, -1);
    }

    private void testSetAndClearSpaceQuotaByStorageTypeInternal(String[] args, Path dir, int cmdRet, int spaceQuota, int spaceQuotaByStorageType) throws Exception {
        TestQuota.resetStream();
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        ArrayList outs = Lists.newArrayList();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])args);
        Assert.assertEquals((long)cmdRet, (long)ret);
        QuotaUsage quotaUsage = dfs.getQuotaUsage(dir);
        Assert.assertEquals((long)spaceQuota, (long)quotaUsage.getSpaceQuota());
        Assert.assertEquals((long)spaceQuotaByStorageType, (long)quotaUsage.getTypeQuota(StorageType.DISK));
        TestQuota.scanIntoList(OUT_STREAM, outs);
        Assert.assertTrue((String)"There should be no output if it runs successfully.", (boolean)outs.isEmpty());
    }

    @Test(timeout=30000L)
    public void testSetAndClearSpaceQuotaDirecotryNotExist() throws Exception {
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        this.testSetAndClearSpaceQuotaDirecotryNotExistInternal(new String[]{"-setSpaceQuota", "1024", dir.toString()}, dir, -1, "setSpaceQuota");
        this.testSetAndClearSpaceQuotaDirecotryNotExistInternal(new String[]{"-clrSpaceQuota", dir.toString()}, dir, -1, "clrSpaceQuota");
    }

    private void testSetAndClearSpaceQuotaDirecotryNotExistInternal(String[] args, Path dir, int cmdRet, String cmdName) throws Exception {
        TestQuota.resetStream();
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        ArrayList outs = Lists.newArrayList();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])args);
        Assert.assertEquals((long)cmdRet, (long)ret);
        TestQuota.scanIntoList(ERR_STREAM, outs);
        Assert.assertEquals((String)"It should be one line error message like: clrSpaceQuota: Directory does not exist: <full path of XXX directory>", (long)1L, (long)outs.size());
        Assert.assertThat(outs.get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)cmdName), (Matcher)CoreMatchers.containsString((String)"does not exist"), (Matcher)CoreMatchers.containsString((String)dir.toString()))));
    }

    @Test(timeout=30000L)
    public void testSetAndClearSpaceQuotaPathIsFile() throws Exception {
        Path parent = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Path file = new Path(parent, "path-is-file");
        DFSTestUtil.createFile((FileSystem)dfs, file, 1024L, (short)1, 0L);
        Assert.assertTrue((boolean)dfs.isFile(file));
        this.testSetAndClearSpaceQuotaPathIsFileInternal(new String[]{"-setSpaceQuota", "1024", file.toString()}, file, -1, "setSpaceQuota");
        this.testSetAndClearSpaceQuotaPathIsFileInternal(new String[]{"-clrSpaceQuota", file.toString()}, file, -1, "clrSpaceQuota");
    }

    private void testSetAndClearSpaceQuotaPathIsFileInternal(String[] args, Path file, int cmdRet, String cmdName) throws Exception {
        TestQuota.resetStream();
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        ArrayList outs = Lists.newArrayList();
        int ret = ToolRunner.run((Tool)dfsAdmin, (String[])args);
        Assert.assertEquals((long)cmdRet, (long)ret);
        TestQuota.scanIntoList(ERR_STREAM, outs);
        Assert.assertEquals((String)"It should be one line error message like: clrSpaceQuota: <full path of XXX file> is not a directory", (long)1L, (long)outs.size());
        Assert.assertThat(outs.get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)cmdName), (Matcher)CoreMatchers.containsString((String)file.toString()), (Matcher)CoreMatchers.containsString((String)"Is not a directory"))));
    }

    @Test(timeout=30000L)
    public void testSetAndClearSpaceQuotaNoAccess() throws Exception {
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        this.testSetAndClearSpaceQuotaNoAccessInternal(new String[]{"-setSpaceQuota", "2048", dir.toString()}, -1, "setSpaceQuota");
        this.testSetAndClearSpaceQuotaNoAccessInternal(new String[]{"-clrSpaceQuota", dir.toString()}, -1, "clrSpaceQuota");
    }

    @Test
    public void testSpaceQuotaExceptionOnClose() throws Exception {
        GenericTestUtils.setLogLevel((Logger)DFSOutputStream.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.TRACE);
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        String[] args = new String[]{"-setSpaceQuota", "1", dir.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])args));
        Path testFile = new Path(dir, "file");
        FSDataOutputStream stream = dfs.create(testFile);
        stream.write("whatever".getBytes());
        try {
            stream.close();
            Assert.fail((String)"close should fail");
        }
        catch (DSQuotaExceededException dSQuotaExceededException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getNumFilesUnderConstruction());
    }

    @Test
    public void testSpaceQuotaExceptionOnFlush() throws Exception {
        GenericTestUtils.setLogLevel((Logger)DFSOutputStream.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        String[] args = new String[]{"-setSpaceQuota", "1", dir.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])args));
        Path testFile = new Path(dir, "file");
        FSDataOutputStream stream = dfs.create(testFile);
        final LeaseRenewer leaseRenewer = dfs.getClient().getLeaseRenewer();
        stream.write("whatever".getBytes());
        try {
            stream.hflush();
            Assert.fail((String)"flush should fail");
        }
        catch (DSQuotaExceededException dSQuotaExceededException) {
            // empty catch block
        }
        try {
            stream.close();
            Assert.fail((String)"close should fail too");
        }
        catch (DSQuotaExceededException dSQuotaExceededException) {
            // empty catch block
        }
        GenericTestUtils.setLogLevel((Logger)LeaseRenewer.LOG, (Level)Level.TRACE);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                LOG.info("LeaseRenewer: {}", (Object)leaseRenewer);
                return leaseRenewer.isEmpty();
            }
        }, (int)100, (int)10000);
        Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getNumFilesUnderConstruction());
    }

    @Test
    public void testSpaceQuotaExceptionOnAppend() throws Exception {
        GenericTestUtils.setLogLevel((Logger)DFSOutputStream.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.TRACE);
        DFSAdmin dfsAdmin = new DFSAdmin(conf);
        Path dir = new Path(PathUtils.getTestPath(this.getClass()), GenericTestUtils.getMethodName());
        dfs.delete(dir, true);
        Assert.assertTrue((boolean)dfs.mkdirs(dir));
        String[] args = new String[]{"-setSpaceQuota", "4000", dir.toString()};
        ToolRunner.run((Tool)dfsAdmin, (String[])args);
        Path testFile = new Path(dir, "file");
        FSDataOutputStream stream = dfs.create(testFile);
        stream.write("whatever".getBytes());
        stream.close();
        Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getNumFilesUnderConstruction());
        stream = dfs.append(testFile);
        byte[] buf = AppendTestUtil.initBuffer(4096);
        stream.write(buf);
        try {
            stream.close();
            Assert.fail((String)"close after append should fail");
        }
        catch (DSQuotaExceededException dSQuotaExceededException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getNumFilesUnderConstruction());
    }

    private void testSetAndClearSpaceQuotaNoAccessInternal(final String[] args, int cmdRet, String cmdName) throws Exception {
        TestQuota.resetStream();
        final DFSAdmin dfsAdmin = new DFSAdmin(conf);
        ArrayList outs = Lists.newArrayList();
        UserGroupInformation whoever = UserGroupInformation.createUserForTesting((String)"whoever", (String[])new String[]{"whoever_group"});
        int ret = (Integer)whoever.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return ToolRunner.run((Tool)dfsAdmin, (String[])args);
            }
        });
        Assert.assertEquals((long)cmdRet, (long)ret);
        TestQuota.scanIntoList(ERR_STREAM, outs);
        Assert.assertThat(outs.get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)cmdName), (Matcher)CoreMatchers.containsString((String)"Access denied for user whoever"), (Matcher)CoreMatchers.containsString((String)"Superuser privilege is required"))));
    }

    private static void scanIntoList(ByteArrayOutputStream baos, List<String> list) {
        Scanner scanner = new Scanner(baos.toString());
        while (scanner.hasNextLine()) {
            list.add(scanner.nextLine());
        }
        scanner.close();
    }
}

