/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BlockRecoveryWorker;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestBlockRecovery {
    private static final Log LOG = LogFactory.getLog(TestBlockRecovery.class);
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private DataNode dn;
    private DataNode spyDN;
    private BlockRecoveryWorker recoveryWorker;
    private Configuration conf;
    private static final long RECOVERY_ID = 3000L;
    private static final String CLUSTER_ID = "testClusterID";
    private static final String POOL_ID = "BP-TEST";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    private static final long BLOCK_ID = 1000L;
    private static final long GEN_STAMP = 2000L;
    private static final long BLOCK_LEN = 3000L;
    private static final long REPLICA_LEN1 = 6000L;
    private static final long REPLICA_LEN2 = 5000L;
    private static final ExtendedBlock block = new ExtendedBlock("BP-TEST", 1000L, 3000L, 2000L);
    @Rule
    public TestName currentTestName = new TestName();
    private final long TEST_STOP_WORKER_XCEIVER_STOP_TIMEOUT_MILLIS = 1000000000L;
    private static final BlockRecoveryCommand.RecoveringBlock rBlock;

    @Before
    public void startUp() throws IOException, URISyntaxException {
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.datanode.data.dir", DATA_DIR);
        this.conf.set("dfs.datanode.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        if (this.currentTestName.getMethodName().contains("DoesNotHoldLock")) {
            this.conf.setLong("dfs.datanode.xceiver.stop.timeout.millis", 1000000000L);
        }
        this.conf.setInt("ipc.client.connect.max.retries", 0);
        FileSystem.setDefaultUri((Configuration)this.conf, (String)("hdfs://" + NN_ADDR.getHostName() + ":" + NN_ADDR.getPort()));
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        File dataDir = new File(DATA_DIR);
        FileUtil.fullyDelete((File)dataDir);
        dataDir.mkdirs();
        StorageLocation location = StorageLocation.parse((String)dataDir.getPath());
        locations.add(location);
        final DatanodeProtocolClientSideTranslatorPB namenode = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new Answer<DatanodeRegistration>(){

            public DatanodeRegistration answer(InvocationOnMock invocation) throws Throwable {
                return (DatanodeRegistration)invocation.getArguments()[0];
            }
        }).when((Object)namenode)).registerDatanode((DatanodeRegistration)Mockito.any(DatanodeRegistration.class));
        Mockito.when((Object)namenode.versionRequest()).thenReturn((Object)new NamespaceInfo(1, CLUSTER_ID, POOL_ID, 1L));
        Mockito.when((Object)namenode.sendHeartbeat((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(SlowPeerReports.class), (SlowDiskReports)Mockito.any(SlowDiskReports.class))).thenReturn((Object)new HeartbeatResponse(new DatanodeCommand[0], new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L), null, ThreadLocalRandom.current().nextLong() | 1L));
        this.dn = new DataNode(this.conf, locations, null, null){

            DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
                Assert.assertEquals((Object)NN_ADDR, (Object)nnAddr);
                return namenode;
            }
        };
        ((BPOfferService)this.dn.getAllBpOs().get(0)).triggerHeartbeatForTests();
        this.waitForActiveNN();
        this.spyDN = (DataNode)Mockito.spy((Object)this.dn);
        this.recoveryWorker = new BlockRecoveryWorker(this.spyDN);
    }

    private void waitForActiveNN() {
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return ((BPOfferService)TestBlockRecovery.this.dn.getAllBpOs().get(0)).getActiveNN() != null;
                }
            }, (int)1000, (int)15000);
        }
        catch (TimeoutException e) {
            LOG.warn((Object)"Failed to get active NN", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"InterruptedException while waiting to see active NN", (Throwable)e);
        }
        Assert.assertNotNull((String)"Failed to get ActiveNN", (Object)((BPOfferService)this.dn.getAllBpOs().get(0)).getActiveNN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws IOException {
        if (this.dn != null) {
            try {
                this.dn.shutdown();
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot close: ", (Throwable)e);
            }
            finally {
                File dir = new File(DATA_DIR);
                if (dir.exists()) {
                    Assert.assertTrue((String)"Cannot delete data-node dirs", (boolean)FileUtil.fullyDelete((File)dir));
                }
            }
        }
    }

    private void testSyncReplicas(ReplicaRecoveryInfo replica1, ReplicaRecoveryInfo replica2, InterDatanodeProtocol dn1, InterDatanodeProtocol dn2, long expectLen) throws IOException {
        DatanodeInfo[] locs = new DatanodeInfo[]{(DatanodeInfo)Mockito.mock(DatanodeInfo.class), (DatanodeInfo)Mockito.mock(DatanodeInfo.class)};
        BlockRecoveryCommand.RecoveringBlock rBlock = new BlockRecoveryCommand.RecoveringBlock(block, locs, 3000L);
        ArrayList<BlockRecoveryWorker.BlockRecord> syncList = new ArrayList<BlockRecoveryWorker.BlockRecord>(2);
        BlockRecoveryWorker.BlockRecord record1 = new BlockRecoveryWorker.BlockRecord((DatanodeID)DFSTestUtil.getDatanodeInfo("1.2.3.4", "bogus", 1234), dn1, replica1);
        BlockRecoveryWorker.BlockRecord record2 = new BlockRecoveryWorker.BlockRecord((DatanodeID)DFSTestUtil.getDatanodeInfo("1.2.3.4", "bogus", 1234), dn2, replica2);
        syncList.add(record1);
        syncList.add(record2);
        Mockito.when((Object)dn1.updateReplicaUnderRecovery((ExtendedBlock)Matchers.anyObject(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)"storage1");
        Mockito.when((Object)dn2.updateReplicaUnderRecovery((ExtendedBlock)Matchers.anyObject(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)"storage2");
        BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
        blockRecoveryWorker.getClass();
        BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
        RecoveryTaskContiguous2.syncBlock(syncList);
    }

    @Test(timeout=60000L)
    public void testFinalizedReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.FINALIZED);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.FINALIZED);
        try {
            this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
            Assert.fail((String)"Two finalized replicas should not have different lengthes!");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Inconsistent size of finalized replicas. "));
        }
    }

    @Test(timeout=60000L)
    public void testFinalizedRbwReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
    }

    @Test(timeout=60000L)
    public void testFinalizedRwrReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.RWR);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
    }

    @Test(timeout=60000L)
    public void testRBWReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.RBW);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        long minLen = Math.min(6000L, 5000L);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
    }

    @Test(timeout=60000L)
    public void testRBW_RWRReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.RBW);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.RWR);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
    }

    @Test(timeout=60000L)
    public void testRWRReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.RWR);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RWR);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        long minLen = Math.min(6000L, 5000L);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
    }

    private Collection<BlockRecoveryCommand.RecoveringBlock> initRecoveringBlocks() throws IOException {
        ArrayList<BlockRecoveryCommand.RecoveringBlock> blocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(1);
        DatanodeInfo mockOtherDN = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] locs = new DatanodeInfo[]{new DatanodeInfo.DatanodeInfoBuilder().setNodeID((DatanodeID)this.dn.getDNRegistrationForBP(block.getBlockPoolId())).build(), mockOtherDN};
        BlockRecoveryCommand.RecoveringBlock rBlock = new BlockRecoveryCommand.RecoveringBlock(block, locs, 3000L);
        blocks.add(rBlock);
        return blocks;
    }

    @Test(timeout=60000L)
    public void testRecoveryInProgressException() throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ((DataNode)Mockito.doThrow((Throwable)new RecoveryInProgressException("Replica recovery is in progress")).when((Object)this.spyDN)).initReplicaRecovery((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class));
        for (BlockRecoveryCommand.RecoveringBlock rBlock : this.initRecoveringBlocks()) {
            BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
            blockRecoveryWorker.getClass();
            BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
            BlockRecoveryWorker.RecoveryTaskContiguous spyTask = (BlockRecoveryWorker.RecoveryTaskContiguous)Mockito.spy((Object)RecoveryTaskContiguous2);
            spyTask.recover();
            ((BlockRecoveryWorker.RecoveryTaskContiguous)Mockito.verify((Object)spyTask, (VerificationMode)Mockito.never())).syncBlock(Matchers.anyListOf(BlockRecoveryWorker.BlockRecord.class));
        }
    }

    @Test(timeout=60000L)
    public void testErrorReplicas() throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ((DataNode)Mockito.doThrow((Throwable)new IOException()).when((Object)this.spyDN)).initReplicaRecovery((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class));
        for (BlockRecoveryCommand.RecoveringBlock rBlock : this.initRecoveringBlocks()) {
            BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
            blockRecoveryWorker.getClass();
            BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
            BlockRecoveryWorker.RecoveryTaskContiguous spyTask = (BlockRecoveryWorker.RecoveryTaskContiguous)Mockito.spy((Object)RecoveryTaskContiguous2);
            try {
                spyTask.recover();
                Assert.fail();
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains((String)"All datanodes failed", (Throwable)e);
            }
            ((BlockRecoveryWorker.RecoveryTaskContiguous)Mockito.verify((Object)spyTask, (VerificationMode)Mockito.never())).syncBlock(Matchers.anyListOf(BlockRecoveryWorker.BlockRecord.class));
        }
    }

    @Test(timeout=60000L)
    public void testZeroLenReplicas() throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ((DataNode)Mockito.doReturn((Object)new ReplicaRecoveryInfo(block.getBlockId(), 0L, block.getGenerationStamp(), HdfsServerConstants.ReplicaState.FINALIZED)).when((Object)this.spyDN)).initReplicaRecovery((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class));
        for (BlockRecoveryCommand.RecoveringBlock rBlock : this.initRecoveringBlocks()) {
            BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
            blockRecoveryWorker.getClass();
            BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
            BlockRecoveryWorker.RecoveryTaskContiguous spyTask = (BlockRecoveryWorker.RecoveryTaskContiguous)Mockito.spy((Object)RecoveryTaskContiguous2);
            spyTask.recover();
        }
        DatanodeProtocolClientSideTranslatorPB dnP = this.recoveryWorker.getActiveNamenodeForBP(POOL_ID);
        ((DatanodeProtocol)Mockito.verify((Object)dnP)).commitBlockSynchronization(block, 3000L, 0L, true, true, DatanodeID.EMPTY_ARRAY, null);
    }

    private List<BlockRecoveryWorker.BlockRecord> initBlockRecords(DataNode spyDN) throws IOException {
        ArrayList<BlockRecoveryWorker.BlockRecord> blocks = new ArrayList<BlockRecoveryWorker.BlockRecord>(1);
        DatanodeRegistration dnR = this.dn.getDNRegistrationForBP(block.getBlockPoolId());
        BlockRecoveryWorker.BlockRecord blockRecord = new BlockRecoveryWorker.BlockRecord(new DatanodeID((DatanodeID)dnR), (InterDatanodeProtocol)spyDN, new ReplicaRecoveryInfo(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), HdfsServerConstants.ReplicaState.FINALIZED));
        blocks.add(blockRecord);
        return blocks;
    }

    @Test(timeout=60000L)
    public void testFailedReplicaUpdate() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ((DataNode)Mockito.doThrow((Throwable)new IOException()).when((Object)this.spyDN)).updateReplicaUnderRecovery(block, 3000L, 1000L, block.getNumBytes());
        try {
            BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
            blockRecoveryWorker.getClass();
            BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
            RecoveryTaskContiguous2.syncBlock(this.initBlockRecords(this.spyDN));
            Assert.fail((String)"Sync should fail");
        }
        catch (IOException e) {
            e.getMessage().startsWith("Cannot recover ");
        }
    }

    @Test(timeout=60000L)
    public void testNoReplicaUnderRecovery() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        this.dn.data.createRbw(StorageType.DEFAULT, block, false);
        BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
        blockRecoveryWorker.getClass();
        BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
        try {
            RecoveryTaskContiguous2.syncBlock(this.initBlockRecords(this.dn));
            Assert.fail((String)"Sync should fail");
        }
        catch (IOException e) {
            e.getMessage().startsWith("Cannot recover ");
        }
        DatanodeProtocolClientSideTranslatorPB namenode = this.recoveryWorker.getActiveNamenodeForBP(POOL_ID);
        ((DatanodeProtocol)Mockito.verify((Object)namenode, (VerificationMode)Mockito.never())).commitBlockSynchronization((ExtendedBlock)Matchers.any(ExtendedBlock.class), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyBoolean(), (DatanodeID[])Matchers.any(DatanodeID[].class), (String[])Matchers.any(String[].class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNotMatchedReplicaID() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ReplicaInPipelineInterface replicaInfo = this.dn.data.createRbw(StorageType.DEFAULT, block, false).getReplica();
        try (ReplicaOutputStreams streams = null;){
            streams = replicaInfo.createStreams(true, DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512));
            streams.getChecksumOut().write(97);
            this.dn.data.initReplicaRecovery(new BlockRecoveryCommand.RecoveringBlock(block, null, 3001L));
            BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
            blockRecoveryWorker.getClass();
            BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
            try {
                RecoveryTaskContiguous2.syncBlock(this.initBlockRecords(this.dn));
                Assert.fail((String)"Sync should fail");
            }
            catch (IOException e) {
                e.getMessage().startsWith("Cannot recover ");
            }
            DatanodeProtocolClientSideTranslatorPB namenode = this.recoveryWorker.getActiveNamenodeForBP(POOL_ID);
            ((DatanodeProtocol)Mockito.verify((Object)namenode, (VerificationMode)Mockito.never())).commitBlockSynchronization((ExtendedBlock)Matchers.any(ExtendedBlock.class), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyBoolean(), (DatanodeID[])Matchers.any(DatanodeID[].class), (String[])Matchers.any(String[].class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testRaceBetweenReplicaRecoveryAndFinalizeBlock() throws Exception {
        this.tearDown();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.xceiver.stop.timeout.millis", "1000");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/test");
            FSDataOutputStream out = fs.create(path);
            out.writeBytes("data");
            out.hsync();
            List<LocatedBlock> blocks = DFSTestUtil.getAllBlocks(fs.open(path));
            final LocatedBlock block = blocks.get(0);
            final DataNode dataNode = cluster.getDataNodes().get(0);
            final AtomicBoolean recoveryInitResult = new AtomicBoolean(true);
            Thread recoveryThread = new Thread(){

                @Override
                public void run() {
                    try {
                        DatanodeInfo[] locations = block.getLocations();
                        BlockRecoveryCommand.RecoveringBlock recoveringBlock = new BlockRecoveryCommand.RecoveringBlock(block.getBlock(), locations, block.getBlock().getGenerationStamp() + 1L);
                        try (AutoCloseableLock lock = dataNode.data.acquireDatasetLock();){
                            Thread.sleep(2000L);
                            dataNode.initReplicaRecovery(recoveringBlock);
                        }
                    }
                    catch (Exception e) {
                        recoveryInitResult.set(false);
                    }
                }
            };
            recoveryThread.start();
            try {
                out.close();
            }
            catch (IOException e) {
                Assert.assertTrue((String)"Writing should fail", (boolean)e.getMessage().contains("are bad. Aborting..."));
            }
            finally {
                recoveryThread.join();
            }
            Assert.assertTrue((String)"Recovery should be initiated successfully", (boolean)recoveryInitResult.get());
            dataNode.updateReplicaUnderRecovery(block.getBlock(), block.getBlock().getGenerationStamp() + 1L, block.getBlock().getBlockId(), block.getBlockSize());
        }
        finally {
            if (null != cluster) {
                cluster.shutdown();
                cluster = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRURReplicas() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running " + GenericTestUtils.getMethodName()));
        }
        ((DataNode)Mockito.doReturn((Object)new ReplicaRecoveryInfo(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), HdfsServerConstants.ReplicaState.RUR)).when((Object)this.spyDN)).initReplicaRecovery((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class));
        boolean exceptionThrown = false;
        try {
            for (BlockRecoveryCommand.RecoveringBlock rBlock : this.initRecoveringBlocks()) {
                BlockRecoveryWorker blockRecoveryWorker = this.recoveryWorker;
                blockRecoveryWorker.getClass();
                BlockRecoveryWorker.RecoveryTaskContiguous RecoveryTaskContiguous2 = new BlockRecoveryWorker.RecoveryTaskContiguous(blockRecoveryWorker, rBlock);
                BlockRecoveryWorker.RecoveryTaskContiguous spyTask = (BlockRecoveryWorker.RecoveryTaskContiguous)Mockito.spy((Object)RecoveryTaskContiguous2);
                spyTask.recover();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)("Wrong exception was thrown: " + e.getMessage()), (boolean)e.getMessage().contains("Found 1 replica(s) for block " + block + " but none is in RWR or better state"));
            exceptionThrown = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionThrown);
        }
    }

    @Test(timeout=90000L)
    public void testInitReplicaRecoveryDoesNotHoldLock() throws Exception {
        this.testStopWorker(new TestStopWorkerRunnable(){

            @Override
            public String opName() {
                return "initReplicaRecovery";
            }

            @Override
            public void run(BlockRecoveryCommand.RecoveringBlock recoveringBlock) throws Exception {
                block2: {
                    try {
                        TestBlockRecovery.this.spyDN.initReplicaRecovery(recoveringBlock);
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("meta does not exist")) break block2;
                        throw e;
                    }
                }
            }
        });
    }

    @Test(timeout=90000L)
    public void testRecoverAppendDoesNotHoldLock() throws Exception {
        this.testStopWorker(new TestStopWorkerRunnable(){

            @Override
            public String opName() {
                return "recoverAppend";
            }

            @Override
            public void run(BlockRecoveryCommand.RecoveringBlock recoveringBlock) throws Exception {
                block2: {
                    try {
                        ExtendedBlock extBlock = recoveringBlock.getBlock();
                        TestBlockRecovery.this.spyDN.getFSDataset().recoverAppend(extBlock, extBlock.getGenerationStamp() + 1L, extBlock.getNumBytes());
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("Corrupted replica ReplicaBeingWritten")) break block2;
                        throw e;
                    }
                }
            }
        });
    }

    @Test(timeout=90000L)
    public void testRecoverCloseDoesNotHoldLock() throws Exception {
        this.testStopWorker(new TestStopWorkerRunnable(){

            @Override
            public String opName() {
                return "recoverClose";
            }

            @Override
            public void run(BlockRecoveryCommand.RecoveringBlock recoveringBlock) throws Exception {
                block2: {
                    try {
                        ExtendedBlock extBlock = recoveringBlock.getBlock();
                        TestBlockRecovery.this.spyDN.getFSDataset().recoverClose(extBlock, extBlock.getGenerationStamp() + 1L, extBlock.getNumBytes());
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("Corrupted replica ReplicaBeingWritten")) break block2;
                        throw e;
                    }
                }
            }
        });
    }

    private void testStopWorker(final TestStopWorkerRunnable tswr) throws Exception {
        LOG.debug((Object)("Running " + this.currentTestName.getMethodName()));
        Assert.assertEquals((long)1000000000L, (long)this.dn.getDnConf().getXceiverStopTimeout());
        final TestStopWorkerSemaphore progressParent = new TestStopWorkerSemaphore();
        final TestStopWorkerSemaphore terminateSlowWriter = new TestStopWorkerSemaphore();
        final AtomicReference<Object> failure = new AtomicReference<Object>(null);
        Collection<BlockRecoveryCommand.RecoveringBlock> recoveringBlocks = this.initRecoveringBlocks();
        final BlockRecoveryCommand.RecoveringBlock recoveringBlock = (BlockRecoveryCommand.RecoveringBlock)Iterators.get(recoveringBlocks.iterator(), (int)0);
        final ExtendedBlock block = recoveringBlock.getBlock();
        Thread slowWriterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug((Object)"slowWriter creating rbw");
                    ReplicaHandler replicaHandler = ((TestBlockRecovery)TestBlockRecovery.this).spyDN.data.createRbw(StorageType.DISK, block, false);
                    replicaHandler.close();
                    LOG.debug((Object)"slowWriter created rbw");
                    progressParent.sem.release();
                    terminateSlowWriter.uninterruptiblyAcquire(60000L);
                    LOG.debug((Object)"slowWriter exiting");
                }
                catch (Throwable t) {
                    LOG.error((Object)"slowWriter got exception", t);
                    failure.compareAndSet(null, "slowWriter got exception " + t.getMessage());
                }
            }
        });
        slowWriterThread.start();
        progressParent.uninterruptiblyAcquire(60000L);
        Thread stopWriterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug((Object)("initiating " + tswr.opName()));
                    tswr.run(recoveringBlock);
                    LOG.debug((Object)("finished " + tswr.opName()));
                }
                catch (Throwable t) {
                    LOG.error((Object)("stopWriterThread got unexpected exception for " + tswr.opName()), t);
                    failure.compareAndSet(null, "stopWriterThread got unexpected exception for " + tswr.opName() + ": " + t.getMessage());
                }
            }
        });
        stopWriterThread.start();
        while (!terminateSlowWriter.gotInterruption.get()) {
            Thread.sleep(1L);
        }
        this.spyDN.getFSDataset().getReplicaString(recoveringBlock.getBlock().getBlockPoolId(), recoveringBlock.getBlock().getBlockId());
        terminateSlowWriter.sem.release();
        slowWriterThread.join();
        stopWriterThread.join();
        String failureReason = failure.get();
        if (failureReason != null) {
            Assert.fail((String)("Thread failure: " + failureReason));
        }
    }

    @Test(timeout=300000L)
    public void testRecoverySlowerThanHeartbeat() throws Exception {
        this.tearDown();
        GenericTestUtils.SleepAnswer delayer = new GenericTestUtils.SleepAnswer(3000, 6000);
        this.testRecoveryWithDatanodeDelayed(delayer);
    }

    @Test(timeout=300000L)
    public void testRecoveryTimeout() throws Exception {
        this.tearDown();
        final Random r = new Random();
        GenericTestUtils.SleepAnswer delayer = new GenericTestUtils.SleepAnswer(3000){
            private final AtomicBoolean callRealMethod;
            {
                super(x0);
                this.callRealMethod = new AtomicBoolean();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object answer(InvocationOnMock invocation) throws Throwable {
                boolean interrupted = false;
                try {
                    Thread.sleep(r.nextInt(3000) + 6000);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                try {
                    if (this.callRealMethod.get()) {
                        Object object = invocation.callRealMethod();
                        return object;
                    }
                    this.callRealMethod.set(true);
                    Object var3_5 = null;
                    return var3_5;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.testRecoveryWithDatanodeDelayed(delayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRecoveryWithDatanodeDelayed(GenericTestUtils.SleepAnswer recoveryDelayer) throws Exception {
        HdfsConfiguration configuration = new HdfsConfiguration();
        configuration.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)configuration).numDataNodes(2).build();
            cluster.waitActive();
            final FSNamesystem ns = cluster.getNamesystem();
            NameNode nn = cluster.getNameNode();
            DistributedFileSystem dfs = cluster.getFileSystem();
            cluster.setBlockRecoveryTimeout(TimeUnit.SECONDS.toMillis(15L));
            FSDataOutputStream out = dfs.create(new Path("/testSlowRecovery"), (short)2);
            out.write(AppendTestUtil.randomBytes(0L, 4096));
            out.hsync();
            ArrayList<DataNode> dataNodes = cluster.getDataNodes();
            for (DataNode datanode : dataNodes) {
                DatanodeProtocolClientSideTranslatorPB nnSpy = InternalDataNodeTestUtils.spyOnBposToNN(datanode, nn);
                ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)recoveryDelayer).when((Object)nnSpy)).commitBlockSynchronization((ExtendedBlock)Mockito.any(ExtendedBlock.class), (long)Mockito.anyInt(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean(), (DatanodeID[])Mockito.any(DatanodeID[].class), (String[])Mockito.any(String[].class));
            }
            cluster.setLeasePeriod(100L, 100L);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return ns.getCompleteBlocksTotal() > 0L;
                }
            }, (int)300, (int)300000);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRecoveryWillIgnoreMinReplication() throws Exception {
        this.tearDown();
        int blockSize = 4096;
        int numReplicas = 3;
        String filename = "/testIgnoreMinReplication";
        final Path filePath = new Path("/testIgnoreMinReplication");
        HdfsConfiguration configuration = new HdfsConfiguration();
        configuration.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        configuration.setInt("dfs.namenode.replication.min", 2);
        configuration.setLong("dfs.blocksize", 4096L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)configuration).numDataNodes(5).build();
            cluster.waitActive();
            final DistributedFileSystem dfs = cluster.getFileSystem();
            final FSNamesystem fsn = cluster.getNamesystem();
            FSDataOutputStream out = dfs.create(filePath, (short)3);
            out.write(AppendTestUtil.randomBytes(0L, 4096));
            out.hsync();
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)configuration);
            LocatedBlock blk = dfsClient.getNamenode().getBlockLocations("/testIgnoreMinReplication", 0L, 4096L).getLastLocatedBlock();
            List<DatanodeInfo> dataNodes = Arrays.asList(blk.getLocations());
            Assert.assertEquals((long)dataNodes.size(), (long)3L);
            for (DatanodeInfo dataNode : dataNodes.subList(0, 2)) {
                cluster.stopDataNode(dataNode.getName());
            }
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return fsn.getNumDeadDataNodes() == 2;
                }
            }, (int)300, (int)300000);
            cluster.setLeasePeriod(100L, 100L);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        return dfs.isFileClosed(filePath);
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }, (int)300, (int)300000);
            DFSTestUtil.waitForReplication(cluster, DFSTestUtil.getFirstBlock((FileSystem)dfs, filePath), 1, 3, 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static {
        GenericTestUtils.setLogLevel((Log)FSNamesystem.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Log)LOG, (Level)Level.ALL);
        rBlock = new BlockRecoveryCommand.RecoveringBlock(block, null, 3000L);
    }

    private static interface TestStopWorkerRunnable {
        public String opName();

        public void run(BlockRecoveryCommand.RecoveringBlock var1) throws Exception;
    }

    private static class TestStopWorkerSemaphore {
        final Semaphore sem;
        final AtomicBoolean gotInterruption = new AtomicBoolean(false);

        TestStopWorkerSemaphore() {
            this.sem = new Semaphore(0);
        }

        private void uninterruptiblyAcquire(long timeoutMs) throws Exception {
            long startTimeMs = Time.monotonicNow();
            while (true) {
                long remTime;
                if ((remTime = startTimeMs + timeoutMs - Time.monotonicNow()) < 0L) {
                    throw new RuntimeException("Failed to acquire the semaphore within " + timeoutMs + " milliseconds.");
                }
                try {
                    if (!this.sem.tryAcquire(1, remTime, TimeUnit.MILLISECONDS)) continue;
                    return;
                }
                catch (InterruptedException e) {
                    this.gotInterruption.set(true);
                    continue;
                }
                break;
            }
        }
    }
}

