/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDataNodeVolumeFailureReporting {
    private static final Log LOG = LogFactory.getLog(TestDataNodeVolumeFailureReporting.class);
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private String dataDir;
    private long volumeCapacity;
    final int WAIT_FOR_HEARTBEATS = 3000;
    final int WAIT_FOR_DEATH = 15000;

    public TestDataNodeVolumeFailureReporting() {
        GenericTestUtils.setLogLevel((Log)LOG, (Level)Level.ALL);
        this.WAIT_FOR_HEARTBEATS = 3000;
        this.WAIT_FOR_DEATH = 15000;
    }

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        this.initCluster(1, 2, 1);
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testSuccessiveVolumeFailures() throws Exception {
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        Thread.sleep(3000L);
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn2Vol1 = new File(this.dataDir, "data3");
        File dn3Vol1 = new File(this.dataDir, "data5");
        File dn3Vol2 = new File(this.dataDir, "data6");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn2Vol1);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)3);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
        Assert.assertTrue((String)"DN2 should be up", (boolean)dns.get(1).isDatanodeUp());
        Assert.assertTrue((String)"DN3 should be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(2), 0L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(2), true, new String[0]);
        DataNodeTestUtils.injectDataDirFailure(dn3Vol1);
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile(this.fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file2, (short)3);
        Assert.assertTrue((String)"DN3 should still be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(2), 1L, true, dn3Vol1.getAbsolutePath());
        DataNodeTestUtils.triggerHeartbeat(dns.get(2));
        this.checkFailuresAtNameNode(dm, dns.get(2), true, dn3Vol1.getAbsolutePath());
        dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 3L, origCapacity - 3L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 3);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(2), true, dn3Vol1.getAbsolutePath());
        DataNodeTestUtils.injectDataDirFailure(dn3Vol2);
        Path file3 = new Path("/test3");
        DFSTestUtil.createFile(this.fs, file3, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file3, (short)2);
        DFSTestUtil.waitForDatanodeDeath(dns.get(2));
        this.checkFailuresAtDataNode(dns.get(2), 2L, true, dn3Vol1.getAbsolutePath(), dn3Vol2.getAbsolutePath());
        DFSTestUtil.waitForDatanodeStatus(dm, 2, 1, 2L, origCapacity - 4L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        DataNodeTestUtils.restoreDataDirFromFailure(dn1Vol1, dn2Vol1, dn3Vol1, dn3Vol2);
        this.cluster.restartDataNodes();
        this.cluster.waitActive();
        Path file4 = new Path("/test4");
        DFSTestUtil.createFile(this.fs, file4, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file4, (short)3);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 0L, origCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 0);
        dns = this.cluster.getDataNodes();
        this.checkFailuresAtNameNode(dm, dns.get(0), true, new String[0]);
        this.checkFailuresAtNameNode(dm, dns.get(1), true, new String[0]);
        this.checkFailuresAtNameNode(dm, dns.get(2), true, new String[0]);
    }

    @Test
    public void testVolFailureStatsPreservedOnNNRestart() throws Exception {
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn2Vol1 = new File(this.dataDir, "data3");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn2Vol1);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        this.cluster.restartNameNode(0);
        this.cluster.waitActive();
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
    }

    @Test
    public void testMultipleVolFailuresOnNode() throws Exception {
        this.tearDown();
        this.initCluster(3, 4, 2);
        Thread.sleep(3000L);
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn1Vol2 = new File(this.dataDir, "data2");
        File dn2Vol1 = new File(this.dataDir, "data5");
        File dn2Vol2 = new File(this.dataDir, "data6");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn1Vol2, dn2Vol1, dn2Vol2);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)3);
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile(this.fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file2, (short)3);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
        Assert.assertTrue((String)"DN2 should be up", (boolean)dns.get(1).isDatanodeUp());
        Assert.assertTrue((String)"DN3 should be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath(), dn1Vol2.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath(), dn2Vol2.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(2), 0L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 4L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 4);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath(), dn1Vol2.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath(), dn2Vol2.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(2), true, new String[0]);
    }

    @Test
    public void testDataNodeReconfigureWithVolumeFailures() throws Exception {
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn1Vol1 = new File(this.dataDir, "data1");
        File dn1Vol2 = new File(this.dataDir, "data2");
        File dn2Vol1 = new File(this.dataDir, "data3");
        File dn2Vol2 = new File(this.dataDir, "data4");
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1);
        DataNodeTestUtils.injectDataDirFailure(dn2Vol1);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        Assert.assertTrue((String)"DN1 should be up", (boolean)dns.get(0).isDatanodeUp());
        Assert.assertTrue((String)"DN2 should be up", (boolean)dns.get(1).isDatanodeUp());
        Assert.assertTrue((String)"DN3 should be up", (boolean)dns.get(2).isDatanodeUp());
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(2), 0L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        DataNodeTestUtils.reconfigureDataNode(dns.get(0), dn1Vol1, dn1Vol2);
        DataNodeTestUtils.reconfigureDataNode(dns.get(1), dn2Vol1, dn2Vol2);
        DataNodeTestUtils.triggerHeartbeat(dns.get(0));
        DataNodeTestUtils.triggerHeartbeat(dns.get(1));
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath());
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        DataNodeTestUtils.reconfigureDataNode(dns.get(0), dn1Vol1, dn1Vol2);
        DataNodeTestUtils.reconfigureDataNode(dns.get(1), dn2Vol1, dn2Vol2);
        DataNodeTestUtils.triggerHeartbeat(dns.get(0));
        DataNodeTestUtils.triggerHeartbeat(dns.get(1));
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, dn2Vol1.getAbsolutePath());
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 2L, origCapacity - 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 2);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, dn1Vol1.getAbsolutePath());
        this.checkFailuresAtNameNode(dm, dns.get(1), true, dn2Vol1.getAbsolutePath());
        DataNodeTestUtils.restoreDataDirFromFailure(dn1Vol1, dn2Vol1);
        DataNodeTestUtils.reconfigureDataNode(dns.get(0), dn1Vol1, dn1Vol2);
        DataNodeTestUtils.reconfigureDataNode(dns.get(1), dn2Vol1, dn2Vol2);
        DataNodeTestUtils.triggerHeartbeat(dns.get(0));
        DataNodeTestUtils.triggerHeartbeat(dns.get(1));
        this.checkFailuresAtDataNode(dns.get(0), 1L, true, new String[0]);
        this.checkFailuresAtDataNode(dns.get(1), 1L, true, new String[0]);
        DFSTestUtil.waitForDatanodeStatus(dm, 3, 0, 0L, origCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(true, 0);
        this.checkFailuresAtNameNode(dm, dns.get(0), true, new String[0]);
        this.checkFailuresAtNameNode(dm, dns.get(1), true, new String[0]);
    }

    @Test
    public void testAutoFormatEmptyDirectory() throws Exception {
        File dn1Vol1 = this.cluster.getStorageDir(0, 0);
        File current = new File(dn1Vol1, "current");
        File currentVersion = new File(current, "VERSION");
        currentVersion.delete();
        Assert.assertTrue((boolean)this.cluster.restartDataNodes(true));
        this.cluster.waitActive();
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        DataNode dn = dns.get(0);
        Assert.assertFalse((String)"DataNode should not reformat if VERSION is missing", (boolean)currentVersion.exists());
        Object[] expectedFailedVolumes = new String[]{dn1Vol1.getAbsolutePath()};
        DataNodeTestUtils.triggerHeartbeat(dn);
        FsDatasetSpi fsd = dn.getFSDataset();
        Assert.assertEquals((long)expectedFailedVolumes.length, (long)fsd.getNumFailedVolumes());
        Assert.assertArrayEquals((Object[])expectedFailedVolumes, (Object[])fsd.getFailedStorageLocations());
        this.checkFailuresAtDataNode(dn, 0L, false, (String[])expectedFailedVolumes);
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        DFSTestUtil.waitForDatanodeStatus(dm, 1, 0, 1L, 1L * dnCapacity, 3000L);
        this.checkAggregateFailuresAtNameNode(false, 1);
        this.checkFailuresAtNameNode(dm, dns.get(0), false, dn1Vol1.getAbsolutePath());
    }

    @Test
    public void testAutoFormatEmptyBlockPoolDirectory() throws Exception {
        DataNode dn = this.cluster.getDataNodes().get(0);
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        BlockPoolSliceStorage bps = dn.getStorage().getBPStorage(bpid);
        Storage.StorageDirectory dir = bps.getStorageDir(0);
        File current = dir.getCurrentDir();
        File currentVersion = new File(current, "VERSION");
        currentVersion.delete();
        Assert.assertTrue((boolean)this.cluster.restartDataNodes(true));
        this.cluster.waitActive();
        Assert.assertFalse((String)"DataNode should not reformat if VERSION is missing", (boolean)currentVersion.exists());
    }

    @Test(timeout=120000L)
    public void testHotSwapOutFailedVolumeAndReporting() throws Exception {
        LOG.info((Object)"Starting testHotSwapOutFailedVolumeAndReporting!");
        File dn0Vol1 = new File(this.dataDir, "data1");
        File dn0Vol2 = new File(this.dataDir, "data2");
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        String oldDataDirs = dn0.getConf().get("dfs.datanode.data.dir");
        final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        final ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=FSDatasetState-" + dn0.getDatanodeUuid());
        int numFailedVolumes = (Integer)mbs.getAttribute(mxbeanName, "NumFailedVolumes");
        Assert.assertEquals((long)dn0.getFSDataset().getNumFailedVolumes(), (long)numFailedVolumes);
        this.checkFailuresAtDataNode(dn0, 0L, false, new String[0]);
        DataNodeTestUtils.injectDataDirFailure(dn0Vol1);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol1));
        numFailedVolumes = (Integer)mbs.getAttribute(mxbeanName, "NumFailedVolumes");
        Assert.assertEquals((long)1L, (long)numFailedVolumes);
        Assert.assertEquals((long)dn0.getFSDataset().getNumFailedVolumes(), (long)numFailedVolumes);
        this.checkFailuresAtDataNode(dn0, 1L, true, dn0Vol1.getAbsolutePath());
        try {
            dn0.reconfigurePropertyImpl("dfs.datanode.data.dir", oldDataDirs);
        }
        catch (ReconfigurationException e) {
            Assert.assertTrue((String)"Reconfigure exception doesn't have expected path!", (boolean)e.getCause().getMessage().contains(dn0Vol1.getAbsolutePath()));
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    return (Integer)mbs.getAttribute(mxbeanName, "NumFailedVolumes") == 1;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, (int)1000, (int)30000);
        Assert.assertEquals((long)dn0.getFSDataset().getNumFailedVolumes(), (long)numFailedVolumes);
        this.checkFailuresAtDataNode(dn0, 1L, true, dn0Vol1.getAbsolutePath());
        String dataDirs = dn0Vol2.getPath();
        dn0.reconfigurePropertyImpl("dfs.datanode.data.dir", dataDirs);
        numFailedVolumes = (Integer)mbs.getAttribute(mxbeanName, "NumFailedVolumes");
        Assert.assertEquals((long)0L, (long)numFailedVolumes);
        Assert.assertEquals((long)dn0.getFSDataset().getNumFailedVolumes(), (long)numFailedVolumes);
        this.checkFailuresAtDataNode(dn0, 0L, true, new String[0]);
        DataNodeTestUtils.restoreDataDirFromFailure(dn0Vol1);
        dn0.reconfigurePropertyImpl("dfs.datanode.data.dir", oldDataDirs);
        numFailedVolumes = (Integer)mbs.getAttribute(mxbeanName, "NumFailedVolumes");
        Assert.assertEquals((long)0L, (long)numFailedVolumes);
        Assert.assertEquals((long)dn0.getFSDataset().getNumFailedVolumes(), (long)numFailedVolumes);
        this.checkFailuresAtDataNode(dn0, 0L, true, new String[0]);
        DataNodeTestUtils.injectDataDirFailure(dn0Vol2);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol2));
        numFailedVolumes = (Integer)mbs.getAttribute(mxbeanName, "NumFailedVolumes");
        Assert.assertEquals((long)1L, (long)numFailedVolumes);
        Assert.assertEquals((long)dn0.getFSDataset().getNumFailedVolumes(), (long)numFailedVolumes);
        this.checkFailuresAtDataNode(dn0, 1L, true, dn0Vol2.getAbsolutePath());
        Assert.assertTrue((boolean)dn0.shouldRun());
    }

    private void checkAggregateFailuresAtNameNode(boolean expectCapacityKnown, int expectedVolumeFailuresTotal) {
        FSNamesystem ns = this.cluster.getNamesystem();
        Assert.assertEquals((long)expectedVolumeFailuresTotal, (long)ns.getVolumeFailuresTotal());
        long expectedCapacityLost = this.getExpectedCapacityLost(expectCapacityKnown, expectedVolumeFailuresTotal);
        Assert.assertEquals((long)expectedCapacityLost, (long)ns.getEstimatedCapacityLostTotal());
    }

    private void checkFailuresAtDataNode(DataNode dn, long expectedVolumeFailuresCounter, boolean expectCapacityKnown, String ... expectedFailedVolumes) throws Exception {
        FsDatasetSpi fsd = dn.getFSDataset();
        Assert.assertEquals((long)expectedFailedVolumes.length, (long)fsd.getNumFailedVolumes());
        Assert.assertArrayEquals((Object[])expectedFailedVolumes, (Object[])fsd.getFailedStorageLocations());
        if (expectedFailedVolumes.length > 0) {
            Assert.assertTrue((fsd.getLastVolumeFailureDate() > 0L ? 1 : 0) != 0);
            long expectedCapacityLost = this.getExpectedCapacityLost(expectCapacityKnown, expectedFailedVolumes.length);
            Assert.assertEquals((long)expectedCapacityLost, (long)fsd.getEstimatedCapacityLostTotal());
        } else {
            Assert.assertEquals((long)0L, (long)fsd.getLastVolumeFailureDate());
            Assert.assertEquals((long)0L, (long)fsd.getEstimatedCapacityLostTotal());
        }
    }

    private void checkFailuresAtNameNode(DatanodeManager dm, DataNode dn, boolean expectCapacityKnown, String ... expectedFailedVolumes) throws Exception {
        DatanodeDescriptor dd = this.cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId());
        Assert.assertEquals((long)expectedFailedVolumes.length, (long)dd.getVolumeFailures());
        VolumeFailureSummary volumeFailureSummary = dd.getVolumeFailureSummary();
        if (expectedFailedVolumes.length > 0) {
            Assert.assertArrayEquals((Object[])expectedFailedVolumes, (Object[])volumeFailureSummary.getFailedStorageLocations());
            Assert.assertTrue((volumeFailureSummary.getLastVolumeFailureDate() > 0L ? 1 : 0) != 0);
            long expectedCapacityLost = this.getExpectedCapacityLost(expectCapacityKnown, expectedFailedVolumes.length);
            Assert.assertEquals((long)expectedCapacityLost, (long)volumeFailureSummary.getEstimatedCapacityLostTotal());
        } else {
            Assert.assertNull((Object)volumeFailureSummary);
        }
    }

    private long getExpectedCapacityLost(boolean expectCapacityKnown, int expectedVolumeFailuresTotal) {
        return expectCapacityKnown ? (long)expectedVolumeFailuresTotal * this.volumeCapacity : 0L;
    }

    private void initCluster(int numDataNodes, int storagesPerDatanode, int failedVolumesTolerated) throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.df.interval", 1000);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", failedVolumesTolerated);
        this.conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numDataNodes).storagesPerDatanode(storagesPerDatanode).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.dataDir = this.cluster.getDataDirectory();
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(this.cluster.getNamesystem().getBlockManager().getDatanodeManager(), 0);
        this.volumeCapacity = dnCapacity / (long)this.cluster.getStoragesPerDatanode();
    }
}

