/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFsVolumeList {
    private final Configuration conf = new Configuration();
    private VolumeChoosingPolicy<FsVolumeImpl> blockChooser = new RoundRobinVolumeChoosingPolicy();
    private FsDatasetImpl dataset = null;
    private String baseDir;
    private BlockScanner blockScanner;

    @Before
    public void setUp() {
        this.dataset = (FsDatasetImpl)Mockito.mock(FsDatasetImpl.class);
        this.baseDir = new FileSystemTestHelper().getTestRootDir();
        Configuration blockScannerConf = new Configuration();
        blockScannerConf.setInt("dfs.datanode.scan.period.hours", -1);
        this.blockScanner = new BlockScanner(null, blockScannerConf);
    }

    @Test(timeout=30000L)
    public void testGetNextVolumeWithClosedVolume() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), this.blockScanner, this.blockChooser);
        final ArrayList<FsVolumeImpl> volumes = new ArrayList<FsVolumeImpl>();
        for (int i = 0; i < 3; ++i) {
            File curDir = new File(this.baseDir, "nextvolume-" + i);
            curDir.mkdirs();
            FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", curDir, this.conf, StorageType.DEFAULT);
            volume.setCapacityForTesting(0x40000000L);
            volumes.add(volume);
            volumeList.addVolume(volume.obtainReference());
        }
        ((FsVolumeImpl)volumes.get(1)).setClosed();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return ((FsVolumeImpl)volumes.get(1)).checkClosed();
                }
            }, (int)100, (int)3000);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out while waiting for volume to be removed.");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        for (int i = 0; i < 10; ++i) {
            try (FsVolumeReference ref = volumeList.getNextVolume(StorageType.DEFAULT, 128L);){
                Assert.assertNotEquals((Object)ref.getVolume(), volumes.get(1));
                continue;
            }
        }
    }

    @Test(timeout=30000L)
    public void testReleaseVolumeRefIfNoBlockScanner() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), null, this.blockChooser);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.DEFAULT);
        FsVolumeReference ref = volume.obtainReference();
        volumeList.addVolume(ref);
        Assert.assertNull((Object)ref.getVolume());
    }

    @Test
    public void testDfsReservedForDifferentStorageTypes() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.du.reserved", 100L);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.RAM_DISK);
        Assert.assertEquals((String)"", (long)100L, (long)volume.getReserved());
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.RAM_DISK.toString()), 1L);
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.SSD.toString()), 2L);
        FsVolumeImpl volume1 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.RAM_DISK);
        Assert.assertEquals((String)"", (long)1L, (long)volume1.getReserved());
        FsVolumeImpl volume2 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.SSD);
        Assert.assertEquals((String)"", (long)2L, (long)volume2.getReserved());
        FsVolumeImpl volume3 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.DISK);
        Assert.assertEquals((String)"", (long)100L, (long)volume3.getReserved());
        FsVolumeImpl volume4 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.DEFAULT);
        Assert.assertEquals((String)"", (long)100L, (long)volume4.getReserved());
    }

    @Test
    public void testNonDfsUsedMetricForVolume() throws Exception {
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        long diskCapacity = 1000L;
        long duReserved = 100L;
        long dfsUsage = 200L;
        long actualNonDfsUsage = 300L;
        long reservedForReplicas = 50L;
        this.conf.setLong("dfs.datanode.du.reserved", duReserved);
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.DEFAULT);
        FsVolumeImpl spyVolume = (FsVolumeImpl)Mockito.spy((Object)volume);
        long testCapacity = diskCapacity - duReserved;
        spyVolume.setCapacityForTesting(testCapacity);
        long dfAvailable = diskCapacity - dfsUsage - actualNonDfsUsage;
        ((FsVolumeImpl)Mockito.doReturn((Object)dfAvailable).when((Object)spyVolume)).getDfAvailable();
        ((FsVolumeImpl)Mockito.doReturn((Object)dfsUsage).when((Object)spyVolume)).getDfsUsed();
        ((FsVolumeImpl)Mockito.doReturn((Object)reservedForReplicas).when((Object)spyVolume)).getReservedForReplicas();
        ((FsVolumeImpl)Mockito.doReturn((Object)actualNonDfsUsage).when((Object)spyVolume)).getActualNonDfsUsed();
        long expectedNonDfsUsage = actualNonDfsUsage - duReserved;
        Assert.assertEquals((long)expectedNonDfsUsage, (long)spyVolume.getNonDfsUsed());
    }
}

