/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpServer2;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestDatanodeHttpXFrame {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testDataNodeXFrameOptionsEnabled() throws Exception {
        boolean xFrameEnabled = true;
        MiniDFSCluster cluster = this.createCluster(xFrameEnabled, null);
        HttpURLConnection conn = this.getConn(cluster);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((String)"X-FRAME-OPTIONS is absent in the header", (xfoHeader != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }

    @Test
    public void testNameNodeXFrameOptionsDisabled() throws Exception {
        boolean xFrameEnabled = false;
        MiniDFSCluster cluster = this.createCluster(xFrameEnabled, null);
        HttpURLConnection conn = this.getConn(cluster);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((String)"unexpected X-FRAME-OPTION in header", (xfoHeader == null ? 1 : 0) != 0);
    }

    @Test
    public void testDataNodeXFramewithInvalidOptions() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.createCluster(false, "Hadoop");
    }

    private MiniDFSCluster createCluster(boolean enabled, String value) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.xframe.enabled", enabled);
        if (value != null) {
            conf.set("dfs.xframe.value", value);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        return cluster;
    }

    private HttpURLConnection getConn(MiniDFSCluster cluster) throws IOException {
        DataNode datanode = cluster.getDataNodes().get(0);
        URL newURL = new URL("http://localhost:" + datanode.getInfoPort());
        HttpURLConnection conn = (HttpURLConnection)newURL.openConnection();
        conn.connect();
        return conn;
    }
}

