/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNestedEncryptionZones {
    private File testRootDir;
    private final String TOP_EZ_KEY = "topezkey";
    private final String NESTED_EZ_KEY = "nestedezkey";
    private MiniDFSCluster cluster;
    protected DistributedFileSystem fs;
    private final Path rootDir = new Path("/");
    private final Path rawDir = new Path("/.reserved/raw/");
    private Path nestedEZBaseFile = new Path(this.rootDir, "nestedEZBaseFile");
    private Path topEZBaseFile = new Path(this.rootDir, "topEZBaseFile");
    private Path topEZDir;
    private Path nestedEZDir;
    private Path topEZFile;
    private Path nestedEZFile;
    private Path topEZRawFile;
    private Path nestedEZRawFile;
    private final int len = 8196;

    private String getKeyProviderURI() {
        return "jceks://file" + new Path(this.testRootDir.toString(), "test.jks").toUri();
    }

    private void setProvider() {
        this.fs.getClient().setKeyProvider((KeyProvider)this.cluster.getNameNode().getNamesystem().getProvider());
    }

    @Before
    public void setup() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystemTestHelper fsHelper = new FileSystemTestHelper();
        String testRoot = fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
        conf.set("hadoop.security.key.provider.path", this.getKeyProviderURI());
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        conf.setLong("fs.trash.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        Logger.getLogger(EncryptionZoneManager.class).setLevel(Level.TRACE);
        this.fs = this.cluster.getFileSystem();
        this.setProvider();
        DFSTestUtil.createKey("topezkey", this.cluster, (Configuration)conf);
        DFSTestUtil.createKey("nestedezkey", this.cluster, (Configuration)conf);
    }

    @Test(timeout=60000L)
    public void testNestedEncryptionZones() throws Exception {
        this.initTopEZDirAndNestedEZDir(new Path(this.rootDir, "topEZ"));
        this.verifyEncryption();
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.verifyEncryption();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.verifyEncryption();
        this.renameChildrenOfEZ();
        Path topEZ2Dir = new Path(this.rootDir, "topEZ2");
        this.fs.mkdir(topEZ2Dir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(topEZ2Dir, "topezkey");
        try {
            this.fs.rename(topEZ2Dir, new Path(this.topEZDir, "topEZ2"));
            Assert.fail((String)"Shouldn't be able to move a non-nested EZ into another existing EZ.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("can't be moved into an encryption zone"));
        }
        this.fs.rename(this.topEZDir, new Path(this.rootDir, "newTopEZ"));
        this.fs.rename(new Path(this.rootDir, "newTopEZ/nestedEZ"), new Path(this.rootDir, "newTopEZ/newNestedEZ"));
    }

    @Test(timeout=60000L)
    public void testNestedEZWithRoot() throws Exception {
        this.initTopEZDirAndNestedEZDir(this.rootDir);
        this.verifyEncryption();
        this.renameChildrenOfEZ();
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        Path suffixTrashPath = new Path(".Trash", currentUser);
        Path rootTrash = this.fs.getTrashRoot(this.rootDir);
        Path topEZTrash = this.fs.getTrashRoot(this.topEZFile);
        Path nestedEZTrash = this.fs.getTrashRoot(this.nestedEZFile);
        Path expectedTopEZTrash = this.fs.makeQualified(new Path(this.topEZDir, suffixTrashPath));
        Path expectedNestedEZTrash = this.fs.makeQualified(new Path(this.nestedEZDir, suffixTrashPath));
        Assert.assertEquals((String)("Top ez trash should be " + expectedTopEZTrash), (Object)expectedTopEZTrash, (Object)topEZTrash);
        Assert.assertEquals((String)"Root trash should be equal with TopEZFile trash", (Object)topEZTrash, (Object)rootTrash);
        Assert.assertEquals((String)("Nested ez Trash should be " + expectedNestedEZTrash), (Object)expectedNestedEZTrash, (Object)nestedEZTrash);
        FsShell shell = new FsShell(this.fs.getConf());
        Path topTrashFile = new Path(shell.getCurrentTrashDir(this.topEZFile) + "/" + this.topEZFile);
        Path nestedTrashFile = new Path(shell.getCurrentTrashDir(this.nestedEZFile) + "/" + this.nestedEZFile);
        ToolRunner.run((Tool)shell, (String[])new String[]{"-rm", this.topEZFile.toString()});
        ToolRunner.run((Tool)shell, (String[])new String[]{"-rm", this.nestedEZFile.toString()});
        Assert.assertTrue((String)("File not in trash : " + topTrashFile), (boolean)this.fs.exists(topTrashFile));
        Assert.assertTrue((String)("File not in trash : " + nestedTrashFile), (boolean)this.fs.exists(nestedTrashFile));
    }

    private void renameChildrenOfEZ() throws Exception {
        Path renamedTopEZFile = new Path(this.topEZDir, "renamedFile");
        Path renamedNestedEZFile = new Path(this.nestedEZDir, "renamedFile");
        this.fs.rename(this.topEZFile, renamedTopEZFile);
        this.fs.rename(this.nestedEZFile, renamedNestedEZFile);
        this.topEZFile = renamedTopEZFile;
        this.nestedEZFile = renamedNestedEZFile;
        this.topEZRawFile = new Path(this.rawDir + this.topEZFile.toUri().getPath());
        this.nestedEZRawFile = new Path(this.rawDir + this.nestedEZFile.toUri().getPath());
        this.verifyEncryption();
        try {
            this.fs.rename(this.topEZFile, new Path(this.nestedEZDir, "movedTopEZFile"));
            Assert.fail((String)"Shouldn't be able to rename between top EZ and nested EZ.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("can't be moved from encryption zone " + this.topEZDir.toString() + " to encryption zone " + this.nestedEZDir.toString()));
        }
        try {
            this.fs.rename(this.nestedEZFile, new Path(this.topEZDir, "movedNestedEZFile"));
            Assert.fail((String)"Shouldn't be able to rename between top EZ and nested EZ.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("can't be moved from encryption zone " + this.nestedEZDir.toString() + " to encryption zone " + this.topEZDir.toString()));
        }
        try {
            this.fs.rename(this.nestedEZFile, new Path(this.rootDir, "movedNestedEZFile"));
            Assert.fail((String)"Shouldn't be able to move the nested EZ out of the top EZ.");
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            Assert.assertTrue((exceptionMsg.contains("can't be moved from") && exceptionMsg.contains("encryption zone") ? 1 : 0) != 0);
        }
    }

    private void initTopEZDirAndNestedEZDir(Path topPath) throws Exception {
        this.fs.delete(this.rootDir, true);
        this.topEZDir = topPath;
        this.nestedEZDir = new Path(this.topEZDir, "nestedEZ");
        this.topEZFile = new Path(this.topEZDir, "file");
        this.nestedEZFile = new Path(this.nestedEZDir, "file");
        this.topEZRawFile = new Path(this.rawDir + this.topEZFile.toUri().getPath());
        this.nestedEZRawFile = new Path(this.rawDir + this.nestedEZFile.toUri().getPath());
        this.fs.mkdir(this.topEZDir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(this.topEZDir, "topezkey");
        this.fs.mkdir(this.nestedEZDir, FsPermission.getDirDefault());
        this.fs.createEncryptionZone(this.nestedEZDir, "nestedezkey");
        DFSTestUtil.createFile((FileSystem)this.fs, this.topEZBaseFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.topEZFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.nestedEZBaseFile, 8196L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, this.nestedEZFile, 8196L, (short)1, 65261L);
    }

    private void verifyEncryption() throws Exception {
        Assert.assertEquals((String)"Top EZ dir is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.topEZDir).isEncrypted());
        Assert.assertEquals((String)"Nested EZ dir is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.nestedEZDir).isEncrypted());
        Assert.assertEquals((String)"Top zone file is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.topEZFile).isEncrypted());
        Assert.assertEquals((String)"Nested zone file is encrypted", (Object)true, (Object)this.fs.getFileStatus(this.nestedEZFile).isEncrypted());
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, this.topEZBaseFile, this.topEZFile, 8196);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, this.nestedEZBaseFile, this.nestedEZFile, 8196);
        DFSTestUtil.verifyFilesNotEqual((FileSystem)this.fs, this.topEZRawFile, this.nestedEZRawFile, 8196);
    }
}

