/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSAdminWithHA {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private MiniQJMHACluster cluster;
    private Configuration conf;
    private DFSAdmin admin;
    private static final PrintStream oldOut = System.out;
    private static final PrintStream oldErr = System.err;
    private static final String NSID = "ns1";
    private static String newLine = System.getProperty("line.separator");

    private void assertOutputMatches(String string) {
        String errOutput = new String(this.err.toByteArray(), Charsets.UTF_8);
        String output = new String(this.out.toByteArray(), Charsets.UTF_8);
        if (!errOutput.matches(string) && !output.matches(string)) {
            Assert.fail((String)("Expected output to match '" + string + "' but err_output was:\n" + errOutput + "\n and output was: \n" + output));
        }
        this.out.reset();
        this.err.reset();
    }

    private void setHAConf(Configuration conf, String nn1Addr, String nn2Addr) {
        conf.set("fs.defaultFS", "hdfs://ns1");
        conf.set("dfs.nameservices", NSID);
        conf.set("dfs.nameservice.id", NSID);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{NSID}), "nn1,nn2");
        conf.set("dfs.ha.namenode.id", "nn1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn1"}), nn1Addr);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn2"}), nn2Addr);
    }

    private void setUpHaCluster(boolean security) throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("hadoop.security.authorization", security);
        this.cluster = new MiniQJMHACluster.Builder(this.conf).build();
        this.setHAConf(this.conf, this.cluster.getDfsCluster().getNameNode(0).getHostAndPort(), this.cluster.getDfsCluster().getNameNode(1).getHostAndPort());
        this.cluster.getDfsCluster().getNameNode(0).getHostAndPort();
        this.admin = new DFSAdmin();
        this.admin.setConf(this.conf);
        Assert.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)this.conf, (String)NSID));
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        if (this.admin != null) {
            this.admin.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.out.reset();
        this.err.reset();
    }

    @Test(timeout=30000L)
    public void testSetSafeMode() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "get"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "leave"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Safe mode is OFF in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "get"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Safe mode is OFF in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testSaveNamespace() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Save namespace successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testSaveNamespaceNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Save namespace successful for.*" + newLine + "Save namespace failed for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testSaveNamespaceNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Save namespace failed for.*" + newLine + "Save namespace successful for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testSaveNamespaceNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Save namespace failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRestoreFailedStorage() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "restoreFailedStorage is set to false for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage is set to true for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage is set to false for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRestoreFailedStorageNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "restoreFailedStorage is set to false for.*" + newLine + "restoreFailedStorage failed for.*" + newLine;
        this.assertOutputMatches(message);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage is set to true for.*" + newLine + "restoreFailedStorage failed for.*" + newLine;
        this.assertOutputMatches(message);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage is set to false for.*" + newLine + "restoreFailedStorage failed for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRestoreFailedStorageNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "restoreFailedStorage failed for.*" + newLine + "restoreFailedStorage is set to false for.*" + newLine;
        this.assertOutputMatches(message);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage failed for.*" + newLine + "restoreFailedStorage is set to true for.*" + newLine;
        this.assertOutputMatches(message);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage failed for.*" + newLine + "restoreFailedStorage is set to false for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRestoreFailedStorageNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "restoreFailedStorage failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshNodes() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh nodes successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshNodesNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh nodes successful for.*" + newLine + "Refresh nodes failed for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshNodesNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh nodes failed for.*" + newLine + "Refresh nodes successful for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshNodesNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh nodes failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testSetBalancerBandwidth() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Balancer bandwidth is set to 10";
        this.assertOutputMatches(message + newLine);
    }

    @Test(timeout=30000L)
    public void testSetBalancerBandwidthNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Balancer bandwidth is set to 10";
        this.assertOutputMatches(message + newLine);
    }

    @Test(timeout=30000L)
    public void testSetBalancerBandwidthNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().transitionToActive(1);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Balancer bandwidth is set to 10";
        this.assertOutputMatches(message + newLine);
    }

    @Test
    public void testSetBalancerBandwidthNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Balancer bandwidth is set failed." + newLine + ".*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testSetNegativeBalancerBandwidth() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "-10"});
        Assert.assertEquals((String)"Negative bandwidth value must fail the command", (long)-1L, (long)exitCode);
    }

    @Test(timeout=30000L)
    public void testMetaSave() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Created metasave file dfs.meta in the log directory of namenode.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testMetaSaveNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Created metasave file dfs.meta in the log directory of namenode.*" + newLine + "Created metasave file dfs.meta in the log directory" + " of namenode.*failed" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testMetaSaveNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Created metasave file dfs.meta in the log directory of namenode.*failed" + newLine + "Created metasave file dfs.meta in the log directory" + " of namenode.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testMetaSaveNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Created metasave file dfs.meta in the log directory of namenode.*failed";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshServiceAcl() throws Exception {
        this.setUpHaCluster(true);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh service acl successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshServiceAclNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(true);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh service acl successful for.*" + newLine + "Refresh service acl failed for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshServiceAclNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(true);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh service acl failed for.*" + newLine + "Refresh service acl successful for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshServiceAclNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(true);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh service acl failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshUserToGroupsMappings() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh user to groups mapping successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshUserToGroupsMappingsNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh user to groups mapping successful for.*" + newLine + "Refresh user to groups mapping failed for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshUserToGroupsMappingsNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh user to groups mapping failed for.*" + newLine + "Refresh user to groups mapping successful for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshUserToGroupsMappingsNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh user to groups mapping failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh super user groups configuration successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshSuperUserGroupsConfigurationNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh super user groups configuration successful for.*" + newLine + "Refresh super user groups configuration failed for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshSuperUserGroupsConfigurationNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh super user groups configuration failed for.*" + newLine + "Refresh super user groups configuration successful for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshSuperUserGroupsConfigurationNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh super user groups configuration failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshCallQueue() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh call queue successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshCallQueueNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh call queue successful for.*" + newLine + "Refresh call queue failed for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshCallQueueNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh call queue failed for.*" + newLine + "Refresh call queue successful for.*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testRefreshCallQueueNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh call queue failed for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testFinalizeUpgrade() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = ".*Cannot finalize with no NameNode active";
        this.assertOutputMatches(message + newLine);
        this.cluster.getDfsCluster().transitionToActive(0);
        exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Finalize upgrade successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testFinalizeUpgradeNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Finalize upgrade successful for .*" + newLine + "Finalize upgrade failed for .*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testFinalizeUpgradeNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().transitionToActive(1);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Finalize upgrade failed for .*" + newLine + "Finalize upgrade successful for .*" + newLine;
        this.assertOutputMatches(message);
    }

    @Test(timeout=30000L)
    public void testFinalizeUpgradeNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-finalizeUpgrade"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = ".*2 exceptions.*";
        this.assertOutputMatches(message + newLine);
    }

    @Test(timeout=30000L)
    public void testListOpenFilesNN1UpNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        this.cluster.getDfsCluster().transitionToActive(0);
        int exitCode = this.admin.run(new String[]{"-listOpenFiles"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
    }

    @Test(timeout=30000L)
    public void testListOpenFilesNN1DownNN2Up() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().transitionToActive(1);
        int exitCode = this.admin.run(new String[]{"-listOpenFiles"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
    }

    @Test
    public void testListOpenFilesNN1DownNN2Down() throws Exception {
        this.setUpHaCluster(false);
        this.cluster.getDfsCluster().shutdownNameNode(0);
        this.cluster.getDfsCluster().shutdownNameNode(1);
        int exitCode = this.admin.run(new String[]{"-listOpenFiles"});
        Assert.assertNotEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = ".*" + newLine + "List open files failed." + newLine;
        this.assertOutputMatches(message);
    }
}

