/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.security.SaslPropertiesResolver;

@InterfaceAudience.Private
public class DNConf {
    final int socketTimeout;
    final int socketWriteTimeout;
    final int socketKeepaliveTimeout;
    private final int transferSocketSendBufferSize;
    private final int transferSocketRecvBufferSize;
    final boolean transferToAllowed;
    final boolean dropCacheBehindWrites;
    final boolean syncBehindWrites;
    final boolean syncBehindWritesInBackground;
    final boolean dropCacheBehindReads;
    final boolean syncOnClose;
    final boolean encryptDataTransfer;
    final boolean connectToDnViaHostname;
    final long readaheadLength;
    final long heartBeatInterval;
    private final long lifelineIntervalMs;
    final long blockReportInterval;
    final long blockReportSplitThreshold;
    final boolean peerStatsEnabled;
    final boolean diskStatsEnabled;
    final long outliersReportIntervalMs;
    final long ibrInterval;
    final long initialBlockReportDelayMs;
    final long cacheReportInterval;
    final long datanodeSlowIoWarningThresholdMs;
    final String minimumNameNodeVersion;
    final String encryptionAlgorithm;
    final SaslPropertiesResolver saslPropsResolver;
    final TrustedChannelResolver trustedChannelResolver;
    private final boolean ignoreSecurePortsForTesting;
    final long xceiverStopTimeout;
    final long restartReplicaExpiry;
    final long maxLockedMemory;
    private final long bpReadyTimeout;
    private final boolean allowNonLocalLazyPersist;
    private final int volFailuresTolerated;
    private final int volsConfigured;
    private final int maxDataLength;
    private Configurable dn;

    public DNConf(Configurable dn) {
        this.dn = dn;
        this.socketTimeout = this.getConf().getInt("dfs.client.socket-timeout", 60000);
        this.socketWriteTimeout = this.getConf().getInt("dfs.datanode.socket.write.timeout", 480000);
        this.socketKeepaliveTimeout = this.getConf().getInt("dfs.datanode.socket.reuse.keepalive", 4000);
        this.transferSocketSendBufferSize = this.getConf().getInt("dfs.datanode.transfer.socket.send.buffer.size", 0);
        this.transferSocketRecvBufferSize = this.getConf().getInt("dfs.datanode.transfer.socket.recv.buffer.size", 0);
        this.transferToAllowed = this.getConf().getBoolean("dfs.datanode.transferTo.allowed", true);
        this.readaheadLength = this.getConf().getLong("dfs.datanode.readahead.bytes", 0x400000L);
        this.maxDataLength = this.getConf().getInt("ipc.maximum.data.length", 0x4000000);
        this.dropCacheBehindWrites = this.getConf().getBoolean("dfs.datanode.drop.cache.behind.writes", false);
        this.syncBehindWrites = this.getConf().getBoolean("dfs.datanode.sync.behind.writes", false);
        this.syncBehindWritesInBackground = this.getConf().getBoolean("dfs.datanode.sync.behind.writes.in.background", false);
        this.dropCacheBehindReads = this.getConf().getBoolean("dfs.datanode.drop.cache.behind.reads", false);
        this.connectToDnViaHostname = this.getConf().getBoolean("dfs.datanode.use.datanode.hostname", false);
        this.blockReportInterval = this.getConf().getLong("dfs.blockreport.intervalMsec", 21600000L);
        this.peerStatsEnabled = this.getConf().getBoolean("dfs.datanode.peer.stats.enabled", false);
        this.diskStatsEnabled = Util.isDiskStatsEnabled(this.getConf().getInt("dfs.datanode.fileio.profiling.sampling.percentage", 0));
        this.outliersReportIntervalMs = this.getConf().getTimeDuration("dfs.datanode.outliers.report.interval", 1800000L, TimeUnit.MILLISECONDS);
        this.ibrInterval = this.getConf().getLong("dfs.blockreport.incremental.intervalMsec", 0L);
        this.blockReportSplitThreshold = this.getConf().getLong("dfs.blockreport.split.threshold", 1000000L);
        this.cacheReportInterval = this.getConf().getLong("dfs.cachereport.intervalMsec", 10000L);
        this.datanodeSlowIoWarningThresholdMs = this.getConf().getLong("dfs.datanode.slow.io.warning.threshold.ms", 300L);
        long initBRDelay = this.getConf().getLong("dfs.blockreport.initialDelay", 0L) * 1000L;
        if (initBRDelay >= this.blockReportInterval) {
            initBRDelay = 0L;
            DataNode.LOG.info("dfs.blockreport.initialDelay is greater than or equal todfs.blockreport.intervalMsec. Setting initial delay to 0 msec:");
        }
        this.initialBlockReportDelayMs = initBRDelay;
        this.heartBeatInterval = this.getConf().getLong("dfs.heartbeat.interval", 3L) * 1000L;
        long confLifelineIntervalMs = this.getConf().getLong("dfs.datanode.lifeline.interval.seconds", 3L * this.getConf().getLong("dfs.heartbeat.interval", 3L)) * 1000L;
        if (confLifelineIntervalMs <= this.heartBeatInterval) {
            confLifelineIntervalMs = 3L * this.heartBeatInterval;
            DataNode.LOG.warn(String.format("%s must be set to a value greater than %s.  Resetting value to 3 * %s, which is %d milliseconds.", "dfs.datanode.lifeline.interval.seconds", "dfs.heartbeat.interval", "dfs.heartbeat.interval", confLifelineIntervalMs));
        }
        this.lifelineIntervalMs = confLifelineIntervalMs;
        this.syncOnClose = this.getConf().getBoolean("dfs.datanode.synconclose", false);
        this.minimumNameNodeVersion = this.getConf().get("dfs.datanode.min.supported.namenode.version", "2.1.0-beta");
        this.encryptDataTransfer = this.getConf().getBoolean("dfs.encrypt.data.transfer", false);
        this.encryptionAlgorithm = this.getConf().get("dfs.encrypt.data.transfer.algorithm");
        this.trustedChannelResolver = TrustedChannelResolver.getInstance((Configuration)this.getConf());
        this.saslPropsResolver = DataTransferSaslUtil.getSaslPropertiesResolver((Configuration)this.getConf());
        this.ignoreSecurePortsForTesting = this.getConf().getBoolean("ignore.secure.ports.for.testing", false);
        this.xceiverStopTimeout = this.getConf().getLong("dfs.datanode.xceiver.stop.timeout.millis", 60000L);
        this.maxLockedMemory = this.getConf().getLong("dfs.datanode.max.locked.memory", 0L);
        this.restartReplicaExpiry = this.getConf().getLong("dfs.datanode.restart.replica.expiration", 50L) * 1000L;
        this.allowNonLocalLazyPersist = this.getConf().getBoolean("dfs.datanode.non.local.lazy.persist", false);
        this.bpReadyTimeout = this.getConf().getLong("dfs.datanode.bp-ready.timeout", 20L);
        this.volFailuresTolerated = this.getConf().getInt("dfs.datanode.failed.volumes.tolerated", 0);
        String[] dataDirs = this.getConf().getTrimmedStrings("dfs.datanode.data.dir");
        this.volsConfigured = dataDirs == null ? 0 : dataDirs.length;
    }

    String getMinimumNameNodeVersion() {
        return this.minimumNameNodeVersion;
    }

    public Configuration getConf() {
        return this.dn.getConf();
    }

    public boolean getEncryptDataTransfer() {
        return this.encryptDataTransfer;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public long getXceiverStopTimeout() {
        return this.xceiverStopTimeout;
    }

    public long getMaxLockedMemory() {
        return this.maxLockedMemory;
    }

    public SaslPropertiesResolver getSaslPropsResolver() {
        return this.saslPropsResolver;
    }

    public TrustedChannelResolver getTrustedChannelResolver() {
        return this.trustedChannelResolver;
    }

    public boolean getIgnoreSecurePortsForTesting() {
        return this.ignoreSecurePortsForTesting;
    }

    public boolean getAllowNonLocalLazyPersist() {
        return this.allowNonLocalLazyPersist;
    }

    public int getTransferSocketRecvBufferSize() {
        return this.transferSocketRecvBufferSize;
    }

    public int getTransferSocketSendBufferSize() {
        return this.transferSocketSendBufferSize;
    }

    public long getBpReadyTimeout() {
        return this.bpReadyTimeout;
    }

    public long getLifelineIntervalMs() {
        return this.lifelineIntervalMs;
    }

    public int getVolFailuresTolerated() {
        return this.volFailuresTolerated;
    }

    public int getVolsConfigured() {
        return this.volsConfigured;
    }

    public long getSlowIoWarningThresholdMs() {
        return this.datanodeSlowIoWarningThresholdMs;
    }

    int getMaxDataLength() {
        return this.maxDataLength;
    }
}

