/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.Test;

public class TestHarFileSystemWithHA {
    private static final Path TEST_HAR_PATH = new Path("/input.har");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarUriWithHaUriWithNoPort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
            cluster.transitionToActive(0);
            HATestUtil.setFailoverConfigurations(cluster, (Configuration)conf);
            TestHarFileSystemWithHA.createEmptyHarArchive((FileSystem)HATestUtil.configureFailoverFs(cluster, (Configuration)conf), TEST_HAR_PATH);
            URI failoverUri = FileSystem.getDefaultUri((Configuration)conf);
            Path p = new Path("har://hdfs-" + failoverUri.getAuthority() + TEST_HAR_PATH);
            p.getFileSystem((Configuration)conf);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static void createEmptyHarArchive(FileSystem fs, Path p) throws IOException {
        fs.mkdirs(p);
        FSDataOutputStream out = fs.create(new Path(p, "_masterindex"));
        out.write(Integer.toString(3).getBytes());
        out.close();
        fs.create(new Path(p, "_index")).close();
    }
}

