/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class BlockPlacementPolicies {
    private final BlockPlacementPolicy replicationPolicy;
    private final BlockPlacementPolicy ecPolicy;

    public BlockPlacementPolicies(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        Class replicatorClass = conf.getClass("dfs.block.replicator.classname", DFSConfigKeys.DFS_BLOCK_REPLICATOR_CLASSNAME_DEFAULT, BlockPlacementPolicy.class);
        this.replicationPolicy = (BlockPlacementPolicy)ReflectionUtils.newInstance((Class)replicatorClass, (Configuration)conf);
        this.replicationPolicy.initialize(conf, stats, clusterMap, host2datanodeMap);
        Class blockPlacementECClass = conf.getClass("dfs.block.placement.ec.classname", DFSConfigKeys.DFS_BLOCK_PLACEMENT_EC_CLASSNAME_DEFAULT, BlockPlacementPolicy.class);
        this.ecPolicy = (BlockPlacementPolicy)ReflectionUtils.newInstance((Class)blockPlacementECClass, (Configuration)conf);
        this.ecPolicy.initialize(conf, stats, clusterMap, host2datanodeMap);
    }

    public BlockPlacementPolicy getPolicy(boolean isStriped) {
        if (isStriped) {
            return this.ecPolicy;
        }
        return this.replicationPolicy;
    }
}

