/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReconstructionWork;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.net.Node;

class ErasureCodingWork
extends BlockReconstructionWork {
    private final byte[] liveBlockIndicies;
    private final String blockPoolId;

    public ErasureCodingWork(String blockPoolId, BlockInfo block, BlockCollection bc, DatanodeDescriptor[] srcNodes, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> liveReplicaStorages, int additionalReplRequired, int priority, byte[] liveBlockIndicies) {
        super(block, bc, srcNodes, containingNodes, liveReplicaStorages, additionalReplRequired, priority);
        this.blockPoolId = blockPoolId;
        this.liveBlockIndicies = liveBlockIndicies;
        BlockManager.LOG.debug("Creating an ErasureCodingWork to {} reconstruct ", (Object)block);
    }

    byte[] getLiveBlockIndicies() {
        return this.liveBlockIndicies;
    }

    @Override
    void chooseTargets(BlockPlacementPolicy blockplacement, BlockStoragePolicySuite storagePolicySuite, Set<Node> excludedNodes) {
        DatanodeStorageInfo[] chosenTargets = blockplacement.chooseTarget(this.getBc().getName(), this.getAdditionalReplRequired(), (Node)this.getSrcNodes()[0], this.getLiveReplicaStorages(), false, excludedNodes, this.getBlock().getNumBytes(), storagePolicySuite.getPolicy(this.getBc().getStoragePolicyID()), null);
        this.setTargets(chosenTargets);
    }

    private boolean hasAllInternalBlocks() {
        int i;
        BlockInfoStriped block = (BlockInfoStriped)this.getBlock();
        if (this.getSrcNodes().length < block.getRealTotalBlockNum()) {
            return false;
        }
        BitSet bitSet = new BitSet(block.getTotalBlockNum());
        for (byte index : this.liveBlockIndicies) {
            bitSet.set(index);
        }
        for (i = 0; i < block.getRealDataBlockNum(); ++i) {
            if (bitSet.get(i)) continue;
            return false;
        }
        for (i = block.getDataBlockNum(); i < block.getTotalBlockNum(); ++i) {
            if (bitSet.get(i)) continue;
            return false;
        }
        return true;
    }

    private int chooseSource4SimpleReplication() {
        HashMap<String, ArrayList<Integer>> map = new HashMap<String, ArrayList<Integer>>();
        for (int i = 0; i < this.getSrcNodes().length; ++i) {
            String rack = this.getSrcNodes()[i].getNetworkLocation();
            ArrayList<Integer> dnList = (ArrayList<Integer>)map.get(rack);
            if (dnList == null) {
                dnList = new ArrayList<Integer>();
                map.put(rack, dnList);
            }
            dnList.add(i);
        }
        List max = null;
        for (Map.Entry entry : map.entrySet()) {
            if (max != null && ((List)entry.getValue()).size() <= max.size()) continue;
            max = (List)entry.getValue();
        }
        assert (max != null);
        return (Integer)max.get(0);
    }

    @Override
    void addTaskToDatanode(NumberReplicas numberReplicas) {
        DatanodeStorageInfo[] targets = this.getTargets();
        assert (targets.length > 0);
        BlockInfoStriped stripedBlk = (BlockInfoStriped)this.getBlock();
        if (this.hasNotEnoughRack()) {
            int sourceIndex = this.chooseSource4SimpleReplication();
            this.createReplicationWork(sourceIndex, targets[0]);
        } else if (numberReplicas.decommissioning() > 0 && this.hasAllInternalBlocks()) {
            List<Integer> decommissioningSources = this.findDecommissioningSources();
            int num = Math.min(decommissioningSources.size(), targets.length);
            for (int i = 0; i < num; ++i) {
                this.createReplicationWork(decommissioningSources.get(i), targets[i]);
            }
        } else {
            targets[0].getDatanodeDescriptor().addBlockToBeErasureCoded(new ExtendedBlock(this.blockPoolId, (Block)stripedBlk), this.getSrcNodes(), targets, this.getLiveBlockIndicies(), stripedBlk.getErasureCodingPolicy());
        }
    }

    private void createReplicationWork(int sourceIndex, DatanodeStorageInfo target) {
        BlockInfoStriped stripedBlk = (BlockInfoStriped)this.getBlock();
        byte blockIndex = this.liveBlockIndicies[sourceIndex];
        DatanodeDescriptor source = this.getSrcNodes()[sourceIndex];
        long internBlkLen = StripedBlockUtil.getInternalBlockLength((long)stripedBlk.getNumBytes(), (int)stripedBlk.getCellSize(), (int)stripedBlk.getDataBlockNum(), (int)blockIndex);
        Block targetBlk = new Block(stripedBlk.getBlockId() + (long)blockIndex, internBlkLen, stripedBlk.getGenerationStamp());
        source.addBlockToBeReplicated(targetBlk, new DatanodeStorageInfo[]{target});
        if (BlockManager.LOG.isDebugEnabled()) {
            BlockManager.LOG.debug("Add replication task from source {} to target {} for EC block {}", new Object[]{source, target, targetBlk});
        }
    }

    private List<Integer> findDecommissioningSources() {
        ArrayList<Integer> srcIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.getSrcNodes().length; ++i) {
            if (!this.getSrcNodes()[i].isDecommissionInProgress()) continue;
            srcIndices.add(i);
        }
        return srcIndices;
    }
}

