/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.util.EnumCounters;

public class NumberReplicas
extends EnumCounters<StoredReplicaState> {
    public NumberReplicas() {
        super(StoredReplicaState.class);
    }

    public int liveReplicas() {
        return (int)this.get(StoredReplicaState.LIVE);
    }

    public int readOnlyReplicas() {
        return (int)this.get(StoredReplicaState.READONLY);
    }

    public int decommissionedAndDecommissioning() {
        return (int)(this.get(StoredReplicaState.DECOMMISSIONED) + this.get(StoredReplicaState.DECOMMISSIONING));
    }

    public int decommissioned() {
        return (int)this.get(StoredReplicaState.DECOMMISSIONED);
    }

    public int decommissioning() {
        return (int)this.get(StoredReplicaState.DECOMMISSIONING);
    }

    public int corruptReplicas() {
        return (int)this.get(StoredReplicaState.CORRUPT);
    }

    public int excessReplicas() {
        return (int)this.get(StoredReplicaState.EXCESS);
    }

    public int replicasOnStaleNodes() {
        return (int)this.get(StoredReplicaState.STALESTORAGE);
    }

    public int redundantInternalBlocks() {
        return (int)this.get(StoredReplicaState.REDUNDANT);
    }

    public static enum StoredReplicaState {
        LIVE,
        READONLY,
        DECOMMISSIONING,
        DECOMMISSIONED,
        CORRUPT,
        EXCESS,
        STALESTORAGE,
        REDUNDANT;

    }
}

