/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ExceptionHandler;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.hadoop.io.IOUtils;

class HdfsWriter
extends SimpleChannelInboundHandler<HttpContent> {
    private final DFSClient client;
    private final OutputStream out;
    private final DefaultHttpResponse response;
    private static final Log LOG = WebHdfsHandler.LOG;

    HdfsWriter(DFSClient client, OutputStream out, DefaultHttpResponse response) {
        this.client = client;
        this.out = out;
        this.response = response;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpContent chunk) throws IOException {
        chunk.content().readBytes(this.out, chunk.content().readableBytes());
        if (chunk instanceof LastHttpContent) {
            this.response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            ctx.write((Object)this.response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.releaseDfsResources();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.releaseDfsResources();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.releaseDfsResources();
        DefaultFullHttpResponse resp = ExceptionHandler.exceptionCaught(cause);
        resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush((Object)this.response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void releaseDfsResources() {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.out});
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.client});
    }
}

