/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.security.AccessControlException;

public class FSDirAttrOp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setPermission(FSDirectory fsd, String srcArg, FsPermission permission) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        if (FSDirectory.isExactReservedName(src)) {
            throw new InvalidPathException(src);
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.writeLock();
        try {
            iip = fsd.resolvePathForWrite(pc, src);
            src = iip.getPath();
            fsd.checkOwner(pc, iip);
            FSDirAttrOp.unprotectedSetPermission(fsd, src, permission);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logSetPermissions(src, permission);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setOwner(FSDirectory fsd, String src, String username, String group) throws IOException {
        INodesInPath iip;
        if (FSDirectory.isExactReservedName(src)) {
            throw new InvalidPathException(src);
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.writeLock();
        try {
            iip = fsd.resolvePathForWrite(pc, src);
            src = iip.getPath();
            fsd.checkOwner(pc, iip);
            if (!pc.isSuperUser()) {
                if (username != null && !pc.getUser().equals(username)) {
                    throw new AccessControlException("Non-super user cannot change owner");
                }
                if (group != null && !pc.isMemberOfGroup(group)) {
                    throw new AccessControlException("User does not belong to " + group);
                }
            }
            FSDirAttrOp.unprotectedSetOwner(fsd, src, username, group);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logSetOwner(src, username, group);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setTimes(FSDirectory fsd, String src, long mtime, long atime) throws IOException {
        INodesInPath iip;
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.writeLock();
        try {
            INode inode;
            iip = fsd.resolvePathForWrite(pc, src);
            src = iip.getPath();
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            if ((inode = iip.getLastINode()) == null) {
                throw new FileNotFoundException("File/Directory " + src + " does not exist.");
            }
            boolean changed = FSDirAttrOp.unprotectedSetTimes(fsd, inode, mtime, atime, true, iip.getLatestSnapshotId());
            if (changed) {
                fsd.getEditLog().logTimes(src, mtime, atime);
            }
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setReplication(FSDirectory fsd, BlockManager bm, String src, short replication) throws IOException {
        boolean isFile;
        bm.verifyReplication(src, replication, null);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.writeLock();
        try {
            BlockInfo[] blocks;
            INodesInPath iip = fsd.resolvePathForWrite(pc, src);
            src = iip.getPath();
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            boolean bl = isFile = (blocks = FSDirAttrOp.unprotectedSetReplication(fsd, src, replication)) != null;
            if (isFile) {
                fsd.getEditLog().logSetReplication(src, replication);
            }
        }
        finally {
            fsd.writeUnlock();
        }
        return isFile;
    }

    static HdfsFileStatus unsetStoragePolicy(FSDirectory fsd, BlockManager bm, String src) throws IOException {
        return FSDirAttrOp.setStoragePolicy(fsd, bm, src, (byte)0, "unset");
    }

    static HdfsFileStatus setStoragePolicy(FSDirectory fsd, BlockManager bm, String src, String policyName) throws IOException {
        BlockStoragePolicy policy = bm.getStoragePolicy(policyName);
        if (policy == null) {
            throw new HadoopIllegalArgumentException("Cannot find a block policy with the name " + policyName);
        }
        return FSDirAttrOp.setStoragePolicy(fsd, bm, src, policy.getId(), "set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setStoragePolicy(FSDirectory fsd, BlockManager bm, String src, byte policyId, String operation) throws IOException {
        INodesInPath iip;
        if (!fsd.isStoragePolicyEnabled()) {
            throw new IOException(String.format("Failed to %s storage policy since %s is set to false.", operation, "dfs.storage.policy.enabled"));
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.writeLock();
        try {
            src = FSDirectory.resolvePath(src, fsd);
            iip = fsd.getINodesInPath4Write(src);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            FSDirAttrOp.unprotectedSetStoragePolicy(fsd, bm, iip, policyId);
            fsd.getEditLog().logSetStoragePolicy(src, policyId);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    static BlockStoragePolicy[] getStoragePolicies(BlockManager bm) throws IOException {
        return bm.getStoragePolicies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BlockStoragePolicy getStoragePolicy(FSDirectory fsd, BlockManager bm, String path) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.readLock();
        try {
            INode inode;
            INodesInPath iip = fsd.resolvePath(pc, path, false);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ);
            }
            if ((inode = iip.getLastINode()) == null) {
                throw new FileNotFoundException("File/Directory does not exist: " + iip.getPath());
            }
            BlockStoragePolicy blockStoragePolicy = bm.getStoragePolicy(inode.getStoragePolicyID());
            return blockStoragePolicy;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getPreferredBlockSize(FSDirectory fsd, String src) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.readLock();
        try {
            INodesInPath iip = fsd.resolvePath(pc, src, false);
            src = iip.getPath();
            if (fsd.isPermissionEnabled()) {
                fsd.checkTraverse(pc, iip);
            }
            long l = INodeFile.valueOf(iip.getLastINode(), src).getPreferredBlockSize();
            return l;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setQuota(FSDirectory fsd, String src, long nsQuota, long ssQuota, StorageType type) throws IOException {
        if (fsd.isPermissionEnabled()) {
            FSPermissionChecker pc = fsd.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
        fsd.writeLock();
        try {
            INodeDirectory changed = FSDirAttrOp.unprotectedSetQuota(fsd, src, nsQuota, ssQuota, type);
            if (changed != null) {
                QuotaCounts q = changed.getQuotaCounts();
                if (type == null) {
                    fsd.getEditLog().logSetQuota(src, q.getNameSpace(), q.getStorageSpace());
                } else {
                    fsd.getEditLog().logSetQuotaByStorageType(src, q.getTypeSpaces().get(type), type);
                }
            }
        }
        finally {
            fsd.writeUnlock();
        }
    }

    static void unprotectedSetPermission(FSDirectory fsd, String src, FsPermission permissions) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        assert (fsd.hasWriteLock());
        INodesInPath inodesInPath = fsd.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        int snapshotId = inodesInPath.getLatestSnapshotId();
        inode.setPermission(permissions, snapshotId);
    }

    static void unprotectedSetOwner(FSDirectory fsd, String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        assert (fsd.hasWriteLock());
        INodesInPath inodesInPath = fsd.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        if (username != null) {
            inode = inode.setUser(username, inodesInPath.getLatestSnapshotId());
        }
        if (groupname != null) {
            inode.setGroup(groupname, inodesInPath.getLatestSnapshotId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setTimes(FSDirectory fsd, INode inode, long mtime, long atime, boolean force, int latestSnapshotId) throws QuotaExceededException {
        fsd.writeLock();
        try {
            boolean bl = FSDirAttrOp.unprotectedSetTimes(fsd, inode, mtime, atime, force, latestSnapshotId);
            return bl;
        }
        finally {
            fsd.writeUnlock();
        }
    }

    static boolean unprotectedSetTimes(FSDirectory fsd, String src, long mtime, long atime, boolean force) throws UnresolvedLinkException, QuotaExceededException {
        assert (fsd.hasWriteLock());
        INodesInPath i = fsd.getINodesInPath(src, true);
        return FSDirAttrOp.unprotectedSetTimes(fsd, i.getLastINode(), mtime, atime, force, i.getLatestSnapshotId());
    }

    static INodeDirectory unprotectedSetQuota(FSDirectory fsd, String src, long nsQuota, long ssQuota, StorageType type) throws FileNotFoundException, PathIsNotDirectoryException, QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException, UnsupportedActionException {
        EnumCounters<StorageType> oldTypeQuotas;
        assert (fsd.hasWriteLock());
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota != -1L || ssQuota < 0L && ssQuota != Long.MAX_VALUE && ssQuota != -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or ssQuota : " + nsQuota + " and " + ssQuota);
        }
        if (!(type == null || fsd.isQuotaByStorageTypeEnabled() && nsQuota == Long.MAX_VALUE)) {
            throw new UnsupportedActionException("Failed to set quota by storage type because eitherdfs.quota.by.storage.type.enabled is set to " + fsd.isQuotaByStorageTypeEnabled() + " or nsQuota value is illegal " + nsQuota);
        }
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath iip = fsd.getINodesInPath4Write(srcs, true);
        INodeDirectory dirNode = INodeDirectory.valueOf(iip.getLastINode(), srcs);
        if (dirNode.isRoot() && nsQuota == -1L) {
            throw new IllegalArgumentException("Cannot clear namespace quota on root.");
        }
        QuotaCounts oldQuota = dirNode.getQuotaCounts();
        long oldNsQuota = oldQuota.getNameSpace();
        long oldSsQuota = oldQuota.getStorageSpace();
        if (nsQuota == Long.MAX_VALUE) {
            nsQuota = oldNsQuota;
        }
        if (ssQuota == Long.MAX_VALUE) {
            ssQuota = oldSsQuota;
        }
        if (type == null && oldNsQuota == nsQuota && oldSsQuota == ssQuota) {
            return null;
        }
        if (type != null && (oldTypeQuotas = oldQuota.getTypeSpaces()) != null && oldTypeQuotas.get(type) == ssQuota) {
            return null;
        }
        int latest = iip.getLatestSnapshotId();
        dirNode.recordModification(latest);
        dirNode.setQuota(fsd.getBlockStoragePolicySuite(), nsQuota, ssQuota, type);
        return dirNode;
    }

    static BlockInfo[] unprotectedSetReplication(FSDirectory fsd, String src, short replication) throws QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException, UnsupportedActionException {
        assert (fsd.hasWriteLock());
        BlockManager bm = fsd.getBlockManager();
        INodesInPath iip = fsd.getINodesInPath4Write(src, true);
        INode inode = iip.getLastINode();
        if (inode == null || !inode.isFile() || inode.asFile().isStriped()) {
            return null;
        }
        INodeFile file = inode.asFile();
        short oldBR = file.getPreferredBlockReplication();
        if (oldBR < replication) {
            long size = file.computeFileSize(true, true);
            fsd.updateCount(iip, 0L, size, oldBR, replication, true);
        }
        file.setFileReplication(replication, iip.getLatestSnapshotId());
        short targetReplication = (short)Math.max(replication, file.getPreferredBlockReplication());
        for (BlockInfo b : file.getBlocks()) {
            if (oldBR == targetReplication) continue;
            if (oldBR > replication) {
                fsd.updateCount(iip, 0L, b.getNumBytes(), oldBR, targetReplication, true);
            }
            bm.setReplication(oldBR, targetReplication, b);
        }
        if (oldBR != -1) {
            if (oldBR > targetReplication) {
                FSDirectory.LOG.info("Decreasing replication from {} to {} for {}", new Object[]{oldBR, targetReplication, src});
            } else {
                FSDirectory.LOG.info("Increasing replication from {} to {} for {}", new Object[]{oldBR, targetReplication, src});
            }
        }
        return file.getBlocks();
    }

    static void unprotectedSetStoragePolicy(FSDirectory fsd, BlockManager bm, INodesInPath iip, byte policyId) throws IOException {
        assert (fsd.hasWriteLock());
        INode inode = iip.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File/Directory does not exist: " + iip.getPath());
        }
        int snapshotId = iip.getLatestSnapshotId();
        if (inode.isFile()) {
            BlockStoragePolicy newPolicy;
            if (policyId != 0 && (newPolicy = bm.getStoragePolicy(policyId)).isCopyOnCreateFile()) {
                throw new HadoopIllegalArgumentException("Policy " + newPolicy + " cannot be set after file creation.");
            }
            BlockStoragePolicy currentPolicy = bm.getStoragePolicy(inode.getLocalStoragePolicyID());
            if (currentPolicy != null && currentPolicy.isCopyOnCreateFile()) {
                throw new HadoopIllegalArgumentException("Existing policy " + currentPolicy.getName() + " cannot be changed after file creation.");
            }
            inode.asFile().setStoragePolicyID(policyId, snapshotId);
        } else if (inode.isDirectory()) {
            FSDirAttrOp.setDirStoragePolicy(fsd, inode.asDirectory(), policyId, snapshotId);
        } else {
            throw new FileNotFoundException(iip.getPath() + " is not a file or directory");
        }
    }

    private static void setDirStoragePolicy(FSDirectory fsd, INodeDirectory inode, byte policyId, int latestSnapshotId) throws IOException {
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        XAttr xAttr = BlockStoragePolicySuite.buildXAttr(policyId);
        List<XAttr> newXAttrs = null;
        if (policyId == 0) {
            ArrayList toRemove = Lists.newArrayList();
            toRemove.add(xAttr);
            ArrayList removed = Lists.newArrayList();
            newXAttrs = FSDirXAttrOp.filterINodeXAttrs(existingXAttrs, toRemove, removed);
        } else {
            newXAttrs = FSDirXAttrOp.setINodeXAttrs(fsd, existingXAttrs, Arrays.asList(xAttr), EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        }
        XAttrStorage.updateINodeXAttrs(inode, newXAttrs, latestSnapshotId);
    }

    private static boolean unprotectedSetTimes(FSDirectory fsd, INode inode, long mtime, long atime, boolean force, int latest) throws QuotaExceededException {
        assert (fsd.hasWriteLock());
        boolean status = false;
        if (mtime != -1L) {
            inode = inode.setModificationTime(mtime, latest);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime();
            if (atime <= inodeTime + fsd.getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime, latest);
                status = true;
            }
        }
        return status;
    }
}

