/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;

final class FSDirErasureCodingOp {
    private FSDirErasureCodingOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setErasureCodingPolicy(FSNamesystem fsn, String srcArg, ErasureCodingPolicy ecPolicy, boolean logRetryCache) throws IOException {
        List<XAttr> xAttrs;
        INodesInPath iip;
        assert (fsn.hasWriteLock());
        String src = srcArg;
        FSPermissionChecker pc = null;
        pc = fsn.getPermissionChecker();
        FSDirectory fsd = fsn.getFSDirectory();
        fsd.writeLock();
        try {
            iip = fsd.resolvePathForWrite(pc, src, false);
            src = iip.getPath();
            xAttrs = FSDirErasureCodingOp.createErasureCodingPolicyXAttr(fsn, iip, ecPolicy);
        }
        finally {
            fsd.writeUnlock();
        }
        fsn.getEditLog().logSetXAttrs(src, xAttrs, logRetryCache);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<XAttr> createErasureCodingPolicyXAttr(FSNamesystem fsn, INodesInPath srcIIP, ErasureCodingPolicy ecPolicy) throws IOException {
        XAttr ecXAttr;
        FSDirectory fsd = fsn.getFSDirectory();
        assert (fsd.hasWriteLock());
        Preconditions.checkNotNull((Object)srcIIP, (Object)"INodes cannot be null");
        String src = srcIIP.getPath();
        if (srcIIP.getLastINode() != null && !srcIIP.getLastINode().isDirectory()) {
            throw new IOException("Attempt to set an erasure coding policy for a file " + src);
        }
        if (FSDirErasureCodingOp.getErasureCodingPolicyForPath(fsn, srcIIP) != null) {
            throw new IOException("Directory " + src + " already has an erasure coding policy.");
        }
        if (ecPolicy == null) {
            ecPolicy = ErasureCodingPolicyManager.getSystemDefaultPolicy();
        } else {
            ErasureCodingPolicy[] activePolicies;
            boolean validPolicy = false;
            for (ErasureCodingPolicy activePolicy : activePolicies = FSDirErasureCodingOp.getErasureCodingPolicies(fsd.getFSNamesystem())) {
                if (!activePolicy.equals((Object)ecPolicy)) continue;
                validPolicy = true;
                break;
            }
            if (!validPolicy) {
                ArrayList<String> ecPolicyNames = new ArrayList<String>();
                for (ErasureCodingPolicy activePolicy : activePolicies) {
                    ecPolicyNames.add(activePolicy.getName());
                }
                throw new HadoopIllegalArgumentException("Policy [ " + ecPolicy.getName() + " ] does not match any of the supported policies. Please select any one of " + ecPolicyNames);
            }
        }
        DataOutputStream dOut = null;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            dOut = new DataOutputStream(bOut);
            WritableUtils.writeString((DataOutput)dOut, (String)ecPolicy.getName());
            ecXAttr = XAttrHelper.buildXAttr((String)"raw.hdfs.erasurecoding.policy", (byte[])bOut.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dOut);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dOut);
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(ecXAttr);
        FSDirXAttrOp.unprotectedSetXAttrs(fsd, src, xattrs, EnumSet.of(XAttrSetFlag.CREATE));
        return xattrs;
    }

    static ErasureCodingPolicy getErasureCodingPolicy(FSNamesystem fsn, String src) throws IOException {
        assert (fsn.hasReadLock());
        INodesInPath iip = FSDirErasureCodingOp.getINodesInPath(fsn, src);
        if (iip.getLastINode() == null) {
            throw new FileNotFoundException("Path not found: " + iip.getPath());
        }
        return FSDirErasureCodingOp.getErasureCodingPolicyForPath(fsn, iip);
    }

    static boolean hasErasureCodingPolicy(FSNamesystem fsn, String srcArg) throws IOException {
        return FSDirErasureCodingOp.hasErasureCodingPolicy(fsn, FSDirErasureCodingOp.getINodesInPath(fsn, srcArg));
    }

    static boolean hasErasureCodingPolicy(FSNamesystem fsn, INodesInPath iip) throws IOException {
        return FSDirErasureCodingOp.getErasureCodingPolicy(fsn, iip) != null;
    }

    static ErasureCodingPolicy getErasureCodingPolicy(FSNamesystem fsn, INodesInPath iip) throws IOException {
        assert (fsn.hasReadLock());
        return FSDirErasureCodingOp.getErasureCodingPolicyForPath(fsn, iip);
    }

    static ErasureCodingPolicy[] getErasureCodingPolicies(FSNamesystem fsn) throws IOException {
        assert (fsn.hasReadLock());
        return fsn.getErasureCodingPolicyManager().getPolicies();
    }

    private static INodesInPath getINodesInPath(FSNamesystem fsn, String srcArg) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        FSPermissionChecker pc = fsn.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, srcArg);
        if (fsn.isPermissionEnabled()) {
            fsn.getFSDirectory().checkPathAccess(pc, iip, FsAction.READ);
        }
        return iip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ErasureCodingPolicy getErasureCodingPolicyForPath(FSNamesystem fsn, INodesInPath iip) throws IOException {
        Preconditions.checkNotNull((Object)iip, (Object)"INodes cannot be null");
        FSDirectory fsd = fsn.getFSDirectory();
        fsd.readLock();
        try {
            List<INode> inodes = iip.getReadOnlyINodes();
            for (int i = inodes.size() - 1; i >= 0; --i) {
                XAttr xattr;
                INode inode = inodes.get(i);
                if (inode == null) continue;
                if (inode.isFile()) {
                    byte id = inode.asFile().getErasureCodingPolicyID();
                    ErasureCodingPolicy erasureCodingPolicy = id < 0 ? null : fsd.getFSNamesystem().getErasureCodingPolicyManager().getPolicyByID(id);
                    return erasureCodingPolicy;
                }
                if (inode.isSymlink()) {
                    ErasureCodingPolicy id = null;
                    return id;
                }
                XAttrFeature xaf = inode.getXAttrFeature();
                if (xaf == null || (xattr = xaf.getXAttr("raw.hdfs.erasurecoding.policy")) == null) continue;
                ByteArrayInputStream bIn = new ByteArrayInputStream(xattr.getValue());
                DataInputStream dIn = new DataInputStream(bIn);
                String ecPolicyName = WritableUtils.readString((DataInput)dIn);
                ErasureCodingPolicy erasureCodingPolicy = fsd.getFSNamesystem().getErasureCodingPolicyManager().getPolicyByName(ecPolicyName);
                return erasureCodingPolicy;
            }
        }
        finally {
            fsd.readUnlock();
        }
        return null;
    }
}

