/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirEncryptionZoneOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirErasureCodingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.util.Time;

class FSDirStatAndListingOp {
    FSDirStatAndListingOp() {
    }

    static DirectoryListing getListingInt(FSDirectory fsd, String srcArg, byte[] startAfter, boolean needLocation) throws IOException {
        String startAfterString;
        INodesInPath iip;
        String src = null;
        if (fsd.isPermissionEnabled()) {
            FSPermissionChecker pc = fsd.getPermissionChecker();
            iip = fsd.resolvePath(pc, srcArg);
            src = iip.getPath();
        } else {
            src = FSDirectory.resolvePath(srcArg, fsd);
            iip = fsd.getINodesInPath(src, true);
        }
        if (startAfter.length > 0 && startAfter[0] == 47 && FSDirectory.isReservedName(startAfterString = DFSUtil.bytes2String(startAfter))) {
            try {
                byte[][] components = INode.getPathComponents(startAfterString);
                components = FSDirectory.resolveComponents(components, fsd);
                startAfter = components[components.length - 1];
            }
            catch (IOException e) {
                throw new DirectoryListingStartAfterNotFoundException("Can't find startAfter " + startAfterString);
            }
        }
        boolean isSuperUser = true;
        if (fsd.isPermissionEnabled()) {
            FSPermissionChecker pc = fsd.getPermissionChecker();
            if (iip.getLastINode() != null && iip.getLastINode().isDirectory()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ_EXECUTE);
            } else {
                fsd.checkTraverse(pc, iip);
            }
            isSuperUser = pc.isSuperUser();
        }
        return FSDirStatAndListingOp.getListing(fsd, iip, src, startAfter, needLocation, isSuperUser);
    }

    static HdfsFileStatus getFileInfo(FSDirectory fsd, String srcArg, boolean resolveLink) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException("Invalid file name: " + src);
        }
        if (fsd.isPermissionEnabled()) {
            FSPermissionChecker pc = fsd.getPermissionChecker();
            iip = fsd.resolvePath(pc, srcArg, resolveLink);
            fsd.checkPermission(pc, iip, false, null, null, null, null, false);
        } else {
            src = FSDirectory.resolvePath(srcArg, fsd);
            iip = fsd.getINodesInPath(src, resolveLink);
        }
        return FSDirStatAndListingOp.getFileInfo(fsd, iip);
    }

    static boolean isFileClosed(FSDirectory fsd, String src) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, src);
        if (fsd.isPermissionEnabled()) {
            fsd.checkTraverse(pc, iip);
        }
        return !INodeFile.valueOf(iip.getLastINode(), src).isUnderConstruction();
    }

    static ContentSummary getContentSummary(FSDirectory fsd, String src) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, src, false);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPermission(pc, iip, false, null, null, null, FsAction.READ_EXECUTE);
        }
        return FSDirStatAndListingOp.getContentSummaryInt(fsd, iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GetBlockLocationsResult getBlockLocations(FSDirectory fsd, FSPermissionChecker pc, String src, long offset, long length, boolean needBlockToken) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)("Negative offset is not supported. File: " + src));
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)("Negative length is not supported. File: " + src));
        CacheManager cm = fsd.getFSNamesystem().getCacheManager();
        BlockManager bm = fsd.getBlockManager();
        boolean isReservedName = FSDirectory.isReservedRawName(src);
        fsd.readLock();
        try {
            INodesInPath iip = fsd.resolvePath(pc, src);
            src = iip.getPath();
            INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ);
                fsd.checkUnreadableBySuperuser(pc, inode, iip.getPathSnapshotId());
            }
            long fileSize = iip.isSnapshot() ? inode.computeFileSize(iip.getPathSnapshotId()) : inode.computeFileSizeNotIncludingLastUcBlock();
            boolean isUc = inode.isUnderConstruction();
            if (iip.isSnapshot()) {
                length = Math.min(length, fileSize - offset);
                isUc = false;
            }
            FileEncryptionInfo feInfo = isReservedName ? null : FSDirEncryptionZoneOp.getFileEncryptionInfo(fsd, inode, iip.getPathSnapshotId(), iip);
            ErasureCodingPolicy ecPolicy = FSDirErasureCodingOp.getErasureCodingPolicy(fsd.getFSNamesystem(), iip);
            LocatedBlocks blocks = bm.createLocatedBlocks(inode.getBlocks(iip.getPathSnapshotId()), fileSize, isUc, offset, length, needBlockToken, iip.isSnapshot(), feInfo, ecPolicy);
            for (LocatedBlock lb : blocks.getLocatedBlocks()) {
                cm.setCachedLocations(lb);
            }
            long now = Time.now();
            boolean updateAccessTime = fsd.isAccessTimeSupported() && !iip.isSnapshot() && now > inode.getAccessTime() + fsd.getAccessTimePrecision();
            GetBlockLocationsResult getBlockLocationsResult = new GetBlockLocationsResult(updateAccessTime, blocks);
            return getBlockLocationsResult;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static byte getStoragePolicyID(byte inodePolicy, byte parentPolicy) {
        return inodePolicy != 0 ? inodePolicy : parentPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryListing getListing(FSDirectory fsd, INodesInPath iip, String src, byte[] startAfter, boolean needLocation, boolean isSuperUser) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        if (FSDirectory.isExactReservedName(srcs)) {
            return FSDirStatAndListingOp.getReservedListing(fsd);
        }
        fsd.readLock();
        try {
            byte parentStoragePolicy;
            if (srcs.endsWith("/.snapshot")) {
                DirectoryListing directoryListing = FSDirStatAndListingOp.getSnapshotsListing(fsd, srcs, startAfter);
                return directoryListing;
            }
            int snapshot = iip.getPathSnapshotId();
            INode targetNode = iip.getLastINode();
            if (targetNode == null) {
                DirectoryListing directoryListing = null;
                return directoryListing;
            }
            byte by = parentStoragePolicy = isSuperUser ? targetNode.getStoragePolicyID() : (byte)0;
            if (!targetNode.isDirectory()) {
                INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, src, HdfsFileStatus.EMPTY_NAME, targetNode, snapshot);
                DirectoryListing directoryListing = new DirectoryListing(new HdfsFileStatus[]{FSDirStatAndListingOp.createFileStatus(fsd, HdfsFileStatus.EMPTY_NAME, nodeAttrs, needLocation, parentStoragePolicy, iip)}, 0);
                return directoryListing;
            }
            INodeDirectory dirInode = targetNode.asDirectory();
            ReadOnlyList<INode> contents = dirInode.getChildrenList(snapshot);
            int startChild = INodeDirectory.nextChild(contents, startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, fsd.getLsLimit());
            int locationBudget = fsd.getLsLimit();
            int listingCnt = 0;
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing && locationBudget > 0; ++i) {
                INode cur = contents.get(startChild + i);
                byte curPolicy = isSuperUser && !cur.isSymlink() ? cur.getLocalStoragePolicyID() : (byte)0;
                INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, src, cur.getLocalNameBytes(), cur, snapshot);
                INodesInPath iipWithChild = INodesInPath.append(iip, cur, cur.getLocalNameBytes());
                listing[i] = FSDirStatAndListingOp.createFileStatus(fsd, cur.getLocalNameBytes(), nodeAttrs, needLocation, FSDirStatAndListingOp.getStoragePolicyID(curPolicy, parentStoragePolicy), iipWithChild);
                ++listingCnt;
                if (!needLocation) continue;
                LocatedBlocks blks = ((HdfsLocatedFileStatus)listing[i]).getBlockLocations();
                locationBudget -= blks == null ? 0 : blks.locatedBlockCount() * listing[i].getReplication();
            }
            if (listingCnt < numOfListing) {
                listing = Arrays.copyOf(listing, listingCnt);
            }
            DirectoryListing directoryListing = new DirectoryListing(listing, totalNumChildren - startChild - listingCnt);
            return directoryListing;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static DirectoryListing getSnapshotsListing(FSDirectory fsd, String src, byte[] startAfter) throws IOException {
        Preconditions.checkState((boolean)fsd.hasReadLock());
        Preconditions.checkArgument((boolean)src.endsWith("/.snapshot"), (String)"%s does not end with %s", (Object[])new Object[]{src, "/.snapshot"});
        String dirPath = FSDirectory.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = fsd.getINode(dirPath);
        INodeDirectory dirNode = INodeDirectory.valueOf(node, dirPath);
        DirectorySnapshottableFeature sf = dirNode.getDirectorySnapshottableFeature();
        if (sf == null) {
            throw new SnapshotException("Directory is not a snapshottable directory: " + dirPath);
        }
        ReadOnlyList<Snapshot> snapshots = sf.getSnapshotList();
        int skipSize = ReadOnlyList.Util.binarySearch(snapshots, startAfter);
        skipSize = skipSize < 0 ? -skipSize - 1 : skipSize + 1;
        int numOfListing = Math.min(snapshots.size() - skipSize, fsd.getLsLimit());
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing; ++i) {
            Snapshot.Root sRoot = snapshots.get(i + skipSize).getRoot();
            INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, src, sRoot.getLocalNameBytes(), node, 0x7FFFFFFE);
            listing[i] = FSDirStatAndListingOp.createFileStatus(fsd, sRoot.getLocalNameBytes(), nodeAttrs, (byte)0, INodesInPath.fromINode(sRoot));
        }
        return new DirectoryListing(listing, snapshots.size() - skipSize - numOfListing);
    }

    private static DirectoryListing getReservedListing(FSDirectory fsd) {
        return new DirectoryListing(fsd.getReservedStatuses(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus getFileInfo(FSDirectory fsd, INodesInPath iip, boolean includeStoragePolicy) throws IOException {
        fsd.readLock();
        try {
            INode node = iip.getLastINode();
            if (node == null) {
                HdfsFileStatus hdfsFileStatus = null;
                return hdfsFileStatus;
            }
            byte policyId = includeStoragePolicy && !node.isSymlink() ? node.getStoragePolicyID() : (byte)0;
            INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, iip.getPath(), HdfsFileStatus.EMPTY_NAME, node, iip.getPathSnapshotId());
            HdfsFileStatus hdfsFileStatus = FSDirStatAndListingOp.createFileStatus(fsd, HdfsFileStatus.EMPTY_NAME, nodeAttrs, policyId, iip);
            return hdfsFileStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus getFileInfo(FSDirectory fsd, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            HdfsFileStatus status = null;
            if (FSDirectory.isExactReservedName(iip.getPathComponents())) {
                status = FSDirectory.DOT_RESERVED_STATUS;
            } else if (iip.isDotSnapshotDir()) {
                if (fsd.getINode4DotSnapshot(iip) != null) {
                    status = FSDirectory.DOT_SNAPSHOT_DIR_STATUS;
                }
            } else {
                status = FSDirStatAndListingOp.getFileInfo(fsd, iip, true);
            }
            HdfsFileStatus hdfsFileStatus = status;
            return hdfsFileStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    private static HdfsFileStatus createFileStatus(FSDirectory fsd, byte[] path, INodeAttributes nodeAttrs, boolean needLocation, byte storagePolicy, INodesInPath iip) throws IOException {
        if (needLocation) {
            return FSDirStatAndListingOp.createLocatedFileStatus(fsd, path, nodeAttrs, storagePolicy, iip);
        }
        return FSDirStatAndListingOp.createFileStatus(fsd, path, nodeAttrs, storagePolicy, iip);
    }

    static HdfsFileStatus createFileStatusForEditLog(FSDirectory fsd, String fullPath, byte[] path, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        INodeAttributes nodeAttrs = FSDirStatAndListingOp.getINodeAttributes(fsd, fullPath, path, iip.getLastINode(), snapshot);
        return FSDirStatAndListingOp.createFileStatus(fsd, path, nodeAttrs, storagePolicy, iip);
    }

    static HdfsFileStatus createFileStatus(FSDirectory fsd, byte[] path, INodeAttributes nodeAttrs, byte storagePolicy, INodesInPath iip) throws IOException {
        boolean isEncrypted;
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        INode node = iip.getLastINode();
        int snapshot = iip.getPathSnapshotId();
        boolean isRawPath = iip.isRaw();
        FileEncryptionInfo feInfo = isRawPath ? null : FSDirEncryptionZoneOp.getFileEncryptionInfo(fsd, node, snapshot, iip);
        ErasureCodingPolicy ecPolicy = FSDirErasureCodingOp.getErasureCodingPolicy(fsd.getFSNamesystem(), iip);
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            isEncrypted = feInfo != null || isRawPath && FSDirEncryptionZoneOp.isInAnEZ(fsd, iip);
        } else {
            isEncrypted = FSDirEncryptionZoneOp.isInAnEZ(fsd, iip);
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        return new HdfsFileStatus(size, node.isDirectory(), (int)replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirStatAndListingOp.getPermissionForFileStatus(nodeAttrs, isEncrypted), nodeAttrs.getUserName(), nodeAttrs.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), childrenNum, feInfo, storagePolicy, ecPolicy);
    }

    private static INodeAttributes getINodeAttributes(FSDirectory fsd, String fullPath, byte[] path, INode node, int snapshot) {
        return fsd.getAttributes(fullPath, path, node, snapshot);
    }

    private static HdfsFileStatus createLocatedFileStatus(FSDirectory fsd, byte[] path, INodeAttributes nodeAttrs, byte storagePolicy, INodesInPath iip) throws IOException {
        boolean isEncrypted;
        assert (fsd.hasReadLock());
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        LocatedBlocks loc = null;
        INode node = iip.getLastINode();
        int snapshot = iip.getPathSnapshotId();
        boolean isRawPath = iip.isRaw();
        FileEncryptionInfo feInfo = isRawPath ? null : FSDirEncryptionZoneOp.getFileEncryptionInfo(fsd, node, snapshot, iip);
        ErasureCodingPolicy ecPolicy = FSDirErasureCodingOp.getErasureCodingPolicy(fsd.getFSNamesystem(), iip);
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            boolean inSnapshot = snapshot != 0x7FFFFFFE;
            boolean isUc = !inSnapshot && fileNode.isUnderConstruction();
            long fileSize = !inSnapshot && isUc ? fileNode.computeFileSizeNotIncludingLastUcBlock() : size;
            loc = fsd.getBlockManager().createLocatedBlocks(fileNode.getBlocks(snapshot), fileSize, isUc, 0L, size, false, inSnapshot, feInfo, ecPolicy);
            if (loc == null) {
                loc = new LocatedBlocks();
            }
            isEncrypted = feInfo != null || isRawPath && FSDirEncryptionZoneOp.isInAnEZ(fsd, iip);
        } else {
            isEncrypted = FSDirEncryptionZoneOp.isInAnEZ(fsd, iip);
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        HdfsLocatedFileStatus status = new HdfsLocatedFileStatus(size, node.isDirectory(), (int)replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirStatAndListingOp.getPermissionForFileStatus(nodeAttrs, isEncrypted), nodeAttrs.getUserName(), nodeAttrs.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), loc, childrenNum, feInfo, storagePolicy, ecPolicy);
        if (loc != null) {
            CacheManager cacheManager = fsd.getFSNamesystem().getCacheManager();
            for (LocatedBlock lb : loc.getLocatedBlocks()) {
                cacheManager.setCachedLocations(lb);
            }
        }
        return status;
    }

    private static FsPermission getPermissionForFileStatus(INodeAttributes node, boolean isEncrypted) {
        boolean hasAcl;
        FsPermission perm = node.getFsPermission();
        boolean bl = hasAcl = node.getAclFeature() != null;
        if (hasAcl || isEncrypted) {
            perm = new FsPermissionExtension(perm, hasAcl, isEncrypted);
        }
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContentSummary getContentSummaryInt(FSDirectory fsd, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            INode targetNode = iip.getLastINode();
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + iip.getPath());
            }
            ContentSummaryComputationContext cscc = new ContentSummaryComputationContext(fsd, fsd.getFSNamesystem(), fsd.getContentCountLimit(), fsd.getContentSleepMicroSec());
            ContentSummary cs = targetNode.computeAndConvertContentSummary(iip.getPathSnapshotId(), cscc);
            fsd.addYieldCount(cscc.getYieldCount());
            ContentSummary contentSummary = cs;
            return contentSummary;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static QuotaUsage getQuotaUsage(FSDirectory fsd, String src) throws IOException {
        INodesInPath iip;
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.readLock();
        try {
            iip = fsd.resolvePath(pc, src, false);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPermission(pc, iip, false, null, null, null, FsAction.READ_EXECUTE);
            }
        }
        finally {
            fsd.readUnlock();
        }
        QuotaUsage usage = FSDirStatAndListingOp.getQuotaUsageInt(fsd, iip);
        if (usage != null) {
            return usage;
        }
        return FSDirStatAndListingOp.getContentSummaryInt(fsd, iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QuotaUsage getQuotaUsageInt(FSDirectory fsd, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            DirectoryWithQuotaFeature feature;
            INode targetNode = iip.getLastINode();
            QuotaUsage usage = null;
            if (targetNode.isDirectory() && (feature = targetNode.asDirectory().getDirectoryWithQuotaFeature()) != null) {
                QuotaCounts counts = feature.getSpaceConsumed();
                QuotaCounts quotas = feature.getQuota();
                usage = new QuotaUsage.Builder().fileAndDirectoryCount(counts.getNameSpace()).quota(quotas.getNameSpace()).spaceConsumed(counts.getStorageSpace()).spaceQuota(quotas.getStorageSpace()).typeConsumed(counts.getTypeSpaces().asArray()).typeQuota(quotas.getTypeSpaces().asArray()).build();
            }
            QuotaUsage quotaUsage = usage;
            return quotaUsage;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static class GetBlockLocationsResult {
        final boolean updateAccessTime;
        final LocatedBlocks blocks;

        boolean updateAccessTime() {
            return this.updateAccessTime;
        }

        private GetBlockLocationsResult(boolean updateAccessTime, LocatedBlocks blocks) {
            this.updateAccessTime = updateAccessTime;
            this.blocks = blocks;
        }
    }
}

