/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeId;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.ByteArray;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FSDirectory
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(FSDirectory.class);
    @VisibleForTesting
    static boolean CHECK_RESERVED_FILE_NAMES = true;
    public static final String DOT_RESERVED_STRING = ".reserved";
    public static final String DOT_RESERVED_PATH_PREFIX = "/.reserved";
    public static final byte[] DOT_RESERVED = DFSUtil.string2Bytes(".reserved");
    private static final String RAW_STRING = "raw";
    private static final byte[] RAW = DFSUtil.string2Bytes("raw");
    public static final String DOT_INODES_STRING = ".inodes";
    public static final byte[] DOT_INODES = DFSUtil.string2Bytes(".inodes");
    private static final byte[] DOT_DOT = DFSUtil.string2Bytes("..");
    public static final HdfsFileStatus DOT_RESERVED_STATUS = new HdfsFileStatus(0L, true, 0, 0L, 0L, 0L, new FsPermission(1016), null, null, null, HdfsFileStatus.EMPTY_NAME, -1L, 0, null, 0, null);
    public static final HdfsFileStatus DOT_SNAPSHOT_DIR_STATUS = new HdfsFileStatus(0L, true, 0, 0L, 0L, 0L, null, null, null, null, HdfsFileStatus.EMPTY_NAME, -1L, 0, null, 0, null);
    INodeDirectory rootDir;
    private final FSNamesystem namesystem;
    private volatile boolean skipQuotaCheck = false;
    private final int maxComponentLength;
    private final int maxDirItems;
    private final int lsLimit;
    private final int contentCountLimit;
    private final long contentSleepMicroSec;
    private final INodeMap inodeMap;
    private long yieldCount = 0L;
    private int quotaInitThreads;
    private final int inodeXAttrsLimit;
    private volatile SortedSet<String> protectedDirectories;
    private final ReentrantReadWriteLock dirLock = new ReentrantReadWriteLock(true);
    private final boolean isPermissionEnabled;
    private final boolean aclsEnabled;
    private final boolean xattrsEnabled;
    private final int xattrMaxSize;
    private final long accessTimePrecision;
    private final boolean storagePolicyEnabled;
    private final boolean quotaByStorageTypeEnabled;
    private final String fsOwnerShortUserName;
    private final String supergroup;
    private final INodeId inodeId = new INodeId();
    private final FSEditLog editLog;
    private HdfsFileStatus[] reservedStatuses;
    private INodeAttributeProvider attributeProvider;
    @VisibleForTesting
    public final EncryptionZoneManager ezManager;
    private final NameCache<ByteArray> nameCache;

    private static INodeDirectory createRoot(FSNamesystem namesystem) {
        INodeDirectory r = new INodeDirectory(16385L, INodeDirectory.ROOT_NAME, namesystem.createFsOwnerPermissions(new FsPermission(493)), 0L);
        r.addDirectoryWithQuotaFeature(new DirectoryWithQuotaFeature.Builder().nameSpaceQuota(Long.MAX_VALUE).storageSpaceQuota(-1L).build());
        r.addSnapshottableFeature();
        r.setSnapshotQuota(0);
        return r;
    }

    public void setINodeAttributeProvider(INodeAttributeProvider provider) {
        this.attributeProvider = provider;
    }

    void readLock() {
        this.dirLock.readLock().lock();
    }

    void readUnlock() {
        this.dirLock.readLock().unlock();
    }

    void writeLock() {
        this.dirLock.writeLock().lock();
    }

    void writeUnlock() {
        this.dirLock.writeLock().unlock();
    }

    boolean hasWriteLock() {
        return this.dirLock.isWriteLockedByCurrentThread();
    }

    boolean hasReadLock() {
        return this.dirLock.getReadHoldCount() > 0 || this.hasWriteLock();
    }

    public int getReadHoldCount() {
        return this.dirLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.dirLock.getWriteHoldCount();
    }

    FSDirectory(FSNamesystem ns, Configuration conf) throws IOException {
        this.rootDir = FSDirectory.createRoot(ns);
        this.inodeMap = INodeMap.newInstance(this.rootDir);
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
        this.fsOwnerShortUserName = UserGroupInformation.getCurrentUser().getShortUserName();
        this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        this.aclsEnabled = conf.getBoolean("dfs.namenode.acls.enabled", false);
        LOG.info("ACLs enabled? " + this.aclsEnabled);
        this.xattrsEnabled = conf.getBoolean("dfs.namenode.xattrs.enabled", true);
        LOG.info("XAttrs enabled? " + this.xattrsEnabled);
        this.xattrMaxSize = conf.getInt("dfs.namenode.fs-limits.max-xattr-size", 16384);
        Preconditions.checkArgument((this.xattrMaxSize > 0 ? 1 : 0) != 0, (String)"The maximum size of an xattr should be > 0: (%s).", (Object[])new Object[]{"dfs.namenode.fs-limits.max-xattr-size"});
        Preconditions.checkArgument((this.xattrMaxSize <= 32768 ? 1 : 0) != 0, (String)"The maximum size of an xattr should be <= maximum size hard limit 32768: (%s).", (Object[])new Object[]{"dfs.namenode.fs-limits.max-xattr-size"});
        this.accessTimePrecision = conf.getLong("dfs.namenode.accesstime.precision", 3600000L);
        this.storagePolicyEnabled = conf.getBoolean("dfs.storage.policy.enabled", true);
        this.quotaByStorageTypeEnabled = conf.getBoolean("dfs.quota.by.storage.type.enabled", true);
        int configuredLimit = conf.getInt("dfs.ls.limit", 1000);
        this.lsLimit = configuredLimit > 0 ? configuredLimit : 1000;
        this.contentCountLimit = conf.getInt("dfs.content-summary.limit", 5000);
        this.contentSleepMicroSec = conf.getLong("dfs.content-summary.sleep-microsec", 500L);
        this.maxComponentLength = conf.getInt("dfs.namenode.fs-limits.max-component-length", 255);
        this.maxDirItems = conf.getInt("dfs.namenode.fs-limits.max-directory-items", 0x100000);
        this.inodeXAttrsLimit = conf.getInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 32);
        this.protectedDirectories = FSDirectory.parseProtectedDirectories(conf);
        Preconditions.checkArgument((this.inodeXAttrsLimit >= 0 ? 1 : 0) != 0, (String)"Cannot set a negative limit on the number of xattrs per inode (%s).", (Object[])new Object[]{"dfs.namenode.fs-limits.max-xattrs-per-inode"});
        int MAX_DIR_ITEMS = 6400000;
        Preconditions.checkArgument((this.maxDirItems > 0 && this.maxDirItems <= 6400000 ? 1 : 0) != 0, (Object)"Cannot set dfs.namenode.fs-limits.max-directory-items to a value less than 1 or greater than 6400000");
        int threshold = conf.getInt("dfs.namenode.name.cache.threshold", 10);
        NameNode.LOG.info("Caching file names occuring more than " + threshold + " times");
        this.nameCache = new NameCache(threshold);
        this.namesystem = ns;
        this.editLog = ns.getEditLog();
        this.ezManager = new EncryptionZoneManager(this, conf);
        this.quotaInitThreads = conf.getInt("dfs.namenode.quota.init-threads", 4);
    }

    HdfsFileStatus[] getReservedStatuses() {
        Preconditions.checkNotNull((Object)this.reservedStatuses, (Object)"reservedStatuses should  not be null. It is populated when FSNamesystem loads FS image. It has to be set at this time instead of initialization time because CTime is loaded during FSNamesystem#loadFromDisk.");
        return this.reservedStatuses;
    }

    void createReservedStatuses(long cTime) {
        HdfsFileStatus inodes = new HdfsFileStatus(0L, true, 0, 0L, cTime, cTime, new FsPermission(504), null, this.supergroup, null, DOT_INODES, -1L, 0, null, 0, null);
        HdfsFileStatus raw = new HdfsFileStatus(0L, true, 0, 0L, cTime, cTime, new FsPermission(504), null, this.supergroup, null, RAW, -1L, 0, null, 0, null);
        this.reservedStatuses = new HdfsFileStatus[]{inodes, raw};
    }

    FSNamesystem getFSNamesystem() {
        return this.namesystem;
    }

    @VisibleForTesting
    static SortedSet<String> parseProtectedDirectories(Configuration conf) {
        return FSDirectory.parseProtectedDirectories(conf.getTrimmedStringCollection("fs.protected.directories"));
    }

    @VisibleForTesting
    static SortedSet<String> parseProtectedDirectories(String protectedDirsString) {
        return FSDirectory.parseProtectedDirectories(StringUtils.getTrimmedStringCollection((String)protectedDirsString));
    }

    private static SortedSet<String> parseProtectedDirectories(Collection<String> protectedDirs) {
        return new TreeSet<String>(FSDirectory.normalizePaths(protectedDirs, "fs.protected.directories"));
    }

    SortedSet<String> getProtectedDirectories() {
        return this.protectedDirectories;
    }

    String setProtectedDirectories(String protectedDirsString) {
        this.protectedDirectories = protectedDirsString == null ? new TreeSet<String>() : FSDirectory.parseProtectedDirectories(protectedDirsString);
        return Joiner.on((String)",").skipNulls().join(this.protectedDirectories);
    }

    BlockManager getBlockManager() {
        return this.getFSNamesystem().getBlockManager();
    }

    KeyProviderCryptoExtension getProvider() {
        return this.getFSNamesystem().getProvider();
    }

    public INodeDirectory getRoot() {
        return this.rootDir;
    }

    public BlockStoragePolicySuite getBlockStoragePolicySuite() {
        return this.getBlockManager().getStoragePolicySuite();
    }

    boolean isPermissionEnabled() {
        return this.isPermissionEnabled;
    }

    boolean isAclsEnabled() {
        return this.aclsEnabled;
    }

    boolean isXattrsEnabled() {
        return this.xattrsEnabled;
    }

    int getXattrMaxSize() {
        return this.xattrMaxSize;
    }

    boolean isStoragePolicyEnabled() {
        return this.storagePolicyEnabled;
    }

    boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    boolean isQuotaByStorageTypeEnabled() {
        return this.quotaByStorageTypeEnabled;
    }

    int getLsLimit() {
        return this.lsLimit;
    }

    int getContentCountLimit() {
        return this.contentCountLimit;
    }

    long getContentSleepMicroSec() {
        return this.contentSleepMicroSec;
    }

    int getInodeXAttrsLimit() {
        return this.inodeXAttrsLimit;
    }

    FSEditLog getEditLog() {
        return this.editLog;
    }

    @Override
    public void close() throws IOException {
    }

    void markNameCacheInitialized() {
        this.writeLock();
        try {
            this.nameCache.initialized();
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean shouldSkipQuotaChecks() {
        return this.skipQuotaCheck;
    }

    void enableQuotaChecks() {
        this.skipQuotaCheck = false;
    }

    void disableQuotaChecks() {
        this.skipQuotaCheck = true;
    }

    @VisibleForTesting
    public INodesInPath resolvePath(FSPermissionChecker pc, String src) throws UnresolvedLinkException, FileNotFoundException, AccessControlException {
        return this.resolvePath(pc, src, true);
    }

    @VisibleForTesting
    public INodesInPath resolvePath(FSPermissionChecker pc, String src, boolean resolveLink) throws UnresolvedLinkException, FileNotFoundException, AccessControlException {
        byte[][] components = INode.getPathComponents(src);
        boolean isRaw = FSDirectory.isReservedRawName(components);
        if (this.isPermissionEnabled && pc != null && isRaw) {
            pc.checkSuperuserPrivilege();
        }
        components = FSDirectory.resolveComponents(components, this);
        return INodesInPath.resolve(this.rootDir, components, isRaw, resolveLink);
    }

    INodesInPath resolvePathForWrite(FSPermissionChecker pc, String src) throws UnresolvedLinkException, FileNotFoundException, AccessControlException {
        return this.resolvePathForWrite(pc, src, true);
    }

    INodesInPath resolvePathForWrite(FSPermissionChecker pc, String src, boolean resolveLink) throws UnresolvedLinkException, FileNotFoundException, AccessControlException {
        INodesInPath iip = this.resolvePath(pc, src, resolveLink);
        if (iip.isSnapshot()) {
            throw new SnapshotAccessControlException("Modification on a read-only snapshot is disallowed");
        }
        return iip;
    }

    INodesInPath resolvePath(FSPermissionChecker pc, String src, long fileId) throws UnresolvedLinkException, FileNotFoundException, AccessControlException {
        INode inode;
        INodesInPath iip = fileId == 0L ? this.resolvePath(pc, src) : ((inode = this.getInode(fileId)) == null ? INodesInPath.fromComponents(INode.getPathComponents(src)) : INodesInPath.fromINode(inode));
        return iip;
    }

    static String resolvePath(String src, FSDirectory fsd) throws FileNotFoundException {
        byte[][] pathComponents = INode.getPathComponents(src);
        pathComponents = FSDirectory.resolveComponents(pathComponents, fsd);
        return DFSUtil.byteArray2PathString(pathComponents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNonEmptyDirectory(INodesInPath inodesInPath) {
        this.readLock();
        try {
            INode inode = inodesInPath.getLastINode();
            if (inode == null || !inode.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            int s = inodesInPath.getPathSnapshotId();
            boolean bl = !inode.asDirectory().getChildrenList(s).isEmpty();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    boolean isValidToCreate(String src, INodesInPath iip) throws SnapshotAccessControlException {
        String srcs = FSDirectory.normalizePath(src);
        return srcs.startsWith("/") && !srcs.endsWith("/") && iip.getLastINode() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDir(String src) throws UnresolvedLinkException {
        src = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INode node = this.getINode(src, false);
            boolean bl = node != null && node.isDirectory();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    void updateReplicationFactor(Collection<INode.BlocksMapUpdateInfo.UpdatedReplicationInfo> blocks) {
        BlockManager bm = this.getBlockManager();
        for (INode.BlocksMapUpdateInfo.UpdatedReplicationInfo e : blocks) {
            BlockInfo b = e.block();
            bm.setReplication(b.getReplication(), e.targetReplication(), b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCountForQuota(int initThreads) {
        this.writeLock();
        try {
            int threads = initThreads < 1 ? 1 : initThreads;
            LOG.info("Initializing quota with " + threads + " thread(s)");
            long start = Time.now();
            QuotaCounts counts = new QuotaCounts.Builder().build();
            ForkJoinPool p = new ForkJoinPool(threads);
            InitQuotaTask task = new InitQuotaTask(this.getBlockStoragePolicySuite(), this.rootDir.getStoragePolicyID(), this.rootDir, counts);
            p.execute(task);
            task.join();
            p.shutdown();
            LOG.info("Quota initialization completed in " + (Time.now() - start) + " milliseconds\n" + counts);
        }
        finally {
            this.writeUnlock();
        }
    }

    void updateCountForQuota() {
        this.updateCountForQuota(this.quotaInitThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpaceConsumed(INodesInPath iip, long nsDelta, long ssDelta, short replication) throws QuotaExceededException, FileNotFoundException, UnresolvedLinkException, SnapshotAccessControlException {
        this.writeLock();
        try {
            if (iip.getLastINode() == null) {
                throw new FileNotFoundException("Path not found: " + iip.getPath());
            }
            this.updateCount(iip, nsDelta, ssDelta, replication, true);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void updateCount(INodesInPath iip, INode.QuotaDelta quotaDelta, boolean check) throws QuotaExceededException {
        QuotaCounts counts = quotaDelta.getCountsCopy();
        this.updateCount(iip, iip.length() - 1, counts.negation(), check);
        Map<INode, QuotaCounts> deltaInOtherPaths = quotaDelta.getUpdateMap();
        for (Map.Entry<INode, QuotaCounts> entry : deltaInOtherPaths.entrySet()) {
            INodesInPath path = INodesInPath.fromINode(entry.getKey());
            this.updateCount(path, path.length() - 1, entry.getValue().negation(), check);
        }
        for (Map.Entry<INode, QuotaCounts> entry : quotaDelta.getQuotaDirMap().entrySet()) {
            INodeDirectory quotaDir = (INodeDirectory)entry.getKey();
            quotaDir.getDirectoryWithQuotaFeature().addSpaceConsumed2Cache(entry.getValue().negation());
        }
    }

    void updateCountForDelete(INode inode, INodesInPath iip) {
        if (this.getFSNamesystem().isImageLoaded() && !inode.isInLatestSnapshot(iip.getLatestSnapshotId())) {
            QuotaCounts counts = inode.computeQuotaUsage(this.getBlockStoragePolicySuite());
            FSDirectory.unprotectedUpdateCount(iip, iip.length() - 1, counts.negation());
        }
    }

    void updateCount(INodesInPath iip, long nsDelta, long ssDelta, short replication, boolean checkQuota) throws QuotaExceededException {
        INodeFile fileINode = iip.getLastINode().asFile();
        EnumCounters<StorageType> typeSpaceDeltas = this.getStorageTypeDeltas(fileINode.getStoragePolicyID(), ssDelta, replication, replication);
        this.updateCount(iip, iip.length() - 1, new QuotaCounts.Builder().nameSpace(nsDelta).storageSpace(ssDelta * (long)replication).typeSpaces(typeSpaceDeltas).build(), checkQuota);
    }

    void updateCount(INodesInPath iip, long nsDelta, long ssDelta, short oldRep, short newRep, boolean checkQuota) throws QuotaExceededException {
        INodeFile fileINode = iip.getLastINode().asFile();
        EnumCounters<StorageType> typeSpaceDeltas = this.getStorageTypeDeltas(fileINode.getStoragePolicyID(), ssDelta, oldRep, newRep);
        this.updateCount(iip, iip.length() - 1, new QuotaCounts.Builder().nameSpace(nsDelta).storageSpace(ssDelta * (long)(newRep - oldRep)).typeSpaces(typeSpaceDeltas).build(), checkQuota);
    }

    void updateCount(INodesInPath iip, int numOfINodes, QuotaCounts counts, boolean checkQuota) throws QuotaExceededException {
        assert (this.hasWriteLock());
        if (!this.namesystem.isImageLoaded()) {
            return;
        }
        if (numOfINodes > iip.length()) {
            numOfINodes = iip.length();
        }
        if (checkQuota && !this.skipQuotaCheck) {
            FSDirectory.verifyQuota(iip, numOfINodes, counts, null);
        }
        FSDirectory.unprotectedUpdateCount(iip, numOfINodes, counts);
    }

    void updateCountNoQuotaCheck(INodesInPath inodesInPath, int numOfINodes, QuotaCounts counts) {
        assert (this.hasWriteLock());
        try {
            this.updateCount(inodesInPath, numOfINodes, counts, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.error("BUG: unexpected exception ", (Throwable)e);
        }
    }

    static void unprotectedUpdateCount(INodesInPath inodesInPath, int numOfINodes, QuotaCounts counts) {
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodesInPath.getINode(i).isQuotaSet()) continue;
            inodesInPath.getINode(i).asDirectory().getDirectoryWithQuotaFeature().addSpaceConsumed2Cache(counts);
        }
    }

    public EnumCounters<StorageType> getStorageTypeDeltas(byte storagePolicyID, long dsDelta, short oldRep, short newRep) {
        EnumCounters<StorageType> typeSpaceDeltas = new EnumCounters<StorageType>(StorageType.class);
        if (dsDelta == 0L) {
            return typeSpaceDeltas;
        }
        if (storagePolicyID != 0) {
            BlockStoragePolicy storagePolicy = this.getBlockManager().getStoragePolicy(storagePolicyID);
            if (oldRep != newRep) {
                List oldChosenStorageTypes = storagePolicy.chooseStorageTypes(oldRep);
                for (StorageType t : oldChosenStorageTypes) {
                    if (!t.supportTypeQuota()) continue;
                    Preconditions.checkArgument((dsDelta > 0L ? 1 : 0) != 0);
                    typeSpaceDeltas.add(t, -dsDelta);
                }
            }
            List newChosenStorageTypes = storagePolicy.chooseStorageTypes(newRep);
            for (StorageType t : newChosenStorageTypes) {
                if (!t.supportTypeQuota()) continue;
                typeSpaceDeltas.add(t, dsDelta);
            }
        }
        return typeSpaceDeltas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodesInPath addINode(INodesInPath existing, INode child) throws QuotaExceededException, UnresolvedLinkException {
        this.cacheName(child);
        this.writeLock();
        try {
            INodesInPath iNodesInPath = this.addLastINode(existing, child, true);
            return iNodesInPath;
        }
        finally {
            this.writeUnlock();
        }
    }

    static void verifyQuota(INodesInPath iip, int pos, QuotaCounts deltas, INode commonAncestor) throws QuotaExceededException {
        if (deltas.getNameSpace() <= 0L && deltas.getStorageSpace() <= 0L && deltas.getTypeSpaces().allLessOrEqual(0L)) {
            return;
        }
        for (int i = (pos > iip.length() ? iip.length() : pos) - 1; i >= 0; --i) {
            if (commonAncestor == iip.getINode(i)) {
                return;
            }
            DirectoryWithQuotaFeature q = iip.getINode(i).asDirectory().getDirectoryWithQuotaFeature();
            if (q == null) continue;
            try {
                q.verifyQuota(deltas);
                continue;
            }
            catch (QuotaExceededException e) {
                e.setPathName(iip.getPath(i));
                throw e;
            }
        }
    }

    void verifyINodeName(byte[] childName) throws HadoopIllegalArgumentException {
        if (Arrays.equals(HdfsServerConstants.DOT_SNAPSHOT_DIR_BYTES, childName)) {
            String s = "\".snapshot\" is a reserved name.";
            if (!this.namesystem.isImageLoaded()) {
                s = s + "  Please rename it before upgrade.";
            }
            throw new HadoopIllegalArgumentException(s);
        }
    }

    void verifyMaxComponentLength(byte[] childName, String parentPath) throws FSLimitException.PathComponentTooLongException {
        if (this.maxComponentLength == 0) {
            return;
        }
        int length = childName.length;
        if (length > this.maxComponentLength) {
            FSLimitException.PathComponentTooLongException e = new FSLimitException.PathComponentTooLongException(this.maxComponentLength, length, parentPath, DFSUtil.bytes2String(childName));
            if (this.namesystem.isImageLoaded()) {
                throw e;
            }
            NameNode.LOG.error("ERROR in FSDirectory.verifyINodeName", (Throwable)((Object)e));
        }
    }

    void verifyMaxDirItems(INodeDirectory parent, String parentPath) throws FSLimitException.MaxDirectoryItemsExceededException {
        int count = parent.getChildrenList(0x7FFFFFFE).size();
        if (count >= this.maxDirItems) {
            FSLimitException.MaxDirectoryItemsExceededException e = new FSLimitException.MaxDirectoryItemsExceededException(parentPath, this.maxDirItems, count);
            if (this.namesystem.isImageLoaded()) {
                throw e;
            }
            NameNode.LOG.error("FSDirectory.verifyMaxDirItems: " + e.getLocalizedMessage());
        }
    }

    @VisibleForTesting
    public INodesInPath addLastINode(INodesInPath existing, INode inode, boolean checkQuota) throws QuotaExceededException {
        boolean added;
        assert (existing.getLastINode() != null && existing.getLastINode().isDirectory());
        int pos = existing.length();
        if (pos == 1 && existing.getINode(0) == this.rootDir && FSDirectory.isReservedName(inode)) {
            throw new HadoopIllegalArgumentException("File name \"" + inode.getLocalName() + "\" is reserved and cannot be created. If this is during upgrade change the name of the existing file or directory to another name before upgrading to the new release.");
        }
        INodeDirectory parent = existing.getINode(pos - 1).asDirectory();
        if (checkQuota) {
            String parentPath = existing.getPath();
            this.verifyMaxComponentLength(inode.getLocalNameBytes(), parentPath);
            this.verifyMaxDirItems(parent, parentPath);
        }
        this.verifyINodeName(inode.getLocalNameBytes());
        QuotaCounts counts = inode.computeQuotaUsage(this.getBlockStoragePolicySuite());
        this.updateCount(existing, pos, counts, checkQuota);
        boolean isRename = inode.getParent() != null;
        try {
            added = parent.addChild(inode, true, existing.getLatestSnapshotId());
        }
        catch (QuotaExceededException e) {
            this.updateCountNoQuotaCheck(existing, pos, counts.negation());
            throw e;
        }
        if (!added) {
            this.updateCountNoQuotaCheck(existing, pos, counts.negation());
            return null;
        }
        if (!isRename) {
            AclStorage.copyINodeDefaultAcl(inode);
        }
        this.addToInodeMap(inode);
        return INodesInPath.append(existing, inode, inode.getLocalNameBytes());
    }

    INodesInPath addLastINodeNoQuotaCheck(INodesInPath existing, INode i) {
        try {
            return this.addLastINode(existing, i, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn("FSDirectory.addChildNoQuotaCheck - unexpected", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    public long removeLastINode(INodesInPath iip) {
        int latestSnapshot = iip.getLatestSnapshotId();
        INode last = iip.getLastINode();
        INodeDirectory parent = iip.getINode(-2).asDirectory();
        if (!parent.removeChild(last, latestSnapshot)) {
            return -1L;
        }
        return !last.isInLatestSnapshot(latestSnapshot) && INodeReference.tryRemoveReference(last) > 0 ? 0L : 1L;
    }

    static Collection<String> normalizePaths(Collection<String> paths, String errorString) {
        if (paths.isEmpty()) {
            return paths;
        }
        ArrayList<String> normalized = new ArrayList<String>(paths.size());
        for (String dir : paths) {
            if (FSDirectory.isReservedName(dir)) {
                LOG.error("{} ignoring reserved path {}", (Object)errorString, (Object)dir);
                continue;
            }
            Path path = new Path(dir);
            if (!path.isAbsolute()) {
                LOG.error("{} ignoring relative path {}", (Object)errorString, (Object)dir);
                continue;
            }
            if (path.toUri().getScheme() != null) {
                LOG.error("{} ignoring path {} with scheme", (Object)errorString, (Object)dir);
                continue;
            }
            normalized.add(path.toString());
        }
        return normalized;
    }

    static String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    @VisibleForTesting
    public long getYieldCount() {
        return this.yieldCount;
    }

    void addYieldCount(long value) {
        this.yieldCount += value;
    }

    public INodeMap getINodeMap() {
        return this.inodeMap;
    }

    public final void addToInodeMap(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.inodeMap.put(inode);
            if (!inode.isSymlink()) {
                XAttrFeature xaf = inode.getXAttrFeature();
                this.addEncryptionZone((INodeWithAdditionalFields)inode, xaf);
            }
        }
    }

    private void addEncryptionZone(INodeWithAdditionalFields inode, XAttrFeature xaf) {
        if (xaf == null) {
            return;
        }
        XAttr xattr = xaf.getXAttr("raw.hdfs.crypto.encryption.zone");
        if (xattr == null) {
            return;
        }
        try {
            HdfsProtos.ZoneEncryptionInfoProto ezProto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom((byte[])xattr.getValue());
            this.ezManager.unprotectedAddEncryptionZone(inode.getId(), PBHelperClient.convert((HdfsProtos.CipherSuiteProto)ezProto.getSuite()), PBHelperClient.convert((HdfsProtos.CryptoProtocolVersionProto)ezProto.getCryptoProtocolVersion()), ezProto.getKeyName());
        }
        catch (InvalidProtocolBufferException e) {
            NameNode.LOG.warn("Error parsing protocol buffer of EZ XAttr " + xattr.getName() + " dir:" + inode.getFullPathName());
        }
    }

    public final void addRootDirToEncryptionZone(XAttrFeature xaf) {
        this.addEncryptionZone(this.rootDir, xaf);
    }

    public final void removeFromInodeMap(List<? extends INode> inodes) {
        if (inodes != null) {
            for (INode iNode : inodes) {
                if (iNode == null || !(iNode instanceof INodeWithAdditionalFields)) continue;
                this.inodeMap.remove(iNode);
                this.ezManager.removeEncryptionZone(iNode.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getInode(long id) {
        this.readLock();
        try {
            INode iNode = this.inodeMap.get(id);
            return iNode;
        }
        finally {
            this.readUnlock();
        }
    }

    @VisibleForTesting
    int getInodeMapSize() {
        return this.inodeMap.size();
    }

    long totalInodes() {
        return this.getInodeMapSize();
    }

    void reset() {
        this.writeLock();
        try {
            this.rootDir = FSDirectory.createRoot(this.getFSNamesystem());
            this.inodeMap.clear();
            this.addToInodeMap(this.rootDir);
            this.nameCache.reset();
            this.inodeId.setCurrentValue(16384L);
        }
        finally {
            this.writeUnlock();
        }
    }

    static INode resolveLastINode(INodesInPath iip) throws FileNotFoundException {
        INode inode = iip.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("cannot find " + iip.getPath());
        }
        return inode;
    }

    void cacheName(INode inode) {
        if (!inode.isFile()) {
            return;
        }
        ByteArray name = new ByteArray(inode.getLocalNameBytes());
        if ((name = this.nameCache.put(name)) != null) {
            inode.setLocalName(name.getBytes());
        }
    }

    void shutdown() {
        this.nameCache.reset();
        this.inodeMap.clear();
    }

    public static byte[][] getPathComponents(INode inode) {
        ArrayList<byte[]> components = new ArrayList<byte[]>();
        components.add(0, inode.getLocalNameBytes());
        while (inode.getParent() != null) {
            components.add(0, inode.getParent().getLocalNameBytes());
            inode = inode.getParent();
        }
        return (byte[][])components.toArray((T[])new byte[components.size()][]);
    }

    public static boolean isReservedName(INode inode) {
        return CHECK_RESERVED_FILE_NAMES && Arrays.equals(inode.getLocalNameBytes(), DOT_RESERVED);
    }

    public static boolean isReservedName(String src) {
        return src.startsWith("/.reserved/");
    }

    public static boolean isExactReservedName(String src) {
        return CHECK_RESERVED_FILE_NAMES && src.equals(DOT_RESERVED_PATH_PREFIX);
    }

    public static boolean isExactReservedName(byte[][] components) {
        return CHECK_RESERVED_FILE_NAMES && components.length == 2 && FSDirectory.isReservedName(components);
    }

    static boolean isReservedRawName(String src) {
        return src.startsWith("/.reserved/raw");
    }

    static boolean isReservedInodesName(String src) {
        return src.startsWith("/.reserved/.inodes");
    }

    static boolean isReservedName(byte[][] components) {
        return components.length > 1 && Arrays.equals(INodeDirectory.ROOT_NAME, components[0]) && Arrays.equals(DOT_RESERVED, components[1]);
    }

    static boolean isReservedRawName(byte[][] components) {
        return components.length > 2 && FSDirectory.isReservedName(components) && Arrays.equals(RAW, components[2]);
    }

    static byte[][] resolveComponents(byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException {
        int nComponents = ((byte[][])pathComponents).length;
        if (nComponents >= 3 && FSDirectory.isReservedName(pathComponents)) {
            if (Arrays.equals(DOT_INODES, pathComponents[2])) {
                if (nComponents > 3) {
                    pathComponents = FSDirectory.resolveDotInodesPath(pathComponents, fsd);
                }
            } else if (Arrays.equals(RAW, pathComponents[2])) {
                if (nComponents == 3) {
                    pathComponents = new byte[][]{INodeDirectory.ROOT_NAME};
                } else if (nComponents != 4 || !Arrays.equals(DOT_RESERVED, pathComponents[3])) {
                    pathComponents = FSDirectory.constructRemainingPath(new byte[][]{INodeDirectory.ROOT_NAME}, pathComponents, 3);
                }
            }
        }
        return pathComponents;
    }

    private static byte[][] resolveDotInodesPath(byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException {
        long id;
        String inodeId = DFSUtil.bytes2String(pathComponents[3]);
        try {
            id = Long.parseLong(inodeId);
        }
        catch (NumberFormatException e) {
            throw new FileNotFoundException("Invalid inode path: " + DFSUtil.byteArray2PathString(pathComponents));
        }
        if (id == 16385L && pathComponents.length == 4) {
            return new byte[][]{INodeDirectory.ROOT_NAME};
        }
        INode inode = fsd.getInode(id);
        if (inode == null) {
            throw new FileNotFoundException("File for given inode path does not exist: " + DFSUtil.byteArray2PathString(pathComponents));
        }
        if (pathComponents.length > 4 && Arrays.equals(pathComponents[4], DOT_DOT)) {
            INodeDirectory parent = inode.getParent();
            if (parent == null || ((INode)parent).getId() == 16385L) {
                return new byte[][]{INodeDirectory.ROOT_NAME};
            }
            return parent.getPathComponents();
        }
        return FSDirectory.constructRemainingPath(inode.getPathComponents(), pathComponents, 4);
    }

    private static byte[][] constructRemainingPath(byte[][] components, byte[][] extraComponents, int startAt) {
        int remainder = extraComponents.length - startAt;
        if (remainder > 0) {
            int pos = components.length;
            components = (byte[][])Arrays.copyOf(components, pos + remainder);
            System.arraycopy(extraComponents, startAt, components, pos, remainder);
        }
        if (NameNode.LOG.isDebugEnabled()) {
            NameNode.LOG.debug("Resolved path is " + DFSUtil.byteArray2PathString(components));
        }
        return components;
    }

    INode getINode4DotSnapshot(INodesInPath iip) throws UnresolvedLinkException {
        Preconditions.checkArgument((boolean)iip.isDotSnapshotDir(), (String)"%s does not end with %s", (Object[])new Object[]{iip.getPath(), "/.snapshot"});
        INode node = iip.getINode(-2);
        if (node != null && node.isDirectory() && node.asDirectory().isSnapshottable()) {
            return node;
        }
        return null;
    }

    INodesInPath getExistingPathINodes(byte[][] components) throws UnresolvedLinkException {
        return INodesInPath.resolve(this.rootDir, components, false);
    }

    public INodesInPath getINodesInPath4Write(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        return this.getINodesInPath4Write(src, true);
    }

    public INode getINode4Write(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        return this.getINodesInPath4Write(src, true).getLastINode();
    }

    public INodesInPath getINodesInPath(String path, boolean resolveLink) throws UnresolvedLinkException {
        byte[][] components = INode.getPathComponents(path);
        return INodesInPath.resolve(this.rootDir, components, resolveLink);
    }

    INode getINode(String path, boolean resolveLink) throws UnresolvedLinkException {
        return this.getINodesInPath(path, resolveLink).getLastINode();
    }

    public INode getINode(String src) throws UnresolvedLinkException {
        return this.getINode(src, true);
    }

    INodesInPath getINodesInPath4Write(String src, boolean resolveLink) throws UnresolvedLinkException, SnapshotAccessControlException {
        byte[][] components = INode.getPathComponents(src);
        INodesInPath inodesInPath = INodesInPath.resolve(this.rootDir, components, resolveLink);
        if (inodesInPath.isSnapshot()) {
            throw new SnapshotAccessControlException("Modification on a read-only snapshot is disallowed");
        }
        return inodesInPath;
    }

    FSPermissionChecker getPermissionChecker() throws AccessControlException {
        try {
            return this.getPermissionChecker(this.fsOwnerShortUserName, this.supergroup, NameNode.getRemoteUser());
        }
        catch (IOException e) {
            throw new AccessControlException((Throwable)e);
        }
    }

    @VisibleForTesting
    FSPermissionChecker getPermissionChecker(String fsOwner, String superGroup, UserGroupInformation ugi) throws AccessControlException {
        return new FSPermissionChecker(fsOwner, superGroup, ugi, this.attributeProvider);
    }

    void checkOwner(FSPermissionChecker pc, INodesInPath iip) throws AccessControlException, FileNotFoundException {
        if (iip.getLastINode() == null) {
            throw new FileNotFoundException("Directory/File does not exist " + iip.getPath());
        }
        this.checkPermission(pc, iip, true, null, null, null, null);
    }

    void checkPathAccess(FSPermissionChecker pc, INodesInPath iip, FsAction access) throws AccessControlException {
        this.checkPermission(pc, iip, false, null, null, access, null);
    }

    void checkParentAccess(FSPermissionChecker pc, INodesInPath iip, FsAction access) throws AccessControlException {
        this.checkPermission(pc, iip, false, null, access, null, null);
    }

    void checkAncestorAccess(FSPermissionChecker pc, INodesInPath iip, FsAction access) throws AccessControlException {
        this.checkPermission(pc, iip, false, access, null, null, null);
    }

    void checkTraverse(FSPermissionChecker pc, INodesInPath iip) throws AccessControlException {
        this.checkPermission(pc, iip, false, null, null, null, null);
    }

    void checkPermission(FSPermissionChecker pc, INodesInPath iip, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException {
        this.checkPermission(pc, iip, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPermission(FSPermissionChecker pc, INodesInPath iip, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        if (!pc.isSuperUser()) {
            this.readLock();
            try {
                pc.checkPermission(iip, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    void checkUnreadableBySuperuser(FSPermissionChecker pc, INode inode, int snapshotId) throws IOException {
        if (pc.isSuperUser() && FSDirXAttrOp.getXAttrByPrefixedName(this, inode, snapshotId, "security.hdfs.unreadable.by.superuser") != null) {
            throw new AccessControlException("Access is denied for " + pc.getUser() + " since the superuser is not allowed to perform this operation.");
        }
    }

    HdfsFileStatus getAuditFileInfo(INodesInPath iip) throws IOException {
        return this.namesystem.isAuditEnabled() && this.namesystem.isExternalInvocation() ? FSDirStatAndListingOp.getFileInfo(this, iip, false) : null;
    }

    void verifyParentDir(INodesInPath iip, String src) throws FileNotFoundException, ParentNotDirectoryException {
        Path parent = new Path(src).getParent();
        if (parent != null) {
            INode parentNode = iip.getINode(-2);
            if (parentNode == null) {
                throw new FileNotFoundException("Parent directory doesn't exist: " + parent);
            }
            if (!parentNode.isDirectory() && !parentNode.isSymlink()) {
                throw new ParentNotDirectoryException("Parent path is not a directory: " + parent);
            }
        }
    }

    long allocateNewInodeId() {
        return this.inodeId.nextValue();
    }

    public long getLastInodeId() {
        return this.inodeId.getCurrentValue();
    }

    void resetLastInodeId(long newValue) throws IOException {
        try {
            this.inodeId.skipTo(newValue);
        }
        catch (IllegalStateException ise) {
            throw new IOException(ise);
        }
    }

    void resetLastInodeIdWithoutChecking(long newValue) {
        this.inodeId.setCurrentValue(newValue);
    }

    INodeAttributes getAttributes(String fullPath, byte[] path, INode node, int snapshot) {
        INodeAttributes nodeAttrs = node.getSnapshotINode(snapshot);
        if (this.attributeProvider != null) {
            fullPath = fullPath + (fullPath.endsWith("/") ? "" : "/") + DFSUtil.bytes2String(path);
            nodeAttrs = this.attributeProvider.getAttributes(fullPath, nodeAttrs);
        }
        return nodeAttrs;
    }

    private static class InitQuotaTask
    extends RecursiveAction {
        private final INodeDirectory dir;
        private final QuotaCounts counts;
        private final BlockStoragePolicySuite bsps;
        private final byte blockStoragePolicyId;

        public InitQuotaTask(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, INodeDirectory dir, QuotaCounts counts) {
            this.dir = dir;
            this.counts = counts;
            this.bsps = bsps;
            this.blockStoragePolicyId = blockStoragePolicyId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void compute() {
            QuotaCounts myCounts = new QuotaCounts.Builder().build();
            this.dir.computeQuotaUsage4CurrentDirectory(this.bsps, this.blockStoragePolicyId, myCounts);
            ReadOnlyList<INode> children = this.dir.getChildrenList(0x7FFFFFFE);
            if (children.size() > 0) {
                ArrayList<InitQuotaTask> subtasks = new ArrayList<InitQuotaTask>();
                for (INode child : children) {
                    byte childPolicyId = child.getStoragePolicyIDForQuota(this.blockStoragePolicyId);
                    if (child.isDirectory()) {
                        subtasks.add(new InitQuotaTask(this.bsps, childPolicyId, child.asDirectory(), myCounts));
                        continue;
                    }
                    myCounts.add(child.computeQuotaUsage(this.bsps, childPolicyId, false, 0x7FFFFFFE));
                }
                InitQuotaTask.invokeAll(subtasks);
            }
            if (this.dir.isQuotaSet()) {
                QuotaCounts q = this.dir.getQuotaCounts();
                long nsConsumed = myCounts.getNameSpace();
                long nsQuota = q.getNameSpace();
                if (Quota.isViolated(nsQuota, nsConsumed)) {
                    LOG.warn("Namespace quota violation in image for " + this.dir.getFullPathName() + " quota = " + nsQuota + " < consumed = " + nsConsumed);
                }
                long ssConsumed = myCounts.getStorageSpace();
                long ssQuota = q.getStorageSpace();
                if (Quota.isViolated(ssQuota, ssConsumed)) {
                    LOG.warn("Storagespace quota violation in image for " + this.dir.getFullPathName() + " quota = " + ssQuota + " < consumed = " + ssConsumed);
                }
                EnumCounters<StorageType> tsConsumed = myCounts.getTypeSpaces();
                for (StorageType t : StorageType.getTypesSupportingQuota()) {
                    long typeSpace = tsConsumed.get(t);
                    long typeQuota = q.getTypeSpaces().get(t);
                    if (!Quota.isViolated(typeQuota, typeSpace)) continue;
                    LOG.warn("Storage type quota violation in image for " + this.dir.getFullPathName() + " type = " + t.toString() + " quota = " + typeQuota + " < consumed " + typeSpace);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting quota for " + this.dir + "\n" + myCounts);
                }
                this.dir.getDirectoryWithQuotaFeature().setSpaceConsumed(nsConsumed, ssConsumed, tsConsumed);
            }
            QuotaCounts quotaCounts = this.counts;
            synchronized (quotaCounts) {
                this.counts.add(myCounts);
            }
        }
    }
}

