/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.MultiException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;

public class RequestHedgingProxyProvider<T>
extends ConfiguredFailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(RequestHedgingProxyProvider.class);
    private volatile FailoverProxyProvider.ProxyInfo<T> successfulProxy = null;
    private volatile String toIgnore = null;

    public RequestHedgingProxyProvider(Configuration conf, URI uri, Class<T> xface) {
        this(conf, uri, xface, new ConfiguredFailoverProxyProvider.DefaultProxyFactory());
    }

    @VisibleForTesting
    RequestHedgingProxyProvider(Configuration conf, URI uri, Class<T> xface, ConfiguredFailoverProxyProvider.ProxyFactory<T> factory) {
        super(conf, uri, xface, factory);
    }

    @Override
    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.successfulProxy != null) {
            return this.successfulProxy;
        }
        HashMap targetProxyInfos = new HashMap();
        StringBuilder combinedInfo = new StringBuilder("[");
        for (int i = 0; i < this.proxies.size(); ++i) {
            FailoverProxyProvider.ProxyInfo pInfo = super.getProxy();
            this.incrementProxyIndex();
            targetProxyInfos.put(pInfo.proxyInfo, pInfo);
            combinedInfo.append(pInfo.proxyInfo).append(',');
        }
        combinedInfo.append(']');
        Object wrappedProxy = Proxy.newProxyInstance(RequestHedgingInvocationHandler.class.getClassLoader(), new Class[]{this.xface}, (InvocationHandler)new RequestHedgingInvocationHandler(targetProxyInfos));
        return new FailoverProxyProvider.ProxyInfo(wrappedProxy, combinedInfo.toString());
    }

    @Override
    public synchronized void performFailover(T currentProxy) {
        this.toIgnore = this.successfulProxy.proxyInfo;
        this.successfulProxy = null;
    }

    private void logProxyException(Exception ex, String proxyInfo) {
        if (this.isStandbyException(ex)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Invocation returned standby exception on [" + proxyInfo + "]"));
            }
        } else {
            LOG.warn((Object)("Invocation returned exception on [" + proxyInfo + "]"));
        }
    }

    private boolean isStandbyException(Exception ex) {
        Throwable cause2;
        Throwable cause = ex.getCause();
        if (cause != null && (cause2 = cause.getCause()) instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)cause2;
            IOException unwrapRemoteException = remoteException.unwrapRemoteException();
            return unwrapRemoteException instanceof StandbyException;
        }
        return false;
    }

    class RequestHedgingInvocationHandler
    implements InvocationHandler {
        final Map<String, FailoverProxyProvider.ProxyInfo<T>> targetProxies;

        public RequestHedgingInvocationHandler(Map<String, FailoverProxyProvider.ProxyInfo<T>> targetProxies) {
            this.targetProxies = new HashMap(targetProxies);
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            HashMap<String, Exception> badResults;
            ExecutorService executor;
            block12: {
                HashMap proxyMap = new HashMap();
                int numAttempts = 0;
                executor = null;
                this.targetProxies.remove(RequestHedgingProxyProvider.this.toIgnore);
                if (this.targetProxies.size() == 1) {
                    FailoverProxyProvider.ProxyInfo proxyInfo = this.targetProxies.values().iterator().next();
                    Object retVal = method.invoke(proxyInfo.proxy, args);
                    RequestHedgingProxyProvider.this.successfulProxy = proxyInfo;
                    Object object = retVal;
                    return object;
                }
                executor = Executors.newFixedThreadPool(RequestHedgingProxyProvider.this.proxies.size());
                ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executor);
                for (final Map.Entry pEntry : this.targetProxies.entrySet()) {
                    Callable<Object> c = new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return method.invoke(((FailoverProxyProvider.ProxyInfo)pEntry.getValue()).proxy, args);
                        }
                    };
                    proxyMap.put(completionService.submit(c), pEntry.getValue());
                    ++numAttempts;
                }
                badResults = new HashMap<String, Exception>();
                while (numAttempts > 0) {
                    Future callResultFuture = completionService.take();
                    try {
                        Object retVal = callResultFuture.get();
                        RequestHedgingProxyProvider.this.successfulProxy = (FailoverProxyProvider.ProxyInfo)proxyMap.get(callResultFuture);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Invocation successful on [" + ((RequestHedgingProxyProvider)RequestHedgingProxyProvider.this).successfulProxy.proxyInfo + "]"));
                        }
                        Object v = retVal;
                        return v;
                    }
                    catch (Exception ex) {
                        FailoverProxyProvider.ProxyInfo tProxyInfo = (FailoverProxyProvider.ProxyInfo)proxyMap.get(callResultFuture);
                        RequestHedgingProxyProvider.this.logProxyException(ex, tProxyInfo.proxyInfo);
                        badResults.put(tProxyInfo.proxyInfo, ex);
                        --numAttempts;
                    }
                }
                if (badResults.size() != 1) break block12;
                throw (Exception)badResults.values().iterator().next();
            }
            throw new MultiException(badResults);
            finally {
                if (executor != null) {
                    executor.shutdownNow();
                }
            }
        }
    }
}

