/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedWriter;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
class StripedBlockWriter {
    private final StripedWriter stripedWriter;
    private final DataNode datanode;
    private final Configuration conf;
    private final ExtendedBlock block;
    private final DatanodeInfo target;
    private final StorageType storageType;
    private Socket targetSocket;
    private DataOutputStream targetOutputStream;
    private DataInputStream targetInputStream;
    private ByteBuffer targetBuffer;
    private long blockOffset4Target = 0L;
    private long seqNo4Target = 0L;
    private static final ByteBufferPool BUFFER_POOL = new ElasticByteBufferPool();

    StripedBlockWriter(StripedWriter stripedWriter, DataNode datanode, Configuration conf, ExtendedBlock block, DatanodeInfo target, StorageType storageType) throws IOException {
        this.stripedWriter = stripedWriter;
        this.datanode = datanode;
        this.conf = conf;
        this.block = block;
        this.target = target;
        this.storageType = storageType;
        this.targetBuffer = stripedWriter.allocateWriteBuffer();
        this.init();
    }

    ByteBuffer getTargetBuffer() {
        return this.targetBuffer;
    }

    void freeTargetBuffer() {
        this.targetBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws IOException {
        Socket socket = null;
        DataOutputStream out = null;
        DataInputStream in = null;
        boolean success = false;
        try {
            InetSocketAddress targetAddr = this.stripedWriter.getSocketAddress4Transfer(this.target);
            socket = this.datanode.newSocket();
            NetUtils.connect((Socket)socket, (SocketAddress)targetAddr, (int)this.datanode.getDnConf().getSocketTimeout());
            socket.setTcpNoDelay(this.datanode.getDnConf().getDataTransferServerTcpNoDelay());
            socket.setSoTimeout(this.datanode.getDnConf().getSocketTimeout());
            Token<BlockTokenIdentifier> blockToken = this.datanode.getBlockAccessToken(this.block, EnumSet.of(BlockTokenIdentifier.AccessMode.WRITE));
            long writeTimeout = this.datanode.getDnConf().getSocketWriteTimeout();
            OutputStream unbufOut = NetUtils.getOutputStream((Socket)socket, (long)writeTimeout);
            SocketInputWrapper socketInputWrapper = NetUtils.getInputStream((Socket)socket);
            DataEncryptionKeyFactory keyFactory = this.datanode.getDataEncryptionKeyFactoryForBlock(this.block);
            IOStreamPair saslStreams = this.datanode.getSaslClient().socketSend(socket, unbufOut, (InputStream)socketInputWrapper, keyFactory, blockToken, (DatanodeID)this.target);
            unbufOut = saslStreams.out;
            InputStream inputStream = saslStreams.in;
            out = new DataOutputStream(new BufferedOutputStream(unbufOut, DFSUtilClient.getSmallBufferSize((Configuration)this.conf)));
            in = new DataInputStream(inputStream);
            DatanodeInfo source = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(this.datanode.getDatanodeId()).build();
            new Sender(out).writeBlock(this.block, this.storageType, blockToken, "", new DatanodeInfo[]{this.target}, new StorageType[]{this.storageType}, source, BlockConstructionStage.PIPELINE_SETUP_CREATE, 0, 0L, 0L, 0L, this.stripedWriter.getChecksum(), this.stripedWriter.getCachingStrategy(), false, false, null);
            this.targetSocket = socket;
            this.targetOutputStream = out;
            this.targetInputStream = in;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeStream(out);
            IOUtils.closeStream(in);
            IOUtils.closeStream((Closeable)socket);
            throw throwable;
        }
    }

    void transferData2Target(byte[] packetBuf) throws IOException {
        if (this.targetBuffer.remaining() == 0) {
            return;
        }
        if (this.targetBuffer.isDirect()) {
            ByteBuffer directCheckSumBuf = BUFFER_POOL.getBuffer(true, this.stripedWriter.getChecksumBuf().length);
            this.stripedWriter.getChecksum().calculateChunkedSums(this.targetBuffer, directCheckSumBuf);
            directCheckSumBuf.get(this.stripedWriter.getChecksumBuf());
            BUFFER_POOL.putBuffer(directCheckSumBuf);
        } else {
            this.stripedWriter.getChecksum().calculateChunkedSums(this.targetBuffer.array(), 0, this.targetBuffer.remaining(), this.stripedWriter.getChecksumBuf(), 0);
        }
        int ckOff = 0;
        while (this.targetBuffer.remaining() > 0) {
            DFSPacket packet = new DFSPacket(packetBuf, this.stripedWriter.getMaxChunksPerPacket(), this.blockOffset4Target, this.seqNo4Target++, this.stripedWriter.getChecksumSize(), false);
            int maxBytesToPacket = this.stripedWriter.getMaxChunksPerPacket() * this.stripedWriter.getBytesPerChecksum();
            int toWrite = this.targetBuffer.remaining() > maxBytesToPacket ? maxBytesToPacket : this.targetBuffer.remaining();
            int ckLen = ((toWrite - 1) / this.stripedWriter.getBytesPerChecksum() + 1) * this.stripedWriter.getChecksumSize();
            packet.writeChecksum(this.stripedWriter.getChecksumBuf(), ckOff, ckLen);
            ckOff += ckLen;
            packet.writeData(this.targetBuffer, toWrite);
            packet.writeTo(this.targetOutputStream);
            this.blockOffset4Target += (long)toWrite;
            this.stripedWriter.getReconstructor().incrBytesWritten(toWrite);
        }
    }

    void endTargetBlock(byte[] packetBuf) throws IOException {
        DFSPacket packet = new DFSPacket(packetBuf, 0, this.blockOffset4Target, this.seqNo4Target++, this.stripedWriter.getChecksumSize(), true);
        packet.writeTo(this.targetOutputStream);
        this.targetOutputStream.flush();
    }

    void close() {
        IOUtils.closeStream((Closeable)this.targetOutputStream);
        IOUtils.closeStream((Closeable)this.targetInputStream);
        IOUtils.closeStream((Closeable)this.targetSocket);
    }
}

