/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReader;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;

@InterfaceAudience.Private
abstract class StripedReconstructor {
    protected static final Logger LOG = DataNode.LOG;
    private final Configuration conf;
    private final DataNode datanode;
    private final ErasureCodingPolicy ecPolicy;
    private RawErasureDecoder decoder;
    private final ExtendedBlock blockGroup;
    private static final ByteBufferPool BUFFER_POOL = new ElasticByteBufferPool();
    private long positionInBlock;
    private StripedReader stripedReader;
    private ThreadPoolExecutor stripedReadPool;
    private final CachingStrategy cachingStrategy;
    private long maxTargetLength = 0L;
    private final BitSet liveBitSet;
    private AtomicLong bytesRead = new AtomicLong(0L);
    private AtomicLong bytesWritten = new AtomicLong(0L);
    private AtomicLong remoteBytesRead = new AtomicLong(0L);

    StripedReconstructor(ErasureCodingWorker worker, StripedReconstructionInfo stripedReconInfo) {
        this.stripedReadPool = worker.getStripedReadPool();
        this.datanode = worker.getDatanode();
        this.conf = worker.getConf();
        this.ecPolicy = stripedReconInfo.getEcPolicy();
        this.liveBitSet = new BitSet(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits());
        for (int i = 0; i < stripedReconInfo.getLiveIndices().length; ++i) {
            this.liveBitSet.set(stripedReconInfo.getLiveIndices()[i]);
        }
        this.blockGroup = stripedReconInfo.getBlockGroup();
        this.stripedReader = new StripedReader(this, this.datanode, this.conf, stripedReconInfo);
        this.cachingStrategy = CachingStrategy.newDefaultStrategy();
        this.positionInBlock = 0L;
    }

    public void incrBytesRead(boolean local, long delta) {
        if (local) {
            this.bytesRead.addAndGet(delta);
        } else {
            this.bytesRead.addAndGet(delta);
            this.remoteBytesRead.addAndGet(delta);
        }
    }

    public void incrBytesWritten(long delta) {
        this.bytesWritten.addAndGet(delta);
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    public long getRemoteBytesRead() {
        return this.remoteBytesRead.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    abstract void reconstruct() throws IOException;

    boolean useDirectBuffer() {
        return this.decoder.preferDirectBuffer();
    }

    ByteBuffer allocateBuffer(int length) {
        return BUFFER_POOL.getBuffer(this.useDirectBuffer(), length);
    }

    void freeBuffer(ByteBuffer buffer) {
        BUFFER_POOL.putBuffer(buffer);
    }

    ExtendedBlock getBlock(int i) {
        return StripedBlockUtil.constructInternalBlock((ExtendedBlock)this.blockGroup, (ErasureCodingPolicy)this.ecPolicy, (int)i);
    }

    long getBlockLen(int i) {
        return StripedBlockUtil.getInternalBlockLength((long)this.blockGroup.getNumBytes(), (ErasureCodingPolicy)this.ecPolicy, (int)i);
    }

    protected void initDecoderIfNecessary() {
        if (this.decoder == null) {
            ErasureCoderOptions coderOptions = new ErasureCoderOptions(this.ecPolicy.getNumDataUnits(), this.ecPolicy.getNumParityUnits());
            this.decoder = CodecUtil.createRawDecoder((Configuration)this.conf, (String)this.ecPolicy.getCodecName(), (ErasureCoderOptions)coderOptions);
        }
    }

    long getPositionInBlock() {
        return this.positionInBlock;
    }

    InetSocketAddress getSocketAddress4Transfer(DatanodeInfo dnInfo) {
        return NetUtils.createSocketAddr((String)dnInfo.getXferAddr(this.datanode.getDnConf().getConnectToDnViaHostname()));
    }

    int getBufferSize() {
        return this.stripedReader.getBufferSize();
    }

    public DataChecksum getChecksum() {
        return this.stripedReader.getChecksum();
    }

    CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    CompletionService<Void> createReadService() {
        return new ExecutorCompletionService<Void>(this.stripedReadPool);
    }

    ExtendedBlock getBlockGroup() {
        return this.blockGroup;
    }

    BitSet getLiveBitSet() {
        return this.liveBitSet;
    }

    long getMaxTargetLength() {
        return this.maxTargetLength;
    }

    void setMaxTargetLength(long maxTargetLength) {
        this.maxTargetLength = maxTargetLength;
    }

    void updatePositionInBlock(long positionInBlockArg) {
        this.positionInBlock += positionInBlockArg;
    }

    RawErasureDecoder getDecoder() {
        return this.decoder;
    }

    StripedReader getStripedReader() {
        return this.stripedReader;
    }

    Configuration getConf() {
        return this.conf;
    }

    DataNode getDatanode() {
        return this.datanode;
    }
}

