/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.io.erasurecode.ErasureCodeConstants;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public final class ErasureCodingPolicyManager {
    private static final int DEFAULT_CELLSIZE = 65536;
    private static final ErasureCodingPolicy SYS_POLICY1 = new ErasureCodingPolicy(ErasureCodeConstants.RS_6_3_SCHEMA, 65536, 0);
    private static final ErasureCodingPolicy SYS_POLICY2 = new ErasureCodingPolicy(ErasureCodeConstants.RS_3_2_SCHEMA, 65536, 1);
    private static final ErasureCodingPolicy SYS_POLICY3 = new ErasureCodingPolicy(ErasureCodeConstants.RS_6_3_LEGACY_SCHEMA, 65536, 2);
    private static final ErasureCodingPolicy SYS_POLICY4 = new ErasureCodingPolicy(ErasureCodeConstants.XOR_2_1_SCHEMA, 65536, 3);
    private static final ErasureCodingPolicy SYS_POLICY5 = new ErasureCodingPolicy(ErasureCodeConstants.RS_10_4_SCHEMA, 65536, 4);
    private static final ErasureCodingPolicy[] SYS_POLICIES = new ErasureCodingPolicy[]{SYS_POLICY1, SYS_POLICY2, SYS_POLICY3, SYS_POLICY4, SYS_POLICY5};
    private static final byte[] SUITABLE_STORAGE_POLICIES_FOR_EC_STRIPED_MODE = new byte[]{7, 2, 12};
    private final Map<String, ErasureCodingPolicy> activePoliciesByName = new TreeMap<String, ErasureCodingPolicy>();

    ErasureCodingPolicyManager() {
        for (ErasureCodingPolicy policy : SYS_POLICIES) {
            this.activePoliciesByName.put(policy.getName(), policy);
        }
    }

    public static ErasureCodingPolicy[] getSystemPolicies() {
        return SYS_POLICIES;
    }

    public static ErasureCodingPolicy getSystemDefaultPolicy() {
        return SYS_POLICY1;
    }

    public static ErasureCodingPolicy getPolicyByPolicyID(byte id) {
        for (ErasureCodingPolicy policy : SYS_POLICIES) {
            if (policy.getId() != id) continue;
            return policy;
        }
        return null;
    }

    public ErasureCodingPolicy[] getPolicies() {
        ErasureCodingPolicy[] results = new ErasureCodingPolicy[this.activePoliciesByName.size()];
        return this.activePoliciesByName.values().toArray(results);
    }

    public ErasureCodingPolicy getPolicyByName(String name) {
        return this.activePoliciesByName.get(name);
    }

    public ErasureCodingPolicy getPolicyByID(byte id) {
        for (ErasureCodingPolicy policy : this.activePoliciesByName.values()) {
            if (policy.getId() != id) continue;
            return policy;
        }
        return null;
    }

    public static boolean checkStoragePolicySuitableForECStripedMode(byte storagePolicyID) {
        boolean isPolicySuitable = false;
        for (byte suitablePolicy : SUITABLE_STORAGE_POLICIES_FOR_EC_STRIPED_MODE) {
            if (storagePolicyID != suitablePolicy) continue;
            isPolicySuitable = true;
            break;
        }
        return isPolicySuitable;
    }

    public void clear() {
        this.activePoliciesByName.clear();
    }
}

