/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;

public class FileDiffList
extends AbstractINodeDiffList<INodeFile, INodeFileAttributes, FileDiff> {
    @Override
    FileDiff createDiff(int snapshotId, INodeFile file) {
        return new FileDiff(snapshotId, file);
    }

    @Override
    INodeFileAttributes createSnapshotCopy(INodeFile currentINode) {
        return new INodeFileAttributes.SnapshotCopy(currentINode);
    }

    public void destroyAndCollectSnapshotBlocks(INode.BlocksMapUpdateInfo collectedBlocks) {
        for (FileDiff d : this.asList()) {
            d.destroyAndCollectSnapshotBlocks(collectedBlocks);
        }
    }

    public void saveSelf2Snapshot(int latestSnapshotId, INodeFile iNodeFile, INodeFileAttributes snapshotCopy, boolean withBlocks) {
        FileDiff diff = (FileDiff)super.saveSelf2Snapshot(latestSnapshotId, iNodeFile, snapshotCopy);
        if (withBlocks) {
            BlockInfo[] blks = iNodeFile.getBlocks();
            assert (blks != null);
            diff.setBlocks(blks);
        }
    }

    public BlockInfo[] findEarlierSnapshotBlocks(int snapshotId) {
        assert (snapshotId != -1) : "Wrong snapshot id";
        if (snapshotId == 0x7FFFFFFE) {
            return null;
        }
        List diffs = this.asList();
        int i = Collections.binarySearch(diffs, snapshotId);
        BlockInfo[] blocks = null;
        int n = i = i >= 0 ? i : -i - 2;
        while (i >= 0 && (blocks = ((FileDiff)diffs.get(i)).getBlocks()) == null) {
            --i;
        }
        return blocks;
    }

    public BlockInfo[] findLaterSnapshotBlocks(int snapshotId) {
        assert (snapshotId != -1) : "Wrong snapshot id";
        if (snapshotId == 0x7FFFFFFE) {
            return null;
        }
        List diffs = this.asList();
        int i = Collections.binarySearch(diffs, snapshotId);
        BlockInfo[] blocks = null;
        int n = i = i >= 0 ? i + 1 : -i - 1;
        while (i < diffs.size() && (blocks = ((FileDiff)diffs.get(i)).getBlocks()) == null) {
            ++i;
        }
        return blocks;
    }

    void combineAndCollectSnapshotBlocks(INode.ReclaimContext reclaimContext, INodeFile file, FileDiff removed) {
        int i;
        FileDiff earlierDiff;
        BlockInfo[] removedBlocks = removed.getBlocks();
        if (removedBlocks == null) {
            FileWithSnapshotFeature sf = file.getFileWithSnapshotFeature();
            assert (sf != null) : "FileWithSnapshotFeature is null";
            if (sf.isCurrentFileDeleted()) {
                sf.collectBlocksAndClear(reclaimContext, file);
            }
            return;
        }
        int p = this.getPrior(removed.getSnapshotId(), true);
        FileDiff fileDiff = earlierDiff = p == -1 ? null : (FileDiff)this.getDiffById(p);
        if (earlierDiff != null) {
            earlierDiff.setBlocks(removedBlocks);
        }
        BlockInfo[] earlierBlocks = earlierDiff == null ? new BlockInfoContiguous[]{} : earlierDiff.getBlocks();
        BlockInfo[] laterBlocks = this.findLaterSnapshotBlocks(removed.getSnapshotId());
        laterBlocks = laterBlocks == null ? file.getBlocks() : laterBlocks;
        for (i = 0; i < removedBlocks.length && (i < earlierBlocks.length && removedBlocks[i] == earlierBlocks[i] || i < laterBlocks.length && removedBlocks[i] == laterBlocks[i]); ++i) {
        }
        BlockInfo lastBlock = file.getLastBlock();
        Block dontRemoveBlock = null;
        if (lastBlock != null && lastBlock.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.UNDER_RECOVERY)) {
            dontRemoveBlock = lastBlock.getUnderConstructionFeature().getTruncateBlock();
        }
        while (i < removedBlocks.length) {
            if (dontRemoveBlock == null || !removedBlocks[i].equals(dontRemoveBlock)) {
                reclaimContext.collectedBlocks().addDeleteBlock(removedBlocks[i]);
            }
            ++i;
        }
    }
}

