/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Hdfs;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestResolveHdfsSymlink {
    private static final FileContextTestHelper helper = new FileContextTestHelper();
    private static MiniDFSCluster cluster = null;

    @BeforeClass
    public static void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testFcResolveAfs() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        FileContext fcLocal = FileContext.getLocalFSFileContext();
        FileContext fcHdfs = FileContext.getFileContext((URI)cluster.getFileSystem().getUri());
        String localTestRoot = helper.getAbsoluteTestRootDir(fcLocal);
        Path alphaLocalPath = new Path(fcLocal.getDefaultFileSystem().getUri().toString(), new File(localTestRoot, "alpha").getAbsolutePath());
        DFSTestUtil.createFile((FileSystem)FileSystem.getLocal((Configuration)conf), alphaLocalPath, 16L, (short)1, 2L);
        Path linkTarget = new Path(fcLocal.getDefaultFileSystem().getUri().toString(), localTestRoot);
        Path hdfsLink = new Path(fcHdfs.getDefaultFileSystem().getUri().toString(), "/tmp/link");
        fcHdfs.createSymlink(linkTarget, hdfsLink, true);
        Path alphaHdfsPathViaLink = new Path(fcHdfs.getDefaultFileSystem().getUri().toString() + "/tmp/link/alpha");
        Set afsList = fcHdfs.resolveAbstractFileSystems(alphaHdfsPathViaLink);
        Assert.assertEquals((long)2L, (long)afsList.size());
        for (AbstractFileSystem afs : afsList) {
            if (afs.equals((Object)fcHdfs.getDefaultFileSystem()) || afs.equals((Object)fcLocal.getDefaultFileSystem())) continue;
            Assert.fail((String)"Failed to resolve AFS correctly");
        }
    }

    @Test
    public void testFcDelegationToken() throws UnsupportedFileSystemException, IOException, InterruptedException {
        FileContext fcHdfs = FileContext.getFileContext((URI)cluster.getFileSystem().getUri());
        AbstractFileSystem afs = fcHdfs.getDefaultFileSystem();
        List tokenList = afs.getDelegationTokens(UserGroupInformation.getCurrentUser().getUserName());
        ((Hdfs)afs).renewDelegationToken((Token)tokenList.get(0));
        ((Hdfs)afs).cancelDelegationToken((Token)tokenList.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLinkTargetNonSymlink() throws UnsupportedFileSystemException, IOException {
        FileContext fc = null;
        Path notSymlink = new Path("/notasymlink");
        try {
            fc = FileContext.getFileContext((URI)cluster.getFileSystem().getUri());
            fc.create(notSymlink, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
            DFSClient client = new DFSClient(cluster.getFileSystem().getUri(), cluster.getConfiguration(0));
            try {
                client.getLinkTarget(notSymlink.toString());
                Assert.fail((String)"Expected exception for resolving non-symlink");
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains((String)"is not a symbolic link", (Throwable)e);
            }
        }
        finally {
            if (fc != null) {
                fc.delete(notSymlink, false);
            }
        }
    }

    @Test
    public void testLinkTargetNonExistent() throws IOException {
        Path doesNotExist = new Path("/filethatdoesnotexist");
        DFSClient client = new DFSClient(cluster.getFileSystem().getUri(), cluster.getConfiguration(0));
        try {
            client.getLinkTarget(doesNotExist.toString());
            Assert.fail((String)"Expected exception for resolving non-existent file");
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains((String)("File does not exist: " + doesNotExist.toString()), (Throwable)e);
        }
    }
}

