/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestErasureCodingPolicyWithSnapshot {
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private Configuration conf;
    private static final int SUCCESS = 0;
    private ErasureCodingPolicy ecPolicy;
    private short groupSize;

    public ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void setupCluster() throws IOException {
        this.ecPolicy = this.getEcPolicy();
        this.groupSize = (short)(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits());
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.groupSize).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
    }

    @After
    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=120000L)
    public void testSnapshotsOnErasureCodingDirsParentDir() throws Exception {
        int len = 1024;
        Path ecDirParent = new Path("/parent");
        Path ecDir = new Path(ecDirParent, "ecdir");
        Path ecFile = new Path(ecDir, "ecfile");
        this.fs.mkdirs(ecDir);
        this.fs.allowSnapshot(ecDirParent);
        this.fs.setErasureCodingPolicy(ecDir, this.ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ecFile, 1024L, (short)1, 65261L);
        String contents = DFSTestUtil.readFile((FileSystem)this.fs, ecFile);
        Path snap1 = this.fs.createSnapshot(ecDirParent, "snap1");
        Path snap1ECDir = new Path(snap1, ecDir.getName());
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap1ECDir));
        this.fs.delete(ecDir, true);
        this.fs.mkdir(ecDir, FsPermission.getDirDefault());
        Path snap2 = this.fs.createSnapshot(ecDirParent, "snap2");
        Path snap2ECDir = new Path(snap2, ecDir.getName());
        Assert.assertNull((String)"Expected null erasure coding policy", (Object)this.fs.getErasureCodingPolicy(snap2ECDir));
        this.fs.setErasureCodingPolicy(ecDir, this.ecPolicy.getName());
        Path snap3 = this.fs.createSnapshot(ecDirParent, "snap3");
        Path snap3ECDir = new Path(snap3, ecDir.getName());
        ErasureCodingPolicy ezSnap3 = this.fs.getErasureCodingPolicy(snap3ECDir);
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)ezSnap3);
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap1ECDir));
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap2ECDir));
        Path snapshottedECFile = new Path(snap1.toString() + "/" + ecDir.getName() + "/" + ecFile.getName());
        Assert.assertEquals((String)"Contents of snapshotted file have changed unexpectedly", (Object)contents, (Object)DFSTestUtil.readFile((FileSystem)this.fs, snapshottedECFile));
        this.fs.deleteSnapshot(ecDirParent, snap2.getName());
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap1ECDir));
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap3ECDir));
        this.fs.deleteSnapshot(ecDirParent, snap1.getName());
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap3ECDir));
    }

    @Test(timeout=120000L)
    public void testSnapshotsOnErasureCodingDir() throws Exception {
        Path ecDir = new Path("/ecdir");
        this.fs.mkdirs(ecDir);
        this.fs.allowSnapshot(ecDir);
        this.fs.setErasureCodingPolicy(ecDir, this.ecPolicy.getName());
        Path snap1 = this.fs.createSnapshot(ecDir, "snap1");
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap1));
    }

    @Test(timeout=120000L)
    public void testSnapshotsOnErasureCodingDirAfterNNRestart() throws Exception {
        Path ecDir = new Path("/ecdir");
        this.fs.mkdirs(ecDir);
        this.fs.allowSnapshot(ecDir);
        this.fs.setErasureCodingPolicy(ecDir, this.ecPolicy.getName());
        Path snap1 = this.fs.createSnapshot(ecDir, "snap1");
        ErasureCodingPolicy ecSnap = this.fs.getErasureCodingPolicy(snap1);
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)ecSnap);
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.restartNameNode(true);
        ErasureCodingPolicy ecSnap1 = this.fs.getErasureCodingPolicy(snap1);
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)ecSnap1);
        Assert.assertEquals((String)"Got unexpected ecSchema", (Object)ecSnap.getSchema(), (Object)ecSnap1.getSchema());
    }

    @Test(timeout=120000L)
    public void testCopySnapshotWillNotPreserveErasureCodingPolicy() throws Exception {
        int len = 1024;
        Path ecDir = new Path("/ecdir");
        Path ecFile = new Path(ecDir, "ecFile");
        this.fs.mkdirs(ecDir);
        this.fs.allowSnapshot(ecDir);
        this.fs.setErasureCodingPolicy(ecDir, this.ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ecFile, 1024L, (short)1, 65261L);
        Path snap1 = this.fs.createSnapshot(ecDir, "snap1");
        Path snap1Copy = new Path(ecDir.toString() + "-copy");
        Path snap1CopyECDir = new Path("/ecdir-copy");
        String[] argv = new String[]{"-cp", "-px", snap1.toUri().toString(), snap1Copy.toUri().toString()};
        int ret = ToolRunner.run((Tool)new FsShell(this.conf), (String[])argv);
        Assert.assertEquals((String)"cp -px is not working on a snapshot", (long)0L, (long)ret);
        Assert.assertNull((String)"Got unexpected erasure coding policy", (Object)this.fs.getErasureCodingPolicy(snap1CopyECDir));
        Assert.assertEquals((String)"Got unexpected erasure coding policy", (Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(snap1));
    }

    @Test(timeout=300000L)
    public void testFileStatusAcrossNNRestart() throws IOException {
        int len = 1024;
        Path normalFile = new Path("/", "normalFile");
        DFSTestUtil.createFile((FileSystem)this.fs, normalFile, 1024L, (short)1, 65261L);
        Path ecDir = new Path("/ecdir");
        Path ecFile = new Path(ecDir, "ecFile");
        this.fs.mkdirs(ecDir);
        this.fs.setErasureCodingPolicy(ecDir, this.ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ecFile, 1024L, (short)1, 65261L);
        ContractTestUtils.assertNotErasureCoded((FileSystem)this.fs, (Path)normalFile);
        ContractTestUtils.assertErasureCoded((FileSystem)this.fs, (Path)ecFile);
        this.cluster.restartNameNode(true);
        ContractTestUtils.assertNotErasureCoded((FileSystem)this.fs, (Path)normalFile);
        ContractTestUtils.assertErasureCoded((FileSystem)this.fs, (Path)ecFile);
    }
}

