/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;

public class TestSaslDataTransfer
extends SaslDataTransferTestCase {
    private static final int BLOCK_SIZE = 4096;
    private static final int NUM_BLOCKS = 3;
    private static final Path PATH = new Path("/file1");
    private MiniDFSCluster cluster;
    private FileSystem fs;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public Timeout timeout = new Timeout(60000);

    @After
    public void shutdown() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testAuthentication() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "authentication");
        this.doTest(clientConf);
    }

    @Test
    public void testIntegrity() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "integrity");
        this.doTest(clientConf);
    }

    @Test
    public void testPrivacy() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "privacy");
        this.doTest(clientConf);
    }

    @Test
    public void testClientAndServerDoNotHaveCommonQop() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "authentication");
        this.exception.expect(IOException.class);
        this.exception.expectMessage("could only be written to 0");
        this.doTest(clientConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerSaslNoClientSasl() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        clusterConf.setInt("dfs.client.retry.window.base", 10);
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "");
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Log)LogFactory.getLog(DataNode.class));
        try {
            this.doTest(clientConf);
            Assert.fail((String)"Should fail if SASL data transfer protection is not configured or not supported in client");
        }
        catch (IOException e) {
            GenericTestUtils.assertMatches((String)e.getMessage(), (String)"could only be written to 0");
        }
        finally {
            logs.stopCapturing();
        }
        GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"Failed to read expected SASL data transfer protection handshake from client at");
    }

    @Test
    public void testDataNodeAbortsIfNoSasl() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("");
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("Cannot start secure DataNode");
        this.startCluster(clusterConf);
    }

    @Test
    public void testDataNodeAbortsIfNotHttpsOnly() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication");
        clusterConf.set("dfs.http.policy", HttpConfig.Policy.HTTP_AND_HTTPS.name());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("Cannot start secure DataNode");
        this.startCluster(clusterConf);
    }

    @Test
    public void testNoSaslAndSecurePortsIgnored() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("");
        clusterConf.setBoolean("ignore.secure.ports.for.testing", true);
        this.startCluster(clusterConf);
        this.doTest(clusterConf);
    }

    private void doTest(HdfsConfiguration conf) throws IOException {
        this.fs = FileSystem.get((URI)this.cluster.getURI(), (Configuration)conf);
        FileSystemTestHelper.createFile((FileSystem)this.fs, (Path)PATH, (int)3, (int)4096);
        Assert.assertArrayEquals((byte[])FileSystemTestHelper.getFileData((int)3, (long)4096L), (byte[])DFSTestUtil.readFile(this.fs, PATH).getBytes("UTF-8"));
        BlockLocation[] blockLocations = this.fs.getFileBlockLocations(PATH, 0L, Long.MAX_VALUE);
        Assert.assertNotNull((Object)blockLocations);
        Assert.assertEquals((long)3L, (long)blockLocations.length);
        for (BlockLocation blockLocation : blockLocations) {
            Assert.assertNotNull((Object)blockLocation.getHosts());
            Assert.assertEquals((long)3L, (long)blockLocation.getHosts().length);
        }
    }

    private void startCluster(HdfsConfiguration conf) throws IOException {
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void TestPeerFromSocketAndKeyReadTimeout() throws Exception {
        HdfsConfiguration conf = this.createSecureConfig("authentication,integrity,privacy");
        AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
        SaslDataTransferClient saslClient = new SaslDataTransferClient((Configuration)conf, DataTransferSaslUtil.getSaslPropertiesResolver((Configuration)conf), TrustedChannelResolver.getInstance((Configuration)conf), fallbackToSimpleAuth);
        DatanodeID fakeDatanodeId = new DatanodeID("127.0.0.1", "localhost", "beefbeef-beef-beef-beef-beefbeefbeef", 1, 2, 3, 4);
        DataEncryptionKeyFactory dataEncKeyFactory = new DataEncryptionKeyFactory(){

            public DataEncryptionKey newDataEncryptionKey() {
                return new DataEncryptionKey(123, "456", new byte[8], new byte[8], 1234567L, "fakeAlgorithm");
            }
        };
        ServerSocket serverSocket = null;
        Socket socket = null;
        try {
            serverSocket = new ServerSocket(0, -1);
            socket = new Socket(serverSocket.getInetAddress(), serverSocket.getLocalPort());
            Peer peer = DFSUtilClient.peerFromSocketAndKey((SaslDataTransferClient)saslClient, (Socket)socket, (DataEncryptionKeyFactory)dataEncKeyFactory, (Token)new Token(), (DatanodeID)fakeDatanodeId, (int)1);
            peer.close();
            Assert.fail((String)"Expected DFSClient#peerFromSocketAndKey to time out.");
        }
        catch (SocketTimeoutException e) {
            try {
                GenericTestUtils.assertExceptionContains((String)"Read timed out", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{socket, serverSocket});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{socket, serverSocket});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{socket, serverSocket});
    }
}

