/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.blockmanagement.TestBlockTokenWithDFS;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.net.ServerSocketUtil;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestBlockTokenWithDFSStriped
extends TestBlockTokenWithDFS {
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int dataBlocks = this.ecPolicy.getNumDataUnits();
    private final int parityBlocks = this.ecPolicy.getNumParityUnits();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripesPerBlock = 4;
    private final int numDNs = this.dataBlocks + this.parityBlocks + 2;
    private MiniDFSCluster cluster;
    private Configuration conf;
    @Rule
    public Timeout globalTimeout;

    public TestBlockTokenWithDFSStriped() {
        BLOCK_SIZE = this.cellSize * 4;
        FILE_SIZE = BLOCK_SIZE * this.dataBlocks * 3;
        this.globalTimeout = new Timeout(300000);
    }

    private Configuration getConf() {
        Configuration conf = super.getConf(this.numDNs);
        conf.setInt("io.bytes.per.checksum", this.cellSize);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testRead() throws Exception {
        this.conf = this.getConf();
        Configuration[] overlays = new Configuration[this.numDNs];
        for (int i = 0; i < overlays.length; ++i) {
            int offset = i * 10;
            Configuration c = new Configuration();
            c.set("dfs.datanode.address", "127.0.0.1:" + ServerSocketUtil.getPort((int)(19866 + offset), (int)100));
            c.set("dfs.datanode.ipc.address", "127.0.0.1:" + ServerSocketUtil.getPort((int)(19867 + offset), (int)100));
            overlays[i] = c;
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).nameNodePort(ServerSocketUtil.getPort((int)19820, (int)100)).nameNodeHttpPort(ServerSocketUtil.getPort((int)19870, (int)100)).numDataNodes(this.numDNs).build();
        this.cluster.getFileSystem().enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
        try {
            this.cluster.waitActive();
            this.doTestRead(this.conf, this.cluster, true);
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    @Override
    @Test
    public void testWrite() {
    }

    @Override
    @Test
    public void testAppend() throws Exception {
    }

    @Override
    @Test
    public void testEnd2End() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        new TestBalancer().integrationTestWithStripedFile(conf);
    }

    @Override
    protected void tryRead(Configuration conf, LocatedBlock lblock, boolean shouldSucceed) {
        LocatedBlock[] internalBlocks;
        LocatedStripedBlock lsb = (LocatedStripedBlock)lblock;
        for (LocatedBlock internalBlock : internalBlocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)lsb, (int)this.cellSize, (int)this.dataBlocks, (int)this.parityBlocks)) {
            super.tryRead(conf, internalBlock, shouldSucceed);
        }
    }

    @Override
    protected boolean isBlockTokenExpired(LocatedBlock lb) throws IOException {
        LocatedBlock[] internalBlocks;
        LocatedStripedBlock lsb = (LocatedStripedBlock)lb;
        for (LocatedBlock internalBlock : internalBlocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)lsb, (int)this.cellSize, (int)this.dataBlocks, (int)this.parityBlocks)) {
            if (!super.isBlockTokenExpired(internalBlock)) continue;
            return true;
        }
        return false;
    }
}

