/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlockPoolSliceStorage {
    public static final Log LOG = LogFactory.getLog(TestBlockPoolSliceStorage.class);
    final Random rand = new Random();
    BlockPoolSliceStorage storage;

    private String makeRandomIpAddress() {
        return this.rand.nextInt(256) + "." + this.rand.nextInt(256) + "." + this.rand.nextInt(256) + "." + this.rand.nextInt(256);
    }

    private String makeRandomBlockpoolId() {
        return "BP-" + this.rand.nextInt(Integer.MAX_VALUE) + "-" + this.makeRandomIpAddress() + "-" + this.rand.nextInt(Integer.MAX_VALUE);
    }

    private BlockPoolSliceStorage makeBlockPoolStorage() {
        return new StubBlockPoolSliceStorage(this.rand.nextInt(Integer.MAX_VALUE), this.makeRandomBlockpoolId(), this.rand.nextInt(Integer.MAX_VALUE), UUID.randomUUID().toString());
    }

    private String makeRandomBlockFileSubdir(int nestingLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(File.separator);
        for (int i = 0; i < nestingLevel; ++i) {
            sb.append("subdir" + this.rand.nextInt(64) + File.separator);
        }
        return sb.toString();
    }

    public void getTrashDirectoryForBlockFile(String fileName, int nestingLevel) {
        String blockFileSubdir = this.makeRandomBlockFileSubdir(nestingLevel);
        String blockFileName = fileName;
        String testFilePath = this.storage.getSingularStorageDir().getRoot() + File.separator + "current" + blockFileSubdir + blockFileName;
        String expectedTrashPath = this.storage.getSingularStorageDir().getRoot() + File.separator + "trash" + blockFileSubdir.substring(0, blockFileSubdir.length() - 1);
        LOG.info((Object)("Got subdir " + blockFileSubdir));
        LOG.info((Object)("Generated file path " + testFilePath));
        ReplicaInfo info = (ReplicaInfo)Mockito.mock(ReplicaInfo.class);
        Mockito.when((Object)info.getBlockURI()).thenReturn((Object)new File(testFilePath).toURI());
        Assert.assertThat((Object)this.storage.getTrashDirectory(info), (Matcher)Is.is((Object)expectedTrashPath));
    }

    public void getRestoreDirectoryForBlockFile(String fileName, int nestingLevel) {
        BlockPoolSliceStorage storage = this.makeBlockPoolStorage();
        String blockFileSubdir = this.makeRandomBlockFileSubdir(nestingLevel);
        String blockFileName = fileName;
        String deletedFilePath = storage.getSingularStorageDir().getRoot() + File.separator + "trash" + blockFileSubdir + blockFileName;
        String expectedRestorePath = storage.getSingularStorageDir().getRoot() + File.separator + "current" + blockFileSubdir.substring(0, blockFileSubdir.length() - 1);
        LOG.info((Object)("Generated deleted file path " + deletedFilePath));
        Assert.assertThat((Object)storage.getRestoreDirectory(new File(deletedFilePath)), (Matcher)Is.is((Object)expectedRestorePath));
    }

    @Test(timeout=300000L)
    public void testGetTrashAndRestoreDirectories() {
        this.storage = this.makeBlockPoolStorage();
        for (int i = 0; i < 3; ++i) {
            this.getTrashDirectoryForBlockFile("blk_myblockfile", i);
            this.getTrashDirectoryForBlockFile("blk_myblockfile.meta", i);
            this.getRestoreDirectoryForBlockFile("blk_myblockfile", i);
            this.getRestoreDirectoryForBlockFile("blk_myblockfile.meta", i);
        }
    }

    private static class StubBlockPoolSliceStorage
    extends BlockPoolSliceStorage {
        StubBlockPoolSliceStorage(int namespaceID, String bpID, long cTime, String clusterId) {
            super(namespaceID, bpID, cTime, clusterId);
            this.addStorageDir(new Storage.StorageDirectory(new File("/tmp/dontcare/" + bpID)));
            Assert.assertThat((Object)this.getStorageDirs().size(), (Matcher)Is.is((Object)1));
        }
    }
}

