/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import org.apache.hadoop.conf.Configuration;

public class RouterConfigBuilder {
    private Configuration conf;
    private boolean enableRpcServer = false;
    private boolean enableAdminServer = false;
    private boolean enableHttpServer = false;
    private boolean enableHeartbeat = false;
    private boolean enableLocalHeartbeat = false;
    private boolean enableStateStore = false;
    private boolean enableMetrics = false;

    public RouterConfigBuilder(Configuration configuration) {
        this.conf = configuration;
    }

    public RouterConfigBuilder() {
        this.conf = new Configuration(false);
    }

    public RouterConfigBuilder all() {
        this.enableRpcServer = true;
        this.enableAdminServer = true;
        this.enableHttpServer = true;
        this.enableHeartbeat = true;
        this.enableLocalHeartbeat = true;
        this.enableStateStore = true;
        this.enableMetrics = true;
        return this;
    }

    public RouterConfigBuilder enableLocalHeartbeat(boolean enable) {
        this.enableLocalHeartbeat = enable;
        return this;
    }

    public RouterConfigBuilder rpc(boolean enable) {
        this.enableRpcServer = enable;
        return this;
    }

    public RouterConfigBuilder admin(boolean enable) {
        this.enableAdminServer = enable;
        return this;
    }

    public RouterConfigBuilder http(boolean enable) {
        this.enableHttpServer = enable;
        return this;
    }

    public RouterConfigBuilder heartbeat(boolean enable) {
        this.enableHeartbeat = enable;
        return this;
    }

    public RouterConfigBuilder stateStore(boolean enable) {
        this.enableStateStore = enable;
        return this;
    }

    public RouterConfigBuilder metrics(boolean enable) {
        this.enableMetrics = enable;
        return this;
    }

    public RouterConfigBuilder rpc() {
        return this.rpc(true);
    }

    public RouterConfigBuilder admin() {
        return this.admin(true);
    }

    public RouterConfigBuilder http() {
        return this.http(true);
    }

    public RouterConfigBuilder heartbeat() {
        return this.heartbeat(true);
    }

    public RouterConfigBuilder stateStore() {
        return this.stateStore(true);
    }

    public RouterConfigBuilder metrics() {
        return this.metrics(true);
    }

    public Configuration build() {
        this.conf.setBoolean("dfs.federation.router.store.enable", this.enableStateStore);
        this.conf.setBoolean("dfs.federation.router.rpc.enable", this.enableRpcServer);
        this.conf.setBoolean("dfs.federation.router.admin.enable", this.enableAdminServer);
        this.conf.setBoolean("dfs.federation.router.http.enable", this.enableHttpServer);
        this.conf.setBoolean("dfs.federation.router.heartbeat.enable", this.enableHeartbeat);
        this.conf.setBoolean("dfs.federation.router.monitor.localnamenode.enable", this.enableLocalHeartbeat);
        this.conf.setBoolean("dfs.federation.router.metrics.enable", this.enableMetrics);
        return this.conf;
    }
}

