/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class TestMetricsBase {
    private StateStoreService stateStore;
    private MembershipStore membershipStore;
    private Router router;
    private Configuration routerConfig;
    private List<MembershipState> activeMemberships;
    private List<MembershipState> standbyMemberships;
    private List<MountTable> mockMountTable;
    private List<String> nameservices;

    @Before
    public void setupBase() throws Exception {
        if (this.router == null) {
            this.routerConfig = new RouterConfigBuilder().stateStore().metrics().http().build();
            this.router = new Router();
            this.router.init(this.routerConfig);
            this.router.setRouterId("routerId");
            this.router.start();
            this.stateStore = this.router.getStateStore();
            this.membershipStore = (MembershipStore)this.stateStore.getRegisteredRecordStore(MembershipStore.class);
            FederationStateStoreTestUtils.waitStateStore(this.stateStore, 10000L);
            this.createFixtures();
            this.stateStore.refreshCaches(true);
            Thread.sleep(1000L);
        }
    }

    @After
    public void tearDownBase() throws IOException {
        if (this.router != null) {
            this.router.stop();
            this.router.close();
            this.router = null;
        }
    }

    private void createFixtures() throws IOException {
        FederationStateStoreTestUtils.clearAllRecords(this.stateStore);
        this.nameservices = new ArrayList<String>();
        this.nameservices.add(FederationTestUtils.NAMESERVICES[0]);
        this.nameservices.add(FederationTestUtils.NAMESERVICES[1]);
        this.activeMemberships = new ArrayList<MembershipState>();
        this.standbyMemberships = new ArrayList<MembershipState>();
        for (String nameservice : this.nameservices) {
            MembershipState namenode1 = FederationStateStoreTestUtils.createMockRegistrationForNamenode(nameservice, FederationTestUtils.NAMENODES[0], FederationNamenodeServiceState.ACTIVE);
            NamenodeHeartbeatRequest request1 = NamenodeHeartbeatRequest.newInstance((MembershipState)namenode1);
            Assert.assertTrue((boolean)this.membershipStore.namenodeHeartbeat(request1).getResult());
            this.activeMemberships.add(namenode1);
            MembershipState namenode2 = FederationStateStoreTestUtils.createMockRegistrationForNamenode(nameservice, FederationTestUtils.NAMENODES[1], FederationNamenodeServiceState.STANDBY);
            NamenodeHeartbeatRequest request2 = NamenodeHeartbeatRequest.newInstance((MembershipState)namenode2);
            Assert.assertTrue((boolean)this.membershipStore.namenodeHeartbeat(request2).getResult());
            this.standbyMemberships.add(namenode2);
        }
        this.mockMountTable = FederationStateStoreTestUtils.createMockMountTable(this.nameservices);
        FederationStateStoreTestUtils.synchronizeRecords(this.stateStore, this.mockMountTable, MountTable.class);
    }

    protected Router getRouter() {
        return this.router;
    }

    protected List<MountTable> getMockMountTable() {
        return this.mockMountTable;
    }

    protected List<MembershipState> getActiveMemberships() {
        return this.activeMemberships;
    }

    protected List<MembershipState> getStandbyMemberships() {
        return this.standbyMemberships;
    }

    protected List<String> getNameservices() {
        return this.nameservices;
    }

    protected StateStoreService getStateStore() {
        return this.stateStore;
    }
}

