/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.service.Service;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestNamenodeHeartbeat {
    private static RouterDFSCluster cluster;
    private static ActiveNamenodeResolver namenodeResolver;
    private static List<NamenodeHeartbeatService> services;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new RouterDFSCluster(true, 2);
        cluster.startCluster();
        List<String> nss = cluster.getNameservices();
        String ns = nss.get(0);
        Configuration conf = cluster.generateNamenodeConfiguration(ns);
        namenodeResolver = new MockResolver(conf);
        namenodeResolver.setRouterId("testrouter");
        services = new ArrayList<NamenodeHeartbeatService>();
        for (RouterDFSCluster.NamenodeContext nn : cluster.getNamenodes()) {
            String nsId = nn.getNameserviceId();
            String nnId = nn.getNamenodeId();
            NamenodeHeartbeatService service = new NamenodeHeartbeatService(namenodeResolver, nsId, nnId);
            service.init(conf);
            service.start();
            services.add(service);
        }
    }

    @AfterClass
    public static void tearDown() throws IOException {
        cluster.shutdown();
        for (NamenodeHeartbeatService service : services) {
            service.stop();
            service.close();
        }
    }

    @Test
    public void testNamenodeHeartbeatService() throws IOException {
        RouterDFSCluster testCluster = new RouterDFSCluster(true, 1);
        Configuration heartbeatConfig = testCluster.generateNamenodeConfiguration(FederationTestUtils.NAMESERVICES[0]);
        NamenodeHeartbeatService server = new NamenodeHeartbeatService(namenodeResolver, FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0]);
        server.init(heartbeatConfig);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)server.getServiceState());
        server.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)server.getServiceState());
        server.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)server.getServiceState());
        server.close();
    }

    @Test
    public void testHearbeat() throws InterruptedException, IOException {
        if (cluster.isHighAvailability()) {
            for (String ns : cluster.getNameservices()) {
                cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
            }
        }
        Thread.sleep(5000L);
        for (String ns : cluster.getNameservices()) {
            List nns = namenodeResolver.getNamenodesForNameserviceId(ns);
            FederationNamenodeContext active = (FederationNamenodeContext)nns.get(0);
            Assert.assertEquals((Object)FederationTestUtils.NAMENODES[0], (Object)active.getNamenodeId());
            FederationNamenodeContext standby = (FederationNamenodeContext)nns.get(1);
            Assert.assertEquals((Object)FederationTestUtils.NAMENODES[1], (Object)standby.getNamenodeId());
        }
        List<String> nss = cluster.getNameservices();
        String failoverNS = nss.get(0);
        String normalNs = nss.get(1);
        cluster.switchToStandby(failoverNS, FederationTestUtils.NAMENODES[0]);
        cluster.switchToActive(failoverNS, FederationTestUtils.NAMENODES[1]);
        Thread.sleep(5000L);
        List failoverNSs = namenodeResolver.getNamenodesForNameserviceId(failoverNS);
        FederationNamenodeContext active = (FederationNamenodeContext)failoverNSs.get(0);
        Assert.assertEquals((Object)FederationTestUtils.NAMENODES[1], (Object)active.getNamenodeId());
        FederationNamenodeContext standby = (FederationNamenodeContext)failoverNSs.get(1);
        Assert.assertEquals((Object)FederationTestUtils.NAMENODES[0], (Object)standby.getNamenodeId());
        List normalNss = namenodeResolver.getNamenodesForNameserviceId(normalNs);
        active = (FederationNamenodeContext)normalNss.get(0);
        Assert.assertEquals((Object)FederationTestUtils.NAMENODES[0], (Object)active.getNamenodeId());
        standby = (FederationNamenodeContext)normalNss.get(1);
        Assert.assertEquals((Object)FederationTestUtils.NAMENODES[1], (Object)standby.getNamenodeId());
    }
}

