/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.service.Service;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouter {
    private static Configuration conf;

    @BeforeClass
    public static void create() throws IOException {
        conf = new Configuration();
        conf.setInt("dfs.federation.router.cache.ttl", 1);
        conf.setClass("dfs.federation.router.namenode.resolver.client.class", MockResolver.class, ActiveNamenodeResolver.class);
        conf.setClass("dfs.federation.router.file.resolver.client.class", MockResolver.class, FileSubclusterResolver.class);
        conf.set("dfs.federation.router.rpc-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.rpc-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.admin-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.admin-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.http-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.https-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.http-bind-host", "0.0.0.0");
        conf.set("dfs.nameservices", "ns0");
        conf.set("fs.defaultFS", "hdfs://ns0");
        conf.set("dfs.namenode.rpc-address.ns0", "127.0.0.1:00");
        conf.set("dfs.namenode.http-address.ns0", "127.0.0.1:0");
        conf.set("dfs.namenode.rpc-bind-host.ns0", "0.0.0.0");
    }

    @AfterClass
    public static void destroy() {
    }

    @Before
    public void setup() throws IOException, URISyntaxException {
    }

    @After
    public void cleanup() {
    }

    private static void testRouterStartup(Configuration routerConfig) throws InterruptedException, IOException {
        Router router = new Router();
        Assert.assertEquals((Object)Service.STATE.NOTINITED, (Object)router.getServiceState());
        router.init(routerConfig);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)router.getServiceState());
        router.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)router.getServiceState());
        router.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)router.getServiceState());
        router.close();
    }

    @Test
    public void testRouterService() throws InterruptedException, IOException {
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).admin().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).http().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).rpc().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).metrics().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).stateStore().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).heartbeat().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).all().build());
    }

    @Test
    public void testRouterRestartRpcService() throws IOException {
        Router router = new Router();
        router.init(new RouterConfigBuilder(conf).rpc().build());
        router.start();
        Assert.assertNotNull((Object)router.getRpcServerAddress());
        RouterRpcServer rpcServer = router.getRpcServer();
        Assert.assertNotNull((Object)rpcServer);
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)rpcServer.getServiceState());
        router.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)rpcServer.getServiceState());
        router.close();
    }
}

