/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.RouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterRpc {
    private static RouterDFSCluster cluster;
    private RouterDFSCluster.RouterContext router;
    private String ns;
    private RouterDFSCluster.NamenodeContext namenode;
    private ClientProtocol routerProtocol;
    private ClientProtocol nnProtocol;
    private FileSystem routerFS;
    private FileSystem nnFS;
    private String routerFile;
    private String nnFile;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new RouterDFSCluster(false, 2);
        cluster.startCluster();
        cluster.addRouterOverrides(new RouterConfigBuilder().rpc().build());
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    @Before
    public void testSetup() throws Exception {
        cluster.installMockLocations();
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        this.router = cluster.getRandomRouter();
        this.ns = cluster.getRandomNameservice();
        this.namenode = cluster.getNamenode(this.ns, null);
        this.routerProtocol = this.router.getClient().getNamenode();
        this.nnProtocol = this.namenode.getClient().getNamenode();
        this.nnFS = this.namenode.getFileSystem();
        this.routerFS = this.router.getFileSystem();
        Random r = new Random();
        String randomFile = "testfile-" + r.nextInt();
        this.nnFile = cluster.getNamenodeTestDirectoryForNS(this.ns) + "/" + randomFile;
        this.routerFile = cluster.getFederatedTestDirectoryForNS(this.ns) + "/" + randomFile;
        FederationTestUtils.createFile(this.nnFS, this.nnFile, 32L);
        FederationTestUtils.verifyFileExists(this.nnFS, this.nnFile);
    }

    @Test
    public void testRpcService() throws IOException {
        Router testRouter = new Router();
        List<String> nss = cluster.getNameservices();
        String ns0 = nss.get(0);
        Configuration routerConfig = cluster.generateRouterConfiguration(ns0, null);
        RouterRpcServer server = new RouterRpcServer(routerConfig, testRouter, testRouter.getNamenodeResolver(), testRouter.getSubclusterResolver());
        server.init(routerConfig);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)server.getServiceState());
        server.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)server.getServiceState());
        server.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)server.getServiceState());
        server.close();
        testRouter.close();
    }

    protected RouterDFSCluster getCluster() {
        return cluster;
    }

    protected RouterDFSCluster.RouterContext getRouterContext() {
        return this.router;
    }

    protected void setRouter(RouterDFSCluster.RouterContext r) throws IOException, URISyntaxException {
        this.router = r;
        this.routerProtocol = r.getClient().getNamenode();
        this.routerFS = r.getFileSystem();
    }

    protected FileSystem getRouterFileSystem() {
        return this.routerFS;
    }

    protected FileSystem getNamenodeFileSystem() {
        return this.nnFS;
    }

    protected ClientProtocol getRouterProtocol() {
        return this.routerProtocol;
    }

    protected ClientProtocol getNamenodeProtocol() {
        return this.nnProtocol;
    }

    protected RouterDFSCluster.NamenodeContext getNamenode() {
        return this.namenode;
    }

    protected void setNamenodeFile(String filename) {
        this.nnFile = filename;
    }

    protected String getNamenodeFile() {
        return this.nnFile;
    }

    protected void setRouterFile(String filename) {
        this.routerFile = filename;
    }

    protected String getRouterFile() {
        return this.routerFile;
    }

    protected void setNamenode(RouterDFSCluster.NamenodeContext nn) throws IOException, URISyntaxException {
        this.namenode = nn;
        this.nnProtocol = nn.getClient().getNamenode();
        this.nnFS = nn.getFileSystem();
    }

    protected String getNs() {
        return this.ns;
    }

    protected void setNs(String nameservice) {
        this.ns = nameservice;
    }

    protected static void compareResponses(ClientProtocol protocol1, ClientProtocol protocol2, Method m, Object[] paramList) {
        Object return1 = null;
        Exception exception1 = null;
        try {
            return1 = m.invoke((Object)protocol1, paramList);
        }
        catch (Exception ex) {
            exception1 = ex;
        }
        Object return2 = null;
        Exception exception2 = null;
        try {
            return2 = m.invoke((Object)protocol2, paramList);
        }
        catch (Exception ex) {
            exception2 = ex;
        }
        Assert.assertEquals((Object)return1, (Object)return2);
        if (exception1 == null && exception2 == null) {
            return;
        }
        Assert.assertEquals(exception1.getCause().getClass(), exception2.getCause().getClass());
    }

    @Test
    public void testProxyListFiles() throws IOException, InterruptedException, URISyntaxException, NoSuchMethodException, SecurityException {
        FileStatus[] iterator;
        TreeSet<String> requiredPaths = new TreeSet<String>();
        FileSubclusterResolver fileResolver = this.router.getRouter().getSubclusterResolver();
        for (String mount : fileResolver.getMountPoints("/")) {
            requiredPaths.add(mount);
        }
        String defaultNs = cluster.getNameservices().get(0);
        RouterDFSCluster.NamenodeContext nn = cluster.getNamenode(defaultNs, null);
        for (FileStatus file : iterator = nn.getFileSystem().listStatus(new Path("/"))) {
            requiredPaths.add(file.getPath().getName());
        }
        DirectoryListing listing = this.routerProtocol.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
        Iterator requiredPathsIterator = requiredPaths.iterator();
        for (HdfsFileStatus f : listing.getPartialListing()) {
            String fileName = (String)requiredPathsIterator.next();
            String currentFile = f.getFullPath(new Path("/")).getName();
            Assert.assertEquals((Object)currentFile, (Object)fileName);
        }
        Assert.assertEquals((long)requiredPaths.size(), (long)listing.getPartialListing().length);
        Method m = ClientProtocol.class.getMethod("getListing", String.class, byte[].class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, HdfsFileStatus.EMPTY_NAME, false});
    }

    @Test
    public void testProxyListFilesWithConflict() throws IOException, InterruptedException {
        RouterDFSCluster.NamenodeContext nn = cluster.getNamenode(this.ns, null);
        FileSystem nnFs = nn.getFileSystem();
        FederationTestUtils.addDirectory(nnFs, cluster.getFederatedTestDirectoryForNS(this.ns));
        FileSystem routerFs = this.router.getFileSystem();
        int initialCount = FederationTestUtils.countContents(routerFs, "/");
        int newCount = FederationTestUtils.countContents(routerFs, "/");
        Assert.assertEquals((long)initialCount, (long)newCount);
        Assert.assertEquals((long)1L, (long)FederationTestUtils.countContents(routerFs, cluster.getFederatedPathForNS(this.ns)));
        Assert.assertEquals((long)1L, (long)FederationTestUtils.countContents(nnFs, cluster.getNamenodePathForNS(this.ns)));
    }

    protected void testRename(RouterDFSCluster.RouterContext testRouter, String filename, String renamedFile, boolean exceptionExpected) throws IOException {
        FileContext fileContext;
        FederationTestUtils.createFile(testRouter.getFileSystem(), filename, 32L);
        FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), filename);
        boolean exceptionThrown = false;
        try {
            DFSClient client = testRouter.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(filename, renamedFile);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        if (exceptionExpected) {
            Assert.assertTrue((boolean)exceptionThrown);
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(filename), true));
        } else {
            Assert.assertFalse((boolean)exceptionThrown);
            Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedFile));
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(renamedFile), true));
        }
    }

    protected void testRename2(RouterDFSCluster.RouterContext testRouter, String filename, String renamedFile, boolean exceptionExpected) throws IOException {
        FileContext fileContext;
        FederationTestUtils.createFile(testRouter.getFileSystem(), filename, 32L);
        FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), filename);
        boolean exceptionThrown = false;
        try {
            DFSClient client = testRouter.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(filename, renamedFile, new Options.Rename[0]);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        Assert.assertEquals((Object)exceptionExpected, (Object)exceptionThrown);
        if (exceptionExpected) {
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(filename), true));
        } else {
            Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedFile));
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(renamedFile), true));
        }
    }

    @Test
    public void testProxyRenameFiles() throws IOException, InterruptedException {
        Thread.sleep(5000L);
        List<String> nss = cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String filename = cluster.getFederatedTestDirectoryForNS(ns0) + "/testrename";
        String renamedFile = filename + "-append";
        this.testRename(this.router, filename, renamedFile, false);
        this.testRename2(this.router, filename, renamedFile, false);
        filename = cluster.getFederatedTestDirectoryForNS(ns0) + "/testrename";
        renamedFile = cluster.getFederatedTestDirectoryForNS(ns1) + "/testrename";
        this.testRename(this.router, filename, renamedFile, true);
        this.testRename2(this.router, filename, renamedFile, true);
    }

    @Test
    public void testProxyChownFiles() throws Exception {
        String newUsername = "TestUser";
        String newGroup = "TestGroup";
        this.routerProtocol.setOwner(this.routerFile, newUsername, newGroup);
        FileStatus file = FederationTestUtils.getFileStatus(this.namenode.getFileSystem(), this.nnFile);
        Assert.assertEquals((Object)file.getOwner(), (Object)newUsername);
        Assert.assertEquals((Object)file.getGroup(), (Object)newGroup);
        Method m = ClientProtocol.class.getMethod("setOwner", String.class, String.class, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, newUsername, newGroup});
    }

    @Test
    public void testProxyGetStats() throws Exception {
        long[] combinedData = this.routerProtocol.getStats();
        long[] individualData = new long[10];
        for (String nameservice : cluster.getNameservices()) {
            RouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            long[] data = clientProtocol.getStats();
            for (int i = 0; i < data.length; ++i) {
                int n2 = i;
                individualData[n2] = individualData[n2] + data[i];
            }
            assert (data.length == combinedData.length);
        }
        for (int i = 0; i < combinedData.length && i < individualData.length; ++i) {
            if (i == 2) continue;
            Assert.assertEquals((long)combinedData[i], (long)individualData[i]);
        }
    }

    @Test
    public void testProxyGetDatanodeReport() throws Exception {
        DatanodeInfo[] combinedData = this.routerProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        HashSet<Integer> individualData = new HashSet<Integer>();
        for (String nameservice : cluster.getNameservices()) {
            RouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            DatanodeInfo[] data = clientProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
            for (int i = 0; i < data.length; ++i) {
                DatanodeInfo info = data[i];
                individualData.add(info.getXferPort());
            }
        }
        Assert.assertEquals((long)combinedData.length, (long)individualData.size());
    }

    @Test
    public void testProxyGetDatanodeStorageReport() throws IOException, InterruptedException, URISyntaxException {
        DatanodeStorageReport[] combinedData = this.routerProtocol.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL);
        HashSet<String> individualData = new HashSet<String>();
        for (String nameservice : cluster.getNameservices()) {
            DatanodeStorageReport[] data;
            RouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            for (DatanodeStorageReport report : data = clientProtocol.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL)) {
                DatanodeInfo dn = report.getDatanodeInfo();
                individualData.add(dn.toString());
            }
        }
        Assert.assertEquals((long)combinedData.length, (long)individualData.size());
    }

    @Test
    public void testProxyMkdir() throws Exception {
        Object[] filesInitial = this.routerFS.listStatus(new Path("/"));
        String dirPath = "/testdir";
        FsPermission permission = new FsPermission("705");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        Object[] files = this.routerFS.listStatus(new Path("/"));
        Assert.assertEquals((String)(Arrays.toString(files) + " should be " + Arrays.toString(filesInitial) + " + " + dirPath), (long)(filesInitial.length + 1), (long)files.length);
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
        int foundCount = 0;
        for (RouterDFSCluster.NamenodeContext n : cluster.getNamenodes()) {
            if (!FederationTestUtils.verifyFileExists(n.getFileSystem(), dirPath)) continue;
            ++foundCount;
        }
        Assert.assertEquals((long)1L, (long)foundCount);
        Assert.assertTrue((boolean)FederationTestUtils.deleteFile(this.routerFS, dirPath));
        Method m = ClientProtocol.class.getMethod("mkdirs", String.class, FsPermission.class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, permission, false});
    }

    @Test
    public void testProxyChmodFiles() throws Exception {
        FsPermission permission = new FsPermission("444");
        this.routerProtocol.setPermission(this.routerFile, permission);
        FileStatus file = FederationTestUtils.getFileStatus(this.namenode.getFileSystem(), this.nnFile);
        Assert.assertEquals((Object)permission, (Object)file.getPermission());
        Method m = ClientProtocol.class.getMethod("setPermission", String.class, FsPermission.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, permission});
    }

    @Test
    public void testProxySetReplication() throws Exception {
        FileStatus file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertEquals((long)1L, (long)file.getReplication());
        this.routerProtocol.setReplication(this.routerFile, (short)2);
        file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertEquals((long)2L, (long)file.getReplication());
        Method m = ClientProtocol.class.getMethod("setReplication", String.class, Short.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, (short)2});
    }

    @Test
    public void testProxyTruncateFile() throws Exception {
        FileStatus file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertTrue((file.getLen() > 0L ? 1 : 0) != 0);
        this.routerProtocol.truncate(this.routerFile, 0L, "testclient");
        file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertEquals((long)0L, (long)file.getLen());
        Method m = ClientProtocol.class.getMethod("truncate", String.class, Long.TYPE, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, 0L, "testclient"});
    }

    @Test
    public void testProxyGetBlockLocations() throws Exception {
        LocatedBlocks locations = this.routerProtocol.getBlockLocations(this.routerFile, 0L, 1024L);
        Assert.assertEquals((long)1L, (long)locations.getLocatedBlocks().size());
        Method m = ClientProtocol.class.getMethod("getBlockLocations", String.class, Long.TYPE, Long.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, 0L, 0L});
    }

    @Test
    public void testProxyStoragePolicy() throws Exception {
        HdfsFileStatus status = this.namenode.getClient().getFileInfo(this.nnFile);
        BlockStoragePolicy[] policies = this.namenode.getClient().getStoragePolicies();
        BlockStoragePolicy policy = policies[0];
        while (policy.isCopyOnCreateFile()) {
            Random rand = new Random();
            int randIndex = rand.nextInt(policies.length);
            policy = policies[randIndex];
        }
        this.routerProtocol.setStoragePolicy(this.routerFile, policy.getName());
        HdfsFileStatus newStatus = this.namenode.getClient().getFileInfo(this.nnFile);
        Assert.assertTrue((newStatus.getStoragePolicy() == policy.getId() ? 1 : 0) != 0);
        Assert.assertTrue((newStatus.getStoragePolicy() != status.getStoragePolicy() ? 1 : 0) != 0);
        Method m = ClientProtocol.class.getMethod("setStoragePolicy", String.class, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, "badpolicy"});
    }

    @Test
    public void testProxyGetPreferedBlockSize() throws Exception {
        long namenodeSize = this.nnProtocol.getPreferredBlockSize(this.nnFile);
        long routerSize = this.routerProtocol.getPreferredBlockSize(this.routerFile);
        Assert.assertEquals((long)routerSize, (long)namenodeSize);
        Method m = ClientProtocol.class.getMethod("getPreferredBlockSize", String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath});
    }

    private void testConcat(String source, String target, boolean failureExpected) {
        boolean failure = false;
        try {
            this.routerProtocol.concat(target, new String[]{source});
        }
        catch (IOException ex) {
            failure = true;
        }
        Assert.assertEquals((Object)failureExpected, (Object)failure);
    }

    @Test
    public void testProxyConcatFile() throws Exception {
        String sameNameservice = this.ns;
        String existingFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_concatfile";
        int existingFileSize = 32;
        FederationTestUtils.createFile(this.routerFS, existingFile, existingFileSize);
        String alternateNameservice = null;
        for (String n : cluster.getNameservices()) {
            if (n.equals(sameNameservice)) continue;
            alternateNameservice = n;
            break;
        }
        String altRouterFile = cluster.getFederatedTestDirectoryForNS(alternateNameservice) + "_newfile";
        String sameRouterFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_newfile";
        FederationTestUtils.createFile(this.routerFS, altRouterFile, 0x8000000L);
        FederationTestUtils.createFile(this.routerFS, sameRouterFile, 0x8000000L);
        this.testConcat(existingFile, altRouterFile, true);
        this.testConcat(existingFile, sameRouterFile, false);
        FileStatus status = FederationTestUtils.getFileStatus(this.routerFS, sameRouterFile);
        Assert.assertEquals((long)((long)existingFileSize + 0x8000000L), (long)status.getLen());
        Method m = ClientProtocol.class.getMethod("concat", String.class, String[].class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, new String[]{this.routerFile}});
    }

    @Test
    public void testProxyAppend() throws Exception {
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.APPEND);
        DFSClient routerClient = this.getRouterContext().getClient();
        HdfsDataOutputStream stream = routerClient.append(this.routerFile, 1024, createFlag, null, null);
        stream.writeBytes("teststring");
        stream.close();
        FileStatus status = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertTrue((status.getLen() > (long)"teststring".length() ? 1 : 0) != 0);
        Method m = ClientProtocol.class.getMethod("append", String.class, String.class, EnumSetWritable.class);
        String badPath = "/unknownlocation/unknowndir";
        EnumSetWritable createFlagWritable = new EnumSetWritable(createFlag);
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, "testClient", createFlagWritable});
    }

    @Test
    public void testProxyGetAdditionalDatanode() throws IOException, InterruptedException, URISyntaxException {
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE);
        String clientName = this.getRouterContext().getClient().getClientName();
        String newRouterFile = this.routerFile + "_additionalDatanode";
        HdfsFileStatus status = this.routerProtocol.create(newRouterFile, new FsPermission("777"), clientName, new EnumSetWritable(createFlag), true, (short)1, 1024L, CryptoProtocolVersion.supported(), null);
        LocatedBlock block = this.routerProtocol.addBlock(newRouterFile, clientName, null, null, status.getFileId(), null, null);
        DatanodeInfo[] exclusions = new DatanodeInfo[]{};
        LocatedBlock newBlock = this.routerProtocol.getAdditionalDatanode(newRouterFile, status.getFileId(), block.getBlock(), block.getLocations(), block.getStorageIDs(), exclusions, 1, clientName);
        Assert.assertNotNull((Object)newBlock);
    }

    @Test
    public void testProxyCreateFileAlternateUser() throws IOException, URISyntaxException, InterruptedException {
        String routerDir = cluster.getFederatedTestDirectoryForNS(this.ns);
        String namenodeDir = cluster.getNamenodeTestDirectoryForNS(this.ns);
        String newRouterFile = routerDir + "/unknownuser";
        String newNamenodeFile = namenodeDir + "/unknownuser";
        String username = "unknownuser";
        this.namenode.getFileContext().setPermission(new Path(namenodeDir), new FsPermission("777"));
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)username);
        DFSClient client = this.getRouterContext().getClient(ugi);
        client.create(newRouterFile, true);
        FileStatus status = FederationTestUtils.getFileStatus(this.nnFS, newNamenodeFile);
        Assert.assertEquals((Object)status.getOwner(), (Object)username);
    }

    @Test
    public void testProxyGetFileInfoAcessException() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"unknownuser");
        Exception nnFailure = null;
        try {
            String testFile = cluster.getNamenodeTestFileForNS(this.ns);
            this.namenode.getClient(ugi).getLocatedBlocks(testFile, 0L);
        }
        catch (Exception e) {
            nnFailure = e;
        }
        Assert.assertNotNull((Object)nnFailure);
        Exception routerFailure = null;
        try {
            String testFile = cluster.getFederatedTestFileForNS(this.ns);
            this.getRouterContext().getClient(ugi).getLocatedBlocks(testFile, 0L);
        }
        catch (Exception e) {
            routerFailure = e;
        }
        Assert.assertNotNull((Object)routerFailure);
        Assert.assertEquals(routerFailure.getClass(), nnFailure.getClass());
    }
}

