/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreZooKeeperImpl;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStateStoreZK
extends TestStateStoreDriverBase {
    private static TestingServer curatorTestingServer;
    private static CuratorFramework curatorFramework;

    @BeforeClass
    public static void setupCluster() throws Exception {
        curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        String connectString = curatorTestingServer.getConnectString();
        curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        curatorFramework.start();
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreZooKeeperImpl.class);
        conf.set("hadoop.zk.address", connectString);
        conf.setLong("dfs.federation.router.store.connection.test", TimeUnit.HOURS.toMillis(1L));
        TestStateStoreZK.getStateStore(conf);
    }

    @AfterClass
    public static void tearDownCluster() {
        curatorFramework.close();
        try {
            curatorTestingServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Before
    public void startup() throws IOException {
        TestStateStoreZK.removeAll(this.getStateStoreDriver());
    }

    @Test
    public void testInsert() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testUpdate() throws IllegalArgumentException, ReflectiveOperationException, IOException, SecurityException {
        this.testPut(this.getStateStoreDriver());
    }

    @Test
    public void testDelete() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testRemove(this.getStateStoreDriver());
    }

    @Test
    public void testFetchErrors() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testFetchErrors(this.getStateStoreDriver());
    }
}

